/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.datastone.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.datastone.model.DataStone;
import br.com.system.app.features.datastone.model.DataStoneContato;
import br.com.system.app.features.datastone.model.DataStoneContatoTipoEnum;
import br.com.system.app.features.datastone.model.DataStoneSocios;
import br.com.system.app.features.datastone.repository.DataStoneRepository;
import br.com.system.app.features.datastone.service.DataStonecontatoDTO;
import br.com.system.app.features.enriquecimento.model.Enriquecimento;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoItensService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingAtividade;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pessoa.model.Pessoa;
import br.com.system.app.features.portabilidade.model.Portabilidade;
import br.com.system.app.features.portabilidade.service.OperadoraService;
import br.com.system.app.features.portabilidade.service.PortabilidadeConsultaService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.vivo.model.VivoProspectBiEstrutura;
import br.com.system.app.features.vivo.service.VivoProspectBiService;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStoneService {
    private Logger logger = LoggerFactory.getLogger(DataStoneService.class);
    @Autowired
    private MailingService mailingService;
    @Autowired
    private CreditosService creditosService;
    @Autowired
    private EstruturaTipoService estruturaTipoService;
    @Autowired
    private OperadoraService operadoraService;
    @Autowired
    private PortabilidadeConsultaService portabilidadeConsultaService;
    @Autowired
    private EnriquecimentoItensService enriquecimentoItensService;
    @Autowired
    private VivoProspectBiService prospectBiService;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private DataStoneRepository dataStoneRepository;

    public DataStone getByCpfCnpj(String cpfCnpj) {
        return this.dataStoneRepository.findByCpfCnpj(cpfCnpj);
    }

    public void processarCnpj(EstruturaUsuario eu, String cnpj) throws Exception {
        HashSet<String> cnpjs = new HashSet<String>();
        cnpjs.add(cnpj);
        this.processarLote(eu, cnpjs, cnpj + ".xlxs", Boolean.valueOf(false));
    }

    public String processarLote(EstruturaUsuario eu, Set<String> cnpjs, String nomeArquivo, Boolean consultaWhats) throws Exception {
        return this.processarLote(eu, cnpjs, nomeArquivo, null, consultaWhats);
    }

    public String processarLote(EstruturaUsuario eu, Set<String> cnpjs, String nomeArquivo, Enriquecimento enriquecimento, Boolean consultaWhats) throws Exception {
        EstruturaComplemento compl = this.estruturaComplementoService.getComplementos(eu.getEstrutura());
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = this.estruturaTipoService.isVivo(eu.getEstrutura()) ? StorageUtil.getObjectModelo((String)"ExportacaoDataStoneVivo-v2.xlsx") : (this.estruturaTipoService.isTelefonia(eu.getEstrutura()) ? StorageUtil.getObjectModelo((String)"ExportacaoDataStoneTel-v2.xlsx") : StorageUtil.getObjectModelo((String)"ExportacaoDataStone-v2.xlsx"));
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int ind = 1;
            for (String cpfCnpj : cnpjs) {
                try {
                    if (enriquecimento != null && !this.creditosService.temCredito(eu, compl.getValorEnriquecimento())) {
                        aba.getRow(ind).createCell(0).setCellValue(cpfCnpj);
                        aba.getRow(ind).createCell(1).setCellValue("Sem cr\u00e9ditos");
                        continue;
                    }
                    if (!ValidationUtil.isValidCnpjAndCpf((String)cpfCnpj)) continue;
                    if (enriquecimento == null && cpfCnpj.length() == 11) {
                        aba.createRow(ind).createCell(1).setCellValue("Consulta de CPF apenas no enriquecimento");
                        ++ind;
                        continue;
                    }
                    Mailing mailing = this.mailingService.buscarCnpj(cpfCnpj, true);
                    if ((mailing == null || mailing.getCpfCnpj() == null || mailing.getNome() == null) && cpfCnpj.length() == 14) {
                        aba.createRow(ind).createCell(0).setCellValue(cpfCnpj);
                        aba.createRow(ind).createCell(1).setCellValue("CNPJ n\u00e3o encontrado na receita federal");
                        ++ind;
                        continue;
                    }
                    VivoProspectBiEstrutura vpb = null;
                    if (this.estruturaTipoService.isVivo(eu.getEstrutura())) {
                        vpb = this.prospectBiService.getByCpfCnpj(eu.getEstrutura(), cpfCnpj);
                    }
                    ind = this.createRow(cpfCnpj, eu, aba, Integer.valueOf(ind), styleCellDouble, mailing, vpb, consultaWhats);
                    if (mailing == null || mailing.getSituacao().toUpperCase().equals("ATIVA")) {
                        this.cobrar(enriquecimento, cpfCnpj, eu, compl.getValorEnriquecimento());
                    }
                    mailing = null;
                }
                catch (Exception e) {
                    ++ind;
                    if (enriquecimento != null) {
                        aba.createRow(ind).createCell(1).setCellValue("Erro, esta consulta n\u00e3o foi cobrada: " + (e.getMessage() == null ? "" : e.getMessage()));
                        continue;
                    }
                    aba.createRow(ind).createCell(1).setCellValue(e.getMessage() == null ? "" : e.getMessage());
                }
            }
            String hashFile = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String hash = StorageUtil.uploadObjectInputStream((String)hashFile, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            if (enriquecimento != null) {
                this.notificacoesService.notify(eu, "Enriquecimento", "Enriquecimento " + nomeArquivo + " finalizado com sucesso", Boolean.FALSE, Boolean.FALSE, "enriquecimento-de-base");
            } else {
                this.notificacoesService.notify(eu, "Oportunidade", "Oportunidade " + nomeArquivo + " finalizado com sucesso", Boolean.FALSE, Boolean.FALSE, "enriquecimento-de-base");
            }
            String string = hash;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                is.close();
                xls.close();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    private void cobrar(Enriquecimento enriquecimento, String cpfCnpj, EstruturaUsuario eu, BigDecimal valor) {
        if (enriquecimento == null) {
            return;
        }
        if (this.enriquecimentoItensService.cobrar(enriquecimento, cpfCnpj).booleanValue()) {
            if (enriquecimento.getConsultaSocios().booleanValue()) {
                valor = valor.add(BigDecimal.valueOf(0.02));
                this.creditosService.transacionar(eu, "Enriquecimento " + cpfCnpj, valor.negate());
            } else {
                this.creditosService.transacionar(eu, "Enriquecimento " + cpfCnpj, valor.negate());
            }
        }
    }

    private Integer createRow(String cpfCnpj, EstruturaUsuario eu, Sheet aba, Integer ind, CellStyle styleCellDouble, Mailing mailing, VivoProspectBiEstrutura vpb, Boolean consultaWhats) {
        DataStone ds = this.getByCpfCnpj(cpfCnpj);
        if (ds == null) {
            return ind;
        }
        try {
            Cliente cliente = this.getCliente(eu, ds);
            HashSet<ClienteContato> contatos = new HashSet<ClienteContato>();
            this.setPessoas(ds, cliente);
            List contatosDTO = this.getContatos(ds);
            for (DataStonecontatoDTO dsc : contatosDTO) {
                Row row = aba.createRow(ind.intValue());
                Integer n = ind;
                ind = ind + 1;
                int col = 0;
                row.createCell(col).setCellValue(ds.getCpfCnpj());
                row.createCell(++col).setCellValue(ds.getNome());
                if (mailing == null) {
                    row.createCell(++col).setCellValue(ds.getNomeMae() == null ? "" : ds.getNomeMae());
                    row.createCell(++col).setCellValue(ds.getDataNascimento() == null ? "" : ds.getDataNascimento().format(DateTimeFormatter.ISO_DATE));
                } else {
                    row.createCell(++col).setCellValue(mailing.getNomeFantasia());
                    row.createCell(++col).setCellValue(ds.getFuncionarios() != null ? ds.getFuncionarios() : "");
                    mailing.getSocios().forEach(pessoa -> cliente.getPessoas().add(new Pessoa(cliente, pessoa.getNome())));
                }
                contatos.add(this.getContato(cliente, dsc));
                row.createCell(++col).setCellValue(dsc.getNomeSocio() == null ? "" : dsc.getNomeSocio());
                row.createCell(++col).setCellValue(dsc.getCpfSocio() == null ? "" : StringUtil.normalizeCpf((String)dsc.getCpfSocio()));
                row.createCell(++col).setCellValue(dsc.getTipo().name());
                row.createCell(++col).setCellValue(dsc.getValor());
                if (!dsc.getTipo().equals((Object)DataStoneContatoTipoEnum.EMAIL)) {
                    if (consultaWhats.booleanValue()) {
                        WhatsAppHave have = this.whatsAppHaveService.getHave(dsc.getValor());
                        if (have == null || !have.getHave().booleanValue()) {
                            row.createCell(++col).setCellValue("N\u00c3O");
                        } else {
                            row.createCell(++col).setCellValue("SIM");
                        }
                        this.whatsAppService.cobrarConsultaWhats(cpfCnpj, eu, this.configurationsService.get(ConfigurationEnum.VALOR_TEM_WHATS).getBigDecimal());
                    } else {
                        ++col;
                    }
                } else {
                    ++col;
                }
                if (this.estruturaTipoService.isTelefonia(eu.getEstrutura()) && !dsc.getTipo().equals((Object)DataStoneContatoTipoEnum.EMAIL)) {
                    String operadora;
                    Portabilidade portabilidade;
                    LocalDate port = null;
                    Portabilidade portabilidade2 = portabilidade = dsc.getValor() != null ? this.portabilidadeConsultaService.getPortabilidade(Long.valueOf(dsc.getValor())) : null;
                    if (portabilidade != null) {
                        port = portabilidade.getDataHora() == null ? null : portabilidade.getDataHora().toLocalDate();
                        operadora = portabilidade.getOperadora() == null ? this.operadoraService.getOperadora(dsc.getValor()).getNome() : portabilidade.getOperadora().getNome();
                    } else {
                        operadora = this.operadoraService.getOperadora(dsc.getValor()).getNome();
                    }
                    row.createCell(++col).setCellValue(operadora == null ? "" : operadora);
                    row.createCell(++col).setCellValue(port == null ? "" : port.format(FormatDate.DATE_BR.toDTF()));
                } else if (this.estruturaTipoService.isTelefonia(eu.getEstrutura())) {
                    ++col;
                    ++col;
                }
                if (mailing != null) {
                    row.createCell(++col).setCellValue(mailing.getCep());
                    row.createCell(++col).setCellValue((String)(mailing.getLogradouro() == null ? "" : mailing.getLogradouro() + ", " + mailing.getNumero()));
                    row.createCell(++col).setCellValue(mailing.getBairro());
                    row.createCell(++col).setCellValue(mailing.getCidade());
                    row.createCell(++col).setCellValue(mailing.getEstado());
                    row.createCell(++col).setCellValue(mailing.getOpcaoMei() != null ? (mailing.getOpcaoMei().equals("S") ? "SIM" : "N\u00c3O") : "");
                    row.createCell(++col).setCellValue(mailing.getOpcaoSimples());
                    row.createCell(++col).setCellValue(mailing.getSituacao());
                    row.createCell(++col).setCellValue(mailing.getPorte());
                    row.createCell(++col).setCellValue(mailing.getCapitalSocial() == null ? Double.valueOf("0.00").doubleValue() : mailing.getCapitalSocial().doubleValue());
                    row.getCell(col).setCellStyle(styleCellDouble);
                    row.createCell(++col).setCellValue(mailing.getDataAbertura() == null ? "" : mailing.getDataAbertura().format(FormatDate.DATE_BR.toDTF()));
                    row.createCell(++col).setCellValue(this.getAtividades(mailing.getAtividades()));
                } else {
                    row.createCell(++col).setCellValue(ds.getCep());
                    row.createCell(++col).setCellValue((String)(ds.getLogradouro() == null ? "" : ds.getLogradouro() + ", " + ds.getNumero()));
                    row.createCell(++col).setCellValue(ds.getBairro());
                    row.createCell(++col).setCellValue(ds.getCidade());
                    row.createCell(++col).setCellValue(ds.getEstado());
                    col += 7;
                }
                if (!this.estruturaTipoService.isVivo(eu.getEstrutura()) || vpb == null) continue;
                row.createCell(++col).setCellValue((double)vpb.getFlagDisp().intValue());
                row.createCell(++col).setCellValue(vpb.getEnriquecimento());
            }
            this.clienteService.salvar(cliente, eu, contatos);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return ind;
    }

    private String getAtividades(Set<MailingAtividade> atividades) {
        for (MailingAtividade atividade : atividades) {
            if (!atividade.getPrincipal().booleanValue()) continue;
            return atividade.getCnae().getCodigo() + "-" + atividade.getCnae().getDescricao();
        }
        return "";
    }

    private Cliente getCliente(EstruturaUsuario eu, DataStone ds) {
        Cliente cliente = this.clienteService.getAndCreateCliente(eu, ds.getCpfCnpj(), new ClienteContato[0]);
        if (StringUtil.isEmpty((String)cliente.getBairro()).booleanValue()) {
            cliente.setBairro(ds.getBairro());
        }
        if (StringUtil.isEmpty((String)cliente.getCep()).booleanValue()) {
            cliente.setCep(ds.getCep());
        }
        if (StringUtil.isEmpty((String)cliente.getCidade()).booleanValue()) {
            cliente.setCidade(ds.getCidade());
        }
        if (StringUtil.isEmpty((String)cliente.getComplemento()).booleanValue()) {
            cliente.setComplemento(ds.getComplemento());
        }
        if (StringUtil.isEmpty((String)cliente.getEstado()).booleanValue()) {
            cliente.setEstado(ds.getEstado());
        }
        if (StringUtil.isEmpty((String)cliente.getNome()).booleanValue()) {
            cliente.setNome(ds.getNome());
        }
        if (StringUtil.isEmpty((String)cliente.getNumero()).booleanValue()) {
            cliente.setNumero(ds.getNumero());
        }
        return cliente;
    }

    private ClienteContato getContato(Cliente cliente, DataStonecontatoDTO dsc) {
        ClienteContato cc = new ClienteContato();
        cc.setCliente(cliente);
        cc.setTipo(dsc.getTipo().equals((Object)DataStoneContatoTipoEnum.EMAIL) ? TipoContatoEnum.EMAIL : TipoContatoEnum.TELEFONE);
        cc.setValor(dsc.getValor());
        cc.setVerificado(ClienteContatoVerficadoEnum.NAO_VERIFICADO);
        cc.setNivelRelevancia(Integer.valueOf(6));
        return cc;
    }

    void delete(DataStone dataStone) {
        this.dataStoneRepository.delete((Object)dataStone);
    }

    private void setPessoas(DataStone ds, Cliente cliente) {
        for (DataStoneSocios dss : ds.getSocios()) {
            if (dss.getNomeSocio() == null || dss.getCpf() == null) continue;
            cliente.getPessoas().forEach(e -> {
                if (dss.getNomeSocio().equals(e.getNome())) {
                    e.setCpf(dss.getCpf());
                    e.setCelular(dss.getTelefone1() != null ? dss.getTelefone1() : "");
                    e.setEmail(dss.getEmail1() != null ? dss.getEmail1() : "");
                }
            });
            cliente.getPessoas().add(new Pessoa(dss.getNomeSocio(), dss.getCpf(), "", dss.getEmail1() != null ? dss.getEmail1() : "", dss.getTelefone1() != null ? dss.getTelefone1() : "", null, null));
        }
    }

    private List<DataStonecontatoDTO> getContatos(DataStone ds) {
        DataStonecontatoDTO dto;
        ArrayList<DataStonecontatoDTO> retorno = new ArrayList<DataStonecontatoDTO>();
        for (DataStoneContato dsc : ds.getContatos()) {
            dto = new DataStonecontatoDTO();
            dto.setNomeSocio("");
            dto.setTipo(dsc.getTipo());
            dto.setValor(dsc.getValor());
            retorno.add(dto);
        }
        for (DataStoneSocios dss : ds.getSocios()) {
            if (dss.getNomeSocio() != null && dss.getTelefone1() != null && !dss.getTelefone1().isEmpty()) {
                dto = new DataStonecontatoDTO();
                dto.setNomeSocio(dss.getNomeSocio());
                dto.setCpfSocio(dss.getCpf());
                dto.setTipo(DataStoneContatoTipoEnum.CELULAR);
                dto.setValor(dss.getTelefone1());
                retorno.add(dto);
            }
            if (dss.getNomeSocio() != null && dss.getTelefone2() != null && !dss.getTelefone2().isEmpty()) {
                dto = new DataStonecontatoDTO();
                dto.setNomeSocio(dss.getNomeSocio());
                dto.setCpfSocio(dss.getCpf());
                dto.setTipo(DataStoneContatoTipoEnum.CELULAR);
                dto.setValor(dss.getTelefone2());
                retorno.add(dto);
            }
            if (dss.getNomeSocio() != null && dss.getEmail1() != null && !dss.getEmail1().isEmpty()) {
                dto = new DataStonecontatoDTO();
                dto.setNomeSocio(dss.getNomeSocio());
                dto.setCpfSocio(dss.getCpf());
                dto.setTipo(DataStoneContatoTipoEnum.EMAIL);
                dto.setValor(dss.getEmail1());
                retorno.add(dto);
            }
            if (dss.getNomeSocio() == null || dss.getEmail2() == null || dss.getEmail2().isEmpty()) continue;
            dto = new DataStonecontatoDTO();
            dto.setNomeSocio(dss.getNomeSocio());
            dto.setCpfSocio(dss.getCpf());
            dto.setTipo(DataStoneContatoTipoEnum.EMAIL);
            dto.setValor(dss.getEmail2());
            retorno.add(dto);
        }
        return retorno;
    }
}

