/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.datastone.service;

import br.com.system.app.features.datastone.model.DataStone;
import br.com.system.app.features.datastone.service.DataStoneService;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.Base64Util;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStoneSolicitaService {
    private Logger logger = LoggerFactory.getLogger(DataStoneSolicitaService.class);
    @Autowired
    private DataStoneService dataStoneService;
    @Autowired
    private MailingService mailingService;

    public Integer solicitarCpf(String nomeArquivo, Set<String> cpfs) {
        return this.solicitar(nomeArquivo, cpfs, false, false);
    }

    public Integer solicitarCnpj(String nomeArquivo, Set<String> cnpjs, boolean socios) {
        return this.solicitar(nomeArquivo, cnpjs, true, socios);
    }

    public Integer solicitar(String nomeArquivo, Set<String> cpfCnpj, boolean pj, boolean socios) {
        try {
            ArrayList itens = new ArrayList();
            JSONObject jSend = new JSONObject();
            jSend.put("name", (Object)nomeArquivo);
            if (pj) {
                jSend.put("layout_id", (Object)(socios ? "71" : "18"));
            } else {
                jSend.put("layout_id", (Object)"13");
            }
            jSend.put("parameters", itens);
            jSend.put("file", (Object)this.getBase64(cpfCnpj, pj, socios));
            String html = this.getConexao().setJsonParameters(jSend).executePost("https://api.datastone.com.br/v1/enrichment/").getReturnedHtml();
            JSONObject j = new JSONObject(html);
            if (!j.has("id")) {
                throw new Exception("Erro ao processar arquivo" + html);
            }
            return j.getInt("id");
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao processar arquivo" + e.getMessage());
        }
    }

    public JSONObject getLayouts() {
        try {
            String html = this.getConexao().executeGet("https://api.datastone.com.br/v1/enrichment/layouts/").getReturnedHtml();
            return new JSONObject(html);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getBase64(Set<String> lista, boolean pj, boolean socios) throws Exception {
        StringBuilder s = new StringBuilder();
        if (pj) {
            s.append("CNPJ;").append("Flag_socio").append("\n");
        } else {
            s.append("CPF").append("\n");
        }
        boolean passou = false;
        String primeiro = "";
        for (String cpfCnpj : lista) {
            try {
                DataStone dataStone;
                cpfCnpj = pj ? StringUtil.normalizeCnpj((String)cpfCnpj) : StringUtil.normalizeCpf((String)cpfCnpj);
                if (primeiro.isEmpty()) {
                    primeiro = cpfCnpj;
                }
                if (cpfCnpj.length() == 14 && !this.mailingService.isAtiva(cpfCnpj).booleanValue() || (dataStone = this.dataStoneService.getByCpfCnpj(cpfCnpj)) != null && !dataStone.getDataHoraConsulta().isBefore(LocalDateTime.now().minusMonths(2L))) continue;
                if (dataStone != null) {
                    this.dataStoneService.delete(dataStone);
                }
                if (pj && ValidationUtil.isValidCNPJ((String)cpfCnpj)) {
                    passou = true;
                    s.append(cpfCnpj).append(";");
                    if (socios) {
                        s.append("1\n");
                        continue;
                    }
                    s.append("0\n");
                    continue;
                }
                if (pj || !ValidationUtil.isValidCPF((String)cpfCnpj)) continue;
                s.append(cpfCnpj);
                s.append("\n");
                passou = true;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        if (!passou) {
            s.append(primeiro);
            if (socios) {
                s.append(";1\n");
            }
        }
        return Base64Util.ByteArrayToBase64((byte[])s.toString().getBytes());
    }

    public ExternalConnection getConexao() {
        ExternalConnection conexao = new ExternalConnection();
        conexao.addHeader("AUTHORIZATION", "Token 4c1c90d2-19c3-4a2a-aeed-b762b54e37df");
        return conexao;
    }
}

