/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.discadora.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteCopyMailing;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiscadoraIntegration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaComplementoService estruturaService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private MailingService mailingService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doIntegration(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        ServletInputStream is = null;
        try {
            is = request.getInputStream();
            String body = InputStreamUtil.toString((InputStream)is);
            if (body.isEmpty()) {
                response.setContentType("text/html; charset=UTF-8");
                out.print(this.example());
                return;
            }
            JSONObject jsonBody = new JSONObject(body);
            if (!this.getErros(jsonBody).isBlank()) {
                this.printErro(this.getErros(jsonBody), out);
                return;
            }
            EstruturaComplemento estruturaCompl = this.estruturaService.getByTokenIntegration(jsonBody.getString("token"));
            if (estruturaCompl == null) {
                this.printErro("Token Inv\u00e1lido", out);
                return;
            }
            Estrutura estrutura = estruturaCompl.getEstrutura();
            EstruturaUsuario eu = this.estruturaUsuarioService.getMasterEstrutura(estrutura);
            String cnpj = StringUtil.numbersOnly((String)jsonBody.getString("cpfCnpj"));
            String numero = StringUtil.numbersOnly((String)jsonBody.getString("telefone"));
            Cliente cliente = null;
            if (cnpj.isBlank() && !numero.isBlank() && (cliente = this.clienteService.getByTelefone(numero)) != null) {
                cnpj = cliente.getCpfCnpj();
            }
            if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj)) {
                cnpj = estrutura.getCpfCnpj();
            }
            if (cliente == null) {
                cliente = this.clienteService.buscarPeloCnpj(cnpj, estrutura);
            }
            if (cliente == null && cnpj.length() == 14) {
                cliente = new ClienteCopyMailing().convertMailingToCliente(this.mailingService.buscarCnpj(cnpj, true, false));
                try {
                    cliente = this.clienteService.salvar(cliente, eu);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cliente == null) {
                cliente = this.clienteService.getAndCreateCliente(eu, cnpj, new ClienteContato[0]);
            }
            this.printSucesso("Transferido com sucesso", out);
        }
        catch (Exception e) {
            this.printErro(e.getMessage(), out);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        out.close();
    }

    private String getErros(JSONObject json) {
        Object erros = "";
        try {
            String cpfCnpj;
            if (!json.has("atendente") || json.getString("atendente").isBlank()) {
                erros = (String)erros + "Atendente \u00e9 obrigatorio<BR>";
            }
            String telefone = json.has("telefone") ? json.getString("telefone") : "";
            String string = cpfCnpj = json.has("cpfCnpj") ? json.getString("cpfCnpj") : "";
            if (telefone.trim().isBlank() && !ValidationUtil.isValidCnpjAndCpf((String)cpfCnpj)) {
                erros = (String)erros + "CPF-CNPJ ou Telefone devem ser informados<BR>";
            }
        }
        catch (Exception e) {
            erros = (String)erros + e.getMessage();
        }
        return erros;
    }

    private void printSucesso(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", true);
        jsonRetorno.put("erro", (Object)"");
        out.print(jsonRetorno.toString());
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private String example() {
        return "<html><head><title>Integra\u00e7\u00e3o Central Telef\u00f4nica</title></head><body><div><p ><img src=\"images/logos/neo-200.png\"></p>\n<h4 ><strong><u>Integra\u00e7\u00e3o Central Telef\u00f4nica </u></strong></h4>\n<ul>\n <li>method - POST</li>\n <li>token - Obrigat\u00f3rio</li>\n <li>atendente - Obrigat\u00f3rio</li>\n <li>cpfCnpj*</li>\n <li>telefone*</li>\n <li>comentarios**</li>\n <li>* Informar cpfCnpj ou telefone</li>\n <li>**Pode ser um texto simples ou um html, com informa\u00e7\u00f5es do cliente(opcional)</li>\n</ul>\n<p>Json Body :</p>\n<pre>{\n       \"token\":\"SOLICITE_SEU_TOKEN_AO_SUPORTE\",\n       \"atendente\":\"2005\",\n       \"cpfCnpj\":\"17738735000110\",\n       \"telefone\":\"\",\n       \"comentarios\":\"\"\n}\n</pre>\n<p style=\"text-align: center\"><br></p></div></body></html>";
    }
}

