/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.email.service;

import br.com.system.app.features.email.model.EmailLog;
import br.com.system.app.features.email.repository.EmailLogRepository;
import br.com.system.app.features.email.service.MailerSender;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SendMailService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EmailLogRepository repository;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;

    @Async(value="asyncDefault")
    public void sendWithClientEmail(EstruturaUsuario eu, Set<String> listaEmail, String assunto, String mensagem) {
        String emailSendler = this.estruturaComplementoService.getComplementos(eu.getEstrutura()).getEmailSendler();
        if (emailSendler == null || emailSendler.isEmpty()) {
            emailSendler = "noreply@neosales-notify.com.br";
        }
        this.sendMailerSend(eu, emailSendler, listaEmail, assunto, mensagem);
    }

    @Async(value="asyncDefault")
    public void sendNoReply(EstruturaUsuario eu, String listaEmail, String assunto, String mensagem) {
        this.sendMailerSend(eu, "noreply@neosales-notify.com.br", this.getEmails(listaEmail), assunto, mensagem);
    }

    @Async(value="asyncDefault")
    public void sendNoReply(EstruturaUsuario eu, Set<String> listaEmail, String assunto, String mensagem) {
        this.sendMailerSend(eu, "noreply@neosales-notify.com.br", listaEmail, assunto, mensagem);
    }

    @Async(value="asyncDefault")
    private void sendMailerSend(EstruturaUsuario eu, String emailFrom, Set<String> listaEmail, String assunto, String mensagem) {
        for (String email : listaEmail) {
            try {
                EmailLog el = new EmailLog();
                el.setAssunto(assunto);
                el.setDestinatarios(email);
                el.setDataHoraEnvio(LocalDateTime.now());
                el.setEstruturaUsuario(eu);
                el.setMensagem(mensagem);
                try {
                    this.sendMailSendler(emailFrom, email, assunto, mensagem);
                    el.setSucesso(Boolean.TRUE);
                }
                catch (Exception ex) {
                    el.setSucesso(Boolean.FALSE);
                    el.setErro(ex.getMessage());
                }
                if (eu == null) continue;
                this.repository.save((Object)el);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(SendMailService.class).error("ERRO ENVIO E-MAIL: " + e.getMessage());
            }
        }
    }

    public void sendMailSendler(String emailFrom, String email, String assunto, String mensagem) throws Exception {
        new MailerSender().send(emailFrom, email, assunto, mensagem);
    }

    private Set<String> getEmails(String listaEmail) {
        String[] arr;
        HashSet<String> lista = new HashSet<String>();
        for (String email : arr = listaEmail.split(",")) {
            if (!ValidationUtil.isValidEmail((String)(email = email.trim()))) continue;
            lista.add(email);
        }
        return lista;
    }
}

