/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.equipe;

import br.com.system.app.MainLayout;
import br.com.system.app.components.Card;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.equipe.EquipeLogView;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.model.EquipeFilterEnum;
import br.com.system.app.features.equipe.service.EquipeLogService;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioEquipeDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.size.Right;
import br.com.system.app.features.layout.size.Size;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@Route(value="equipe", layout=MainLayout.class)
@PageTitle(value="Cadastro Equipes")
@RolesAllowed(value={"EQUIPE_VIEW"})
public class EquipeView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EstruturaUsuarioService euService;
    private final EquipeService equipeService;
    private final EquipeLogService equipeLogService;
    private final EquipeLogView equipeLogView;
    private Grid<EstruturaUsuarioEquipeDTO> gridEu;
    private RadioButtonGroup<EquipeFilterEnum> rb;
    private List<EstruturaUsuarioEquipeDTO> lista;
    private TextField filterName;
    private Equipe equipeSelected;

    public EquipeView(EstruturaUsuarioService euService, EquipeService equipeService, EquipeLogService equipeLogService, EquipeLogView equipeLogView) {
        this.euService = euService;
        this.equipeLogView = equipeLogView;
        this.equipeLogService = equipeLogService;
        this.equipeService = equipeService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.create());
        }
    }

    public FlexBoxLayout create() {
        FlexBoxLayout mainContainer = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingS();
        mainContainer.setAlignItems(FlexComponent.Alignment.START);
        mainContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.START);
        mainContainer.setWidthFull();
        this.gridEu = new Grid(EstruturaUsuarioEquipeDTO.class);
        ComboBox cbEquipe = new ComboBox("Equipe", (Collection)this.equipeService.getEquipes(this.getEstrutura()));
        cbEquipe.setWidth("400px");
        cbEquipe.setItemLabelGenerator(Equipe::getNome);
        cbEquipe.setPlaceholder("Selecione uma equipe");
        Button btnExcluir = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir equipe");
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.equipeSelected == null) {
                this.showNotification("Escolha uma equipe");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Excluir Equipe", "Confirma a exclus\u00e3o da Equipe?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.equipeService.deletarEquipe(this.equipeSelected, this.getEstrutura());
                cbEquipe.setItems((Collection)this.equipeService.getEquipes(this.getEstrutura()));
                cd.close();
            });
        });
        Button btnLog = UIUtils.createSmallButton((String)"Ver Logs");
        btnLog.setEnabled(this.hasPermission("VER_LOG_EQUIPE"));
        btnLog.addClickListener((ComponentEventListener & Serializable)e -> this.equipeLogView.create(this.getEstrutura()));
        FlexBoxLayout equipeContainer = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]).setSpacing(new Size[]{Right.S});
        equipeContainer.setAlignItems(FlexComponent.Alignment.BASELINE);
        equipeContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.START);
        equipeContainer.add(new Component[]{cbEquipe, btnExcluir, btnLog});
        TextField txtNome = new TextField("Nome da Equipe");
        txtNome.setWidth("400px");
        Button btnNova = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar equipe");
        Button btnUpdate = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.INBOX, (String)"Salvar equipe");
        HorizontalContainer novoContainer = new HorizontalContainer(new Component[0]);
        novoContainer.add(new Component[]{txtNome, btnNova, btnUpdate});
        Card card = new Card();
        card.setHeader("Equipe");
        card.setContent(new Component[]{equipeContainer, novoContainer});
        Button btnFilter = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SEARCH, (String)"Pesquisar");
        btnFilter.addClickListener((ComponentEventListener & Serializable)e -> this.povoaUsuarios());
        this.filterName = new TextField();
        this.filterName.setPlaceholder("Nome Usu\u00e1rio");
        this.filterName.setSuffixComponent((Component)btnFilter);
        this.filterName.setWidth("400px");
        this.filterName.setClearButtonVisible(true);
        btnNova.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Criar nova Equipe", "Confirma a cria\u00e7\u00e3o de nova equipe?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                if (txtNome.isEmpty()) {
                    this.showNotification("Informe um nome");
                    return;
                }
                Equipe newEquipe = new Equipe();
                newEquipe.setDataHoraCriacao(LocalDateTime.now());
                newEquipe.setEstrutura(this.getEstrutura());
                newEquipe.setNome(txtNome.getValue());
                this.equipeService.salvar(newEquipe, this.getEstrutura());
                txtNome.setValue("");
                cbEquipe.setItems((Collection)this.equipeService.getEquipes(this.getEstrutura()));
                cd.close();
            });
        });
        btnUpdate.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.equipeSelected == null) {
                this.showNotification("Selecione uma equipe para alterar o nome");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Alterar nome Equipe", "Confirma altera\u00e7\u00e3o do nome da equipe?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.equipeSelected.setNome(txtNome.getValue());
                this.equipeService.salvar(this.equipeSelected, this.getEstrutura());
                txtNome.setValue("");
                cbEquipe.setItems((Collection)this.equipeService.getEquipes(this.getEstrutura()));
                cd.close();
            });
        });
        this.rb = new RadioButtonGroup();
        this.rb.setItems((Object[])EquipeFilterEnum.values());
        this.rb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoaUsuarios());
        this.rb.setValue((Object)EquipeFilterEnum.TODOS);
        UIUtils.setFontSize((FontSize)FontSize.S, (Component[])new Component[]{this.rb});
        Button btnAtribuirTodos = UIUtils.createSmallButton((String)"Incluir Todos", (VaadinIcon)VaadinIcon.FILE_ADD);
        btnAtribuirTodos.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.lista.size() <= 0) {
                this.showNotification("Nao h\u00e1 nada selecionado");
                return;
            }
            String msg = "Confirma inclus\u00e3o de todos os usu\u00e1rios?";
            ConfirmationDialog confirm = new ConfirmationDialog("Altera\u00e7\u00e3o nas Permiss\u00e3o", msg);
            confirm.getCancel().addClickListener((ComponentEventListener & Serializable)bc -> confirm.close());
            confirm.getConfirm().addClickListener((ComponentEventListener & Serializable)c -> {
                confirm.close();
                this.all(Boolean.valueOf(true));
            });
        });
        Button btnRevogarTodos = UIUtils.createSmallButton((String)"Excluir Todos", (VaadinIcon)VaadinIcon.FILE_REMOVE);
        btnRevogarTodos.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.lista.size() <= 0) {
                this.showNotification("Nao h\u00e1 nada selecionado");
            }
            String msg = "Confirma exclus\u00e3o de todos os usu\u00e1rios?";
            ConfirmationDialog confirm = new ConfirmationDialog("Altera\u00e7\u00e3o nas Permiss\u00e3o", msg);
            confirm.getCancel().addClickListener((ComponentEventListener & Serializable)bc -> confirm.close());
            confirm.getConfirm().addClickListener((ComponentEventListener & Serializable)c -> {
                confirm.close();
                this.all(Boolean.valueOf(false));
            });
        });
        this.gridEu.setColumns(new String[0]);
        this.gridEu.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Checkbox cb = new Checkbox(this.checkPermission(eg));
            cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                EstruturaUsuarioEquipeDTO eu = eg;
                this.changePermission(eu.getEstruturaUsuarioId(), eu.getNomeUsuario(), ((Boolean)e.getValue()).booleanValue());
            });
            return cb;
        })).setWidth("80px").setFlexGrow(0);
        this.gridEu.addColumn("nomeUsuario");
        this.gridEu.addColumn("login");
        this.gridEu.addColumn("perfil");
        this.gridEu.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.isAtivo() ? "Ativo" : "Inativo")).setFlexGrow(0).setWidth("160px").setHeader("Status");
        this.gridEu.addColumn("nomeEquipe").setHeader("Equipe");
        cbEquipe.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.equipeSelected = (Equipe)e.getValue();
            txtNome.setValue(this.equipeSelected != null ? this.equipeSelected.getNome() : "");
            this.povoaUsuarios();
        });
        FlexBoxLayout footer = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]).setSpacingM();
        footer.add(new Component[]{btnAtribuirTodos, btnRevogarTodos});
        footer.setAlignItems(FlexComponent.Alignment.BASELINE);
        mainContainer.add(new Component[]{card, this.rb, this.filterName, this.gridEu, footer});
        return mainContainer;
    }

    private void all(Boolean incluir) {
        HashSet op = new HashSet();
        StringBuilder s = new StringBuilder();
        if (incluir.booleanValue()) {
            s.append("Usu\u00e1rio ").append(this.getUsuario().getNome()).append(" incluiu TODOS os usu\u00e1rios na equipe ").append(this.equipeSelected.getNome()).append("<br>");
        } else {
            s.append("Usu\u00e1rio ").append(this.getUsuario().getNome()).append(" excluiu TODOS os usu\u00e1rios ma equipe ").append(this.equipeSelected.getNome()).append("<br>");
        }
        this.lista.forEach(e -> op.add(e.getEstruturaUsuarioId()));
        this.euService.updateEquipe(op, this.equipeSelected, incluir);
        this.equipeLogService.save(this.getEu(), s.toString());
        this.povoaUsuarios();
    }

    private void changePermission(Long id, String nomeUsuario, boolean incluir) {
        HashSet<Long> op = new HashSet<Long>();
        op.add(id);
        if (incluir) {
            this.equipeLogService.save(this.getEu(), "Usu\u00e1rio " + this.getUsuario().getNome() + " inseriu usuario " + nomeUsuario + " na equipe " + this.equipeSelected.getNome());
        } else {
            this.equipeLogService.save(this.getEu(), "Usu\u00e1rio " + this.getUsuario().getNome() + " excluiu usuario " + nomeUsuario + " na equipe " + this.equipeSelected.getNome());
        }
        this.euService.updateEquipe(op, this.equipeSelected, Boolean.valueOf(incluir));
    }

    private boolean checkPermission(EstruturaUsuarioEquipeDTO eu) {
        return this.equipeSelected != null && eu.getEquipeId() != null && eu.getEquipeId().equals(this.equipeSelected.getId());
    }

    private void povoaUsuarios() {
        if (this.equipeSelected == null && !((EquipeFilterEnum)this.rb.getValue()).equals((Object)EquipeFilterEnum.SEM_EQUIPE)) {
            this.gridEu.setItems(new ArrayList());
            return;
        }
        this.lista = this.euService.getEstruturaUsuarioEquipe(this.getEstrutura(), this.equipeSelected, (EquipeFilterEnum)this.rb.getValue(), this.filterName.getValue(), Boolean.valueOf(((EquipeFilterEnum)this.rb.getValue()).equals((Object)EquipeFilterEnum.TODOS)));
        this.gridEu.setItems((Collection)this.lista);
    }
}

