/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.repository;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.repository.EstruturaRepositoryQuery;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface EstruturaRepository
extends JpaRepository<Estrutura, Long>,
EstruturaRepositoryQuery,
Serializable {
    public List<Estrutura> findByEstruturaTipoIdAndAtivo(Long var1, boolean var2);

    public List<Estrutura> findByEstruturaTipoIdAndAtivoOrderByNomeAsc(Long var1, boolean var2);

    public List<Estrutura> findByEstruturaTipoId(Long var1);

    public List<Estrutura> findByEstruturaTipoIdOrderByNomeAsc(Long var1);

    @Query(nativeQuery=true, value="select e.id from estrutura e\njoin estrutura_complemento ec on (ec.estrutura_id=e.id)\njoin cobranca_assinatura ca on (ec.cobranca_assinatura_id=ca.id)\nand e.ativo=1 and ca.ativo=1")
    public List<Long> findAtivas();

    @Query(value="select e FROM Estrutura e where e.estruturaTipo.id=:idEstruturaTipo AND e.ativo=:ativox ORDER BY RAND()")
    public List<Estrutura> findByTipoestruturaIdAtivoRand(@Param(value="idEstruturaTipo") Long var1, @Param(value="ativox") boolean var2);

    public List<Estrutura> findByCpfCnpj(String var1);

    public List<Estrutura> findByCpfCnpj(String var1, Pageable var2);

    public long countByCpfCnpj(String var1);

    public List<Estrutura> findByCpfCnpjAndAtivo(String var1, Boolean var2);

    public Estrutura findByNome(String var1);

    public List<Estrutura> findByNomeContains(String var1, Pageable var2);

    public long countByNomeContains(String var1);

    @Modifying
    @Query(nativeQuery=true, value="update estrutura set nome=:newDomain WHERE id=:id")
    public void changeDomain(@Param(value="id") Long var1, @Param(value="newDomain") String var2);

    public List<Estrutura> findByAtivo(Boolean var1);
}

