/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.repository.projection;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.io.Serializable;

@Entity
public class HierarquiaDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private Long estruturaUsuarioId;
    private Long usuarioId;
    private String usuarioNome;
    private String equipeNome;
    private String login;
    private String tags;
    private boolean ativo;
    private String perfil;
    private String email;
    private String celular;
    private String rules;
    private boolean master;

    public HierarquiaDTO() {
    }

    public HierarquiaDTO(Long estruturaUsuarioId, Long usuarioId, String usuarioNome, String equipeNome, String login, String tags, boolean ativo, String perfil, String email, String rules, boolean master) {
        this.estruturaUsuarioId = estruturaUsuarioId;
        this.usuarioId = usuarioId;
        this.usuarioNome = usuarioNome;
        this.equipeNome = equipeNome;
        this.login = login;
        this.tags = tags;
        this.ativo = ativo;
        this.perfil = perfil;
        this.email = email;
        this.rules = rules;
        this.master = master;
    }

    public HierarquiaDTO(EstruturaUsuario eu) {
        this.estruturaUsuarioId = eu.getId();
        this.usuarioId = eu.getUsuario().getId();
        this.usuarioNome = eu.getUsuario().getNome();
        this.equipeNome = eu.getEquipe() == null ? "" : eu.getEquipe().getNome();
        this.ativo = eu.isAtivo();
        this.login = eu.getUsuario().getLogin();
        this.tags = eu.getUsuario().getTags();
        this.perfil = eu.getUsuario().getPerfil().name();
        this.email = eu.getUsuario().getEmail();
        this.rules = eu.getRules();
        this.master = eu.getUsuario().isMaster();
    }

    public String getUsuarioAndEquipeName() {
        if (this.getEquipeNome() == null) {
            return this.getUsuarioNome();
        }
        return this.getUsuarioNome() + " (" + this.getEquipeNome() + ")";
    }

    public String getLoginAndPerfil() {
        return this.getLogin() + " (" + this.getPerfil() + ")";
    }

    public String getLoginAndEquipeName() {
        if (this.getEquipeNome() == null) {
            return this.getLogin();
        }
        return this.getLogin() + " (" + this.getEquipeNome() + ")";
    }

    public String getUsuarioELoginEEquipe() {
        return this.getUsuarioNome() + " " + this.getLogin() + " (" + this.getEquipeNome() + ")";
    }

    public String getUsuarioELogin() {
        return this.getUsuarioNome() + " (" + this.getLogin() + ")";
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Long getEstruturaUsuarioId() {
        return this.estruturaUsuarioId;
    }

    public void setEstruturaUsuarioId(Long estruturaUsuarioId) {
        this.estruturaUsuarioId = estruturaUsuarioId;
    }

    public Long getUsuarioId() {
        return this.usuarioId;
    }

    public void setUsuarioId(Long usuarioId) {
        this.usuarioId = usuarioId;
    }

    public String getUsuarioNome() {
        return this.usuarioNome;
    }

    public void setUsuarioNome(String usuarioNome) {
        this.usuarioNome = usuarioNome;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public String getEquipeNome() {
        return this.equipeNome;
    }

    public void setEquipeNome(String equipeNome) {
        this.equipeNome = equipeNome;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getPerfil() {
        return this.perfil;
    }

    public void setPerfil(String perfil) {
        this.perfil = perfil;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getRules() {
        return this.rules;
    }

    public void setRules(String rules) {
        this.rules = rules;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }
}

