/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.service;

import br.com.system.app.features.analisefatura.model.AnaliseFatura;
import br.com.system.app.features.analisefatura.service.AnaliseFaturaService;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteTrigger;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.cliente.service.ClienteTriggerService;
import br.com.system.app.features.enriquecimento.model.Enriquecimento;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.equipe.service.EquipeLogService;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.kanbanpedidos.service.KanbanPedidosService;
import br.com.system.app.features.marketing.service.MarketingService;
import br.com.system.app.features.materialapoio.service.MaterialApoioService;
import br.com.system.app.features.modeloproposta.repository.ModeloPropostaRepository;
import br.com.system.app.features.notificacoes.service.NotificacoesDiariasScreenService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.oportunidade.service.OportunidadeService;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.PedidoDeleteService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.features.serasa.service.SerasaService;
import br.com.system.app.features.sessions.service.SessionsService;
import br.com.system.app.features.sms.service.SmsService;
import br.com.system.app.features.task.service.TaskService;
import br.com.system.app.features.trescx.service.TrescxChamadaService;
import br.com.system.app.features.trescx.service.TrescxLogService;
import br.com.system.app.features.usuario.service.HierarquiaLogService;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.service.WhatsAppContaDeleteService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EstruturaDeleteService {
    @Autowired
    private EstruturaService estruturaService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PedidoDeleteService PedidoDeleteService;
    @Autowired
    private OportunidadeService oportunidadeService;
    @Autowired
    private EnriquecimentoService enriquecimentoService;
    @Autowired
    private AnaliseFaturaService analiseFaturaService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private ClienteTagService clienteTagService;
    @Autowired
    private ClienteTriggerService clienteTriggerService;
    @Autowired
    private EquipeLogService equipeLogService;
    @Autowired
    private EquipeService equipeService;
    @Autowired
    private EstruturaSenhasService estruturaSenhasService;
    @Autowired
    private MarketingService marketingService;
    @Autowired
    private MaterialApoioService materialApoioService;
    @Autowired
    private ModeloPropostaRepository modeloPropostaRepository;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private NotificacoesDiariasScreenService notificacoesDiariasScreenService;
    @Autowired
    private ProducaoPainelService producaoPainelService;
    @Autowired
    private SerasaService serasaService;
    @Autowired
    private SessionsService sessionsService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TrescxLogService trescxLogService;
    @Autowired
    private TrescxChamadaService trescxChamadaService;
    @Autowired
    private KanbanPedidosService kanbanPedidosService;
    @Autowired
    private HierarquiaLogService hierarquiaLogService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private WhatsAppContaDeleteService whatsappContaDeleteService;

    @Transactional
    public void deleteEstrutura(Long estruturaId) {
        try {
            Estrutura estrutura = this.estruturaService.getById(estruturaId);
            Set pedidos = this.pedidoService.getByEstrutura(estruturaId);
            for (Object p : pedidos) {
                this.PedidoDeleteService.delete((Pedido)p, Boolean.valueOf(false));
            }
            Set ofs = this.oportunidadeService.getByEstrutura(estrutura);
            for (Object of : ofs) {
                this.oportunidadeService.deletarOportunidadeFile(of.getId(), of.getEstruturaUsuario().getEstrutura());
            }
            Set enriquecimentos = this.enriquecimentoService.getByEstrutura(estrutura);
            for (Object enriquecimento : enriquecimentos) {
                this.enriquecimentoService.delete((Enriquecimento)enriquecimento);
            }
            List analises = this.analiseFaturaService.getByEstrutura(estrutura);
            for (Object analise : analises) {
                this.analiseFaturaService.delete((AnaliseFatura)analise, Boolean.valueOf(false));
            }
            List clientes = this.clienteService.getByEstrutura(estrutura);
            for (Object cliente : clientes) {
                this.clienteService.delete((Cliente)cliente, Boolean.valueOf(false));
            }
            this.clienteTagService.deleteTagByEstrutura(estrutura);
            List triggers = this.clienteTriggerService.getByEstrutura(estrutura);
            for (Object trigger : triggers) {
                this.clienteTriggerService.delete((ClienteTrigger)trigger);
            }
            this.equipeLogService.delete(estrutura);
            this.equipeService.deleteByEsturura(estrutura);
            this.estruturaSenhasService.deleteByEstrutura(estrutura);
            this.marketingService.deleteByEstrutura(estrutura);
            this.materialApoioService.deleteByEstrutura(estrutura);
            this.modeloPropostaRepository.deleteByEstrutura(estrutura);
            this.notificacoesService.deleteByEstrutura(estrutura);
            this.notificacoesDiariasScreenService.deleteByEstrutura(estrutura);
            List paineis = this.producaoPainelService.getByEstrutura(estrutura);
            for (ProducaoPainel painel : paineis) {
                this.producaoPainelService.delete(painel);
            }
            this.serasaService.deleteSerasaByEstrutura(estrutura);
            this.sessionsService.deleteByEstrutura(estrutura);
            this.smsService.deleteByEstrutura(estrutura);
            this.taskService.deleteByEstrutura(estrutura);
            this.trescxLogService.deleteByEstrutura(estrutura);
            this.trescxChamadaService.deleteByEstrutura(estrutura);
            this.kanbanPedidosService.zerar(estrutura);
            List contas = this.whatsappContaService.getByEstrutura(estrutura);
            for (WhatsAppConta conta : contas) {
                this.whatsappContaDeleteService.delete(conta);
            }
            this.hierarquiaLogService.deleteByEstrutura(estrutura);
            this.estruturaUsuarioService.deleteHierarquiaByEstrutura(estrutura);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

