/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.googlecron;

import br.com.system.app.features.analisefatura.model.BotTypeEnum;
import br.com.system.app.features.bots.service.BotService;
import br.com.system.app.features.bots.service.BotStartThreads;
import br.com.system.app.features.cliente.service.ClienteTriggerService;
import br.com.system.app.features.cobranca.service.CobrancaService;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.email.service.EmailAtividadeService;
import br.com.system.app.features.googlecron.CronJobEnum;
import br.com.system.app.features.googlecron.CronResource;
import br.com.system.app.features.notificacoes.service.NotificacaoDiariaService;
import br.com.system.app.features.pedido.service.PedidoNotificacaoService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.portabilidade.service.PortabilidadeService;
import br.com.system.app.features.producaopainel.service.ProducaoPainelResumoService;
import br.com.system.app.features.usuario.service.UsuarioInatividadeService;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CronResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private CobrancaService cobrancaService;
    @Autowired
    private PortabilidadeService portabilidadeService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private ClienteTriggerService clienteTriggerService;
    @Autowired
    private NotificacaoDiariaService notificacaoDiariaService;
    @Autowired
    private EmailAtividadeService emailAtividadeService;
    @Autowired
    private BotService botService;
    @Autowired
    private BotStartThreads botStartThreads;
    @Autowired
    private PedidoNotificacaoService pedidoNotificacaoService;
    @Autowired
    private ProducaoPainelResumoService producaoPainelResumoService;
    @Autowired
    private CreditosService creditosService;
    @Autowired
    private UsuarioInatividadeService usuarioInatividadeService;

    public void execute(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        if (request.getParameter("cron-job") == null) {
            this.printErro("Cron-jobs is missing", out);
            return;
        }
        CronJobEnum cronJob = CronJobEnum.valueOf((String)request.getParameter("cron-job"));
        if (request.getHeader("X-Appengine-Cron") != null && request.getHeader("X-Appengine-Cron").equals("true")) {
            this.autorizado(cronJob, (ServletRequest)request, out);
            return;
        }
        if (request.getParameter("cron-token") != null && request.getParameter("cron-token").equals("5dcafe13-91ac-1333-9e16-131f9fcd38dc")) {
            this.autorizado(cronJob, (ServletRequest)request, out);
            return;
        }
        this.printErro("Nao autorizado", out);
    }

    private void printSucesso(PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", true);
        jsonRetorno.put("erro", (Object)"");
        out.print(jsonRetorno.toString());
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private void autorizado(CronJobEnum cronJob, ServletRequest request, PrintWriter out) {
        switch (1.$SwitchMap$br$com$system$app$features$googlecron$CronJobEnum[cronJob.ordinal()]) {
            case 1: {
                this.updatePortabilidade(request);
                break;
            }
            case 2: {
                this.pedidoService.verificarRetornoFuturo();
                break;
            }
            case 3: {
                this.clienteTriggerService.triggerProcess();
                break;
            }
            case 4: {
                this.notificacaoDiariaService.send();
                break;
            }
            case 5: {
                this.emailAtividadeService.envioDiario();
                break;
            }
            case 6: {
                this.usuarioInatividadeService.bloquearPorInatividade();
                break;
            }
            case 7: {
                this.botStart();
                break;
            }
            case 8: {
                this.producaoPainelResumoService.atualizar(null, null, null, null);
                break;
            }
            case 9: {
                this.pedidoNotificacaoService.notificacaoAtividade();
                break;
            }
            case 10: {
                this.cobrancaService.gerarFaturas();
                this.cobrancaService.checarPagamentos();
                this.cobrancaService.checarInadimplencia("");
                this.cobrancaService.checarDivergencia("");
                this.cobrancaService.notificarInadimplencia();
                break;
            }
            case 11: {
                this.cobrancaService.transferirInter();
                break;
            }
            case 12: {
                this.cobrancaService.checarNota();
                this.creditosService.checarNota();
                break;
            }
            default: {
                this.printErro("cron-jobs not found", out);
            }
        }
        this.printSucesso(out);
    }

    private void botStart() {
        if (!this.botService.haveProcess(BotTypeEnum.BOTFAT)) {
            this.botStartThreads.start(BotTypeEnum.BOTFAT, 1, null);
        }
        if (!this.botService.haveProcess(BotTypeEnum.BOTMARKETING)) {
            this.botStartThreads.start(BotTypeEnum.BOTMARKETING, 1, null);
        }
    }

    private void updatePortabilidade(ServletRequest request) {
        String filename = request.getParameter("file");
        this.portabilidadeService.updatePort(filename);
    }
}

