/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.layout;

import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.TextColor;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.size.FontWeight;
import br.com.system.app.features.layout.size.IconSize;
import br.com.system.app.features.layout.size.LineHeight;
import br.com.system.app.features.layout.util.AlignSelf;
import br.com.system.app.features.layout.util.BorderRadius;
import br.com.system.app.features.layout.util.BorderStyle;
import br.com.system.app.features.layout.util.BoxSizing;
import br.com.system.app.features.layout.util.Overflow;
import br.com.system.app.features.layout.util.PointerEvents;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.layout.util.TextAlign;
import br.com.system.app.features.layout.util.TextOverflow;
import br.com.system.app.features.layout.util.WhiteSpace;
import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.Autocomplete;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.router.QueryParameters;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.vaadin.lineawesome.LineAwesomeIcon;

/*
 * Exception performing whole class analysis ignored.
 */
public class UIUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String IMG_PATH = "images/";

    public static Locale getLocale() {
        return new Locale("pt", "BR");
    }

    public static ProgressBar createProgressBar() {
        ProgressBar progressBar = new ProgressBar();
        progressBar.setWidth("100%");
        progressBar.setIndeterminate(true);
        progressBar.setVisible(true);
        return progressBar;
    }

    public static Div createHr() {
        Div div = new Div();
        div.getElement().setProperty("innerHTML", "<span><hr/></span>");
        return div;
    }

    public static Scroller createScroller(Component comp) {
        return UIUtils.createScroller((Component)comp, (Scroller.ScrollDirection)Scroller.ScrollDirection.VERTICAL);
    }

    public static Scroller createScroller(Component comp, Scroller.ScrollDirection direcao) {
        Scroller scroller = new Scroller(comp);
        scroller.setScrollDirection(direcao);
        return scroller;
    }

    public static Span createSpan(FontSize size, TextColor color, String text) {
        Span Span2 = new Span(text);
        UIUtils.setFontSize((FontSize)size, (Component[])new Component[]{Span2});
        UIUtils.setTextColor((TextColor)color, (Component[])new Component[]{Span2});
        return Span2;
    }

    public static Span createSmallSpan(String text) {
        return UIUtils.createSmallSpan((String)text, (boolean)false);
    }

    public static Span createSmallSpan(String text, boolean bold) {
        Span Span2 = UIUtils.createSpan((FontSize)FontSize.S, (TextColor)TextColor.SECONDARY, (String)text);
        Span2.addClassName("h6");
        return Span2;
    }

    public static Span createSpan(FontSize size, String text) {
        return UIUtils.createSpan((FontSize)size, (TextColor)TextColor.BODY, (String)text);
    }

    public static Span createSpan(TextColor color, String text) {
        return UIUtils.createSpan((FontSize)FontSize.M, (TextColor)color, (String)text);
    }

    public static Span createBreakWrapSpan(String text) {
        Span Span2 = new Span(text == null ? "" : text);
        UIUtils.setFontSize((FontSize)FontSize.S, (Component[])new Component[]{Span2});
        UIUtils.setWhiteSpace((WhiteSpace)WhiteSpace.PRE_WRAP, (Component[])new Component[]{Span2});
        Span2.getStyle().set("word-wrap", "break-word");
        return Span2;
    }

    public static TextField createBreakWrapText(String Span2) {
        TextField tf = new TextField(Span2);
        UIUtils.setFontSize((FontSize)FontSize.S, (Component[])new Component[]{tf});
        UIUtils.setWhiteSpace((WhiteSpace)WhiteSpace.PRE_WRAP, (Component[])new Component[]{tf});
        tf.getStyle().set("word-wrap", "break-word");
        return tf;
    }

    public static H5 createHeader(String text) {
        return UIUtils.createHeader((String)text, null);
    }

    public static H5 createHeader(String text, Color backGroundColor) {
        H5 h5 = new H5(text);
        if (backGroundColor != null) {
            h5.getStyle().set("background-color", backGroundColor.getValue());
            h5.setHeight("30px");
        }
        h5.setWidthFull();
        h5.setClassName("text-center");
        return h5;
    }

    public static String formatDecimal(Double amount, int precision) {
        return String.format("%." + precision + "f", amount);
    }

    public static String formatCurrency(Double amount) {
        return UIUtils.formatCurrency((BigDecimal)BigDecimal.valueOf(amount));
    }

    public static String formatCurrency(BigDecimal amount) {
        if (amount == null) {
            return CurrencyUtil.toCurrencyWithR$((BigDecimal)BigDecimal.ZERO);
        }
        return CurrencyUtil.toCurrencyWithR$((BigDecimal)amount);
    }

    public static String formatThousand(int value) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        DecimalFormat dfDecimal = new DecimalFormat("###########0");
        dfDecimal.setDecimalFormatSymbols(symbols);
        dfDecimal.setGroupingSize(3);
        dfDecimal.setGroupingUsed(true);
        return dfDecimal.format(value);
    }

    public static Icon createPrimaryIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor((TextColor)TextColor.PRIMARY, (Component[])new Component[]{i});
        i.addClassName(IconSize.S.getClassName());
        return i;
    }

    public static Icon createSecondaryIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor((TextColor)TextColor.SECONDARY, (Component[])new Component[]{i});
        i.addClassName(IconSize.S.getClassName());
        return i;
    }

    public static Icon createTertiaryIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor((TextColor)TextColor.TERTIARY, (Component[])new Component[]{i});
        i.addClassName(IconSize.S.getClassName());
        return i;
    }

    public static Icon createDisabledIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor((TextColor)TextColor.DISABLED, (Component[])new Component[]{i});
        i.addClassName(IconSize.S.getClassName());
        return i;
    }

    public static Icon createSuccessIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor((TextColor)TextColor.SUCCESS, (Component[])new Component[]{i});
        i.addClassName(IconSize.S.getClassName());
        return i;
    }

    public static Icon createErrorIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor((TextColor)TextColor.ERROR, (Component[])new Component[]{i});
        i.addClassName(IconSize.S.getClassName());
        return i;
    }

    public static String formatDate(LocalDate date) {
        return date.format(FormatDate.DATE_BR.toDTF());
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return dateTime.format(FormatDate.DATETIME_BR.toDTF());
    }

    public static void showProcessNotification() {
        UIUtils.showProcessNotification(null);
    }

    public static void showProcessNotification(String text) {
        if (text == null || text.isEmpty()) {
            text = "Processo Iniciado com sucesso, ao final voc\u00ea ser\u00e1 notificado.";
        }
        UIUtils.showNotification((String)text);
    }

    public static void showWarning(String texto) {
        UIUtils.notificar((String)texto, (NotificationVariant)NotificationVariant.LUMO_WARNING);
    }

    public static void showError(String texto) {
        UIUtils.notificar((String)texto, (NotificationVariant)NotificationVariant.LUMO_ERROR);
    }

    public static void showSucess(String texto) {
        UIUtils.notificar((String)texto, (NotificationVariant)NotificationVariant.LUMO_SUCCESS);
    }

    public static void showNotification(String text) {
        UIUtils.notificar((String)text, (NotificationVariant)NotificationVariant.LUMO_SUCCESS);
    }

    public static void showNotification(String texto, NotificationVariant variant, Integer duracao, Notification.Position posicao) {
        UIUtils.notificar((String)texto, (NotificationVariant)variant, (Integer)duracao, (Notification.Position)posicao);
    }

    private static void notificar(String texto, NotificationVariant variant) {
        UIUtils.notificar((String)texto, (NotificationVariant)variant, (Integer)6000, (Notification.Position)Notification.Position.TOP_CENTER);
    }

    private static void notificar(String texto, NotificationVariant variant, Integer duracao, Notification.Position posicao) {
        Div div = new Div();
        div.getStyle().set("text-align", "center");
        div.getStyle().set("font-weight", "bolder");
        div.getStyle().set("color", Color.WHITE.getValue());
        div.setWidthFull();
        div.setHeightFull();
        texto = texto.replace("\n", "<BR>");
        div.getElement().setProperty("innerHTML", "<span align=\"center\">" + texto + "</span>");
        Notification n = new Notification(new Component[]{div});
        n.addThemeVariants((ThemeVariant[])new NotificationVariant[]{variant});
        n.setOpened(true);
        n.setDuration(duracao.intValue());
        n.setPosition(posicao);
    }

    public static void setAlignSelf(AlignSelf alignSelf, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("align-self", alignSelf.getValue());
        }
    }

    public static void setBackgroundColor(Color color, Component ... components) {
        UIUtils.setBackgroundColor((String)color.getValue(), (Component[])components);
    }

    public static void setBackgroundColor(String backgroundColor, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("background-color", backgroundColor);
        }
    }

    public static void setBorder(BorderStyle style, Component ... components) {
        UIUtils.setBorder((BorderStyle)style, null, (Component[])components);
    }

    public static void setBorder(BorderStyle style, String sizePx, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("border-style", style.name().toLowerCase());
            if (sizePx == null) continue;
            component.getElement().getStyle().set("border", sizePx);
        }
    }

    public static void setBorderRadius(BorderRadius borderRadius, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("border-radius", borderRadius.getValue());
        }
    }

    public static void setSeparator(BorderStyle style, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("border-bottom", style.name().toLowerCase());
        }
    }

    public static void setBoxSizing(BoxSizing boxSizing, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("box-sizing", boxSizing.getValue());
        }
    }

    public static void setColSpan(int span, Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("colspan", Integer.toString(span));
        }
    }

    public static void setFontSize(FontSize fontSize, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("font-size", fontSize.getValue());
        }
    }

    public static void setFontWeight(FontWeight fontWeight, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("font-weight", fontWeight.getValue());
        }
    }

    public static void setLineHeight(LineHeight lineHeight, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("line-height", lineHeight.getValue());
        }
    }

    public static void setLineHeight(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("line-height", value);
        }
    }

    public static void setMaxWidth(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("max-width", value);
        }
    }

    public static void setOverflow(Overflow overflow, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("overflow", overflow.getValue());
        }
    }

    public static void setPointerEvents(PointerEvents pointerEvents, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("pointer-events", pointerEvents.getValue());
        }
    }

    public static void setShadow(Shadow shadow, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("box-shadow", shadow.getValue());
        }
    }

    public static void removeShadow(Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().remove("box-shadow");
        }
    }

    public static void removeBackgroundColor(Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().remove("background-color");
        }
    }

    public static void setTextAlign(TextAlign textAlign, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("text-align", textAlign.getValue());
        }
    }

    public static void setTextColor(String textColor, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("color", textColor);
        }
    }

    public static void setTextColor(TextColor textColor, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("color", textColor.getValue());
        }
    }

    public static void setTextOverflow(TextOverflow textOverflow, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("text-overflow", textOverflow.getValue());
        }
    }

    public static void setTextWrap(Component ... components) {
        for (Component component : components) {
            UIUtils.setTextOverflow((TextOverflow)TextOverflow.CLIP, (Component[])new Component[]{component});
            UIUtils.setOverflow((Overflow)Overflow.HIDDEN, (Component[])new Component[]{component});
            UIUtils.setWhiteSpace((WhiteSpace)WhiteSpace.NOWRAP, (Component[])new Component[]{component});
        }
    }

    public static void setTheme(String theme, Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("theme", theme);
        }
    }

    public static void setTooltip(String tooltip, Component ... components) {
        for (Component component : components) {
            component.getElement().setProperty("title", tooltip);
        }
    }

    public static void setWhiteSpace(WhiteSpace whiteSpace, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("white-space", whiteSpace.getValue());
        }
    }

    public static void setWidth(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("width", value);
        }
    }

    public static void setAriaSpan(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("aria-Span", value);
        }
    }

    public static String getUrlParameter(QueryParameters qp, String parameterName) {
        HashMap parametros = UIUtils.getUrlParameters((QueryParameters)qp);
        if (parametros.containsKey(parameterName)) {
            return (String)parametros.get(parameterName);
        }
        return "";
    }

    public static HashMap<String, String> getUrlParameters(QueryParameters qp) {
        HashMap<String, String> parametros = new HashMap<String, String>();
        Map parameters = qp.getParameters();
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            if (key.isBlank()) continue;
            parametros.put(key, (String)((List)entry.getValue()).get(0));
        }
        return parametros;
    }

    public static void removePadding(Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("padding", "unset");
        }
    }

    public static Button createConfirmButton() {
        return UIUtils.createSaveButton((String)"Confirmar");
    }

    public static Button createConfirmButton(String label) {
        return UIUtils.createButton((String)label, (VaadinIcon)VaadinIcon.CHECK_CIRCLE, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY, ButtonVariant.LUMO_SMALL});
    }

    public static Button createSaveButton() {
        return UIUtils.createSaveButton((String)"Salvar");
    }

    public static Button createSaveButton(String label) {
        return UIUtils.createButton((String)label, (VaadinIcon)VaadinIcon.INBOX, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SUCCESS, ButtonVariant.LUMO_SMALL});
    }

    public static Button createCloseButton() {
        return UIUtils.createCloseButton((String)"Fechar");
    }

    public static Button createCloseButton(String label) {
        return UIUtils.createButton((String)label, (VaadinIcon)VaadinIcon.CLOSE, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR, ButtonVariant.LUMO_SMALL});
    }

    public static Button createSearchButton() {
        return UIUtils.createSearchButton((String)"Pesquisar");
    }

    public static Button createSearchButton(String label) {
        return UIUtils.createSmallButton((String)label, (VaadinIcon)VaadinIcon.SEARCH);
    }

    public static Button createInsertButton() {
        return UIUtils.createInsertButton((String)"Inserir");
    }

    public static Button createInsertButton(String label) {
        return UIUtils.createSmallButton((String)label, (VaadinIcon)VaadinIcon.PLUS_CIRCLE);
    }

    public static Button createEditButton() {
        return UIUtils.createEditButton((String)"Editar");
    }

    public static Button createEditButton(String label) {
        return UIUtils.createButton((String)label, (VaadinIcon)VaadinIcon.PENCIL);
    }

    public static Button createExportButton() {
        return UIUtils.createExportButton((String)"Exportar");
    }

    public static Button createExportButton(String label) {
        return UIUtils.createButton((String)label, (VaadinIcon)VaadinIcon.DOWNLOAD);
    }

    public static Button createDeleteButton() {
        return UIUtils.createDeleteButton((String)"Excluir");
    }

    public static Button createDeleteButton(String label) {
        return UIUtils.createButton((String)label, (VaadinIcon)VaadinIcon.TRASH);
    }

    public static Button createSuccessButton(String texto, VaadinIcon icon, String tooltip) {
        return UIUtils.createButton((String)texto, (VaadinIcon)icon, (String)tooltip, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_SUCCESS});
    }

    public static Button createErrorButton(String texto, VaadinIcon icon, String tooltip) {
        return UIUtils.createButton((String)texto, (VaadinIcon)icon, (String)tooltip, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_ERROR});
    }

    public static Button createIconButton(LineAwesomeIcon icon, String tooltip) {
        Button b = UIUtils.createButtonByComponent((Component)icon.create(), (String)tooltip, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON});
        b.setTooltipText(tooltip);
        b.setWidth("20px");
        b.setHeight("20px");
        return b;
    }

    public static Button createIconButton(Icon icon, String tooltip) {
        Button b = new Button((Component)icon);
        b.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON, ButtonVariant.LUMO_SMALL});
        b.setWidth("20px");
        b.setHeight("20px");
        b.setTooltipText(tooltip);
        return b;
    }

    public static Button createSmallButton(String text) {
        return UIUtils.createButton((String)text, (String)"", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
    }

    public static Button createSmallButton(String text, String tooltip) {
        return UIUtils.createButton((String)text, (String)tooltip, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
    }

    public static Button createSmallButton(String text, VaadinIcon icon) {
        return UIUtils.createButton((String)text, (VaadinIcon)icon, (String)"", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
    }

    public static Button createSmallButton(String text, LineAwesomeIcon icon) {
        return UIUtils.createButtonByComponent((String)text, (Component)icon.create(), (String)"", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
    }

    public static Button createSmallButton(String text, VaadinIcon icon, String tooltip) {
        return UIUtils.createButton((String)text, (VaadinIcon)icon, (String)tooltip, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
    }

    public static Button createSmallButton(VaadinIcon icon, String tooltip) {
        return UIUtils.createSmallButton((VaadinIcon)icon, (String)tooltip, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
    }

    public static Button createSmallButton(VaadinIcon icon, String tooltip, ButtonVariant ... variants) {
        return UIUtils.createButton((Icon)new Icon(icon), (String)tooltip, (ButtonVariant[])variants);
    }

    public static Button createSmallButton(LineAwesomeIcon icon, String tooltip) {
        return UIUtils.createButtonByComponent((Component)icon.create(), (String)tooltip, (ButtonVariant[])new ButtonVariant[0]);
    }

    public static Button createSmallButton(Icon icon, String tooltip) {
        return UIUtils.createButton((Icon)icon, (String)tooltip, (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
    }

    public static Button createTopButton(Component component) {
        Button btn = UIUtils.createSmallButton((Icon)VaadinIcon.ARROW_CIRCLE_DOWN.create(), (String)"Ir ao final");
        String componentId = component.getId() == null ? HashUtil.getUUI() : (String)component.getId().get();
        String js = "document.getElementById('" + componentId + "').scrollTop = document.getElementById('" + componentId + "').scrollHeight;";
        btn.addClickListener((ComponentEventListener & Serializable)e -> UI.getCurrent().getPage().executeJs(js, new Serializable[0]));
        return btn;
    }

    public static Button createBottomButton(Component component) {
        Button btn = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_CIRCLE_UP, (String)"Ir para o TOPO");
        String componentId = component.getId() == null ? HashUtil.getUUI() : (String)component.getId().get();
        String js = "document.getElementById('" + componentId + "').scrollTop = -100;";
        btn.addClickListener((ComponentEventListener & Serializable)e -> UI.getCurrent().getPage().executeJs(js, new Serializable[0]));
        return btn;
    }

    public static Button createButton(String text, String tooltip, ButtonVariant ... variants) {
        Button button = new Button(text);
        button.addThemeVariants((ThemeVariant[])variants);
        button.getElement().setAttribute("aria-Span", text);
        if (!tooltip.isBlank()) {
            button.getElement().setProperty("title", tooltip);
        }
        return button;
    }

    public static Button createButton(Icon icon, String tooltip, ButtonVariant ... variants) {
        return UIUtils.createButtonByComponent((Component)icon, (String)tooltip, (ButtonVariant[])variants);
    }

    public static Button createButtonByComponent(Component icon, String tooltip, ButtonVariant ... variants) {
        return UIUtils.createButtonByComponent((String)"", (Component)icon, (String)tooltip, (ButtonVariant[])variants);
    }

    public static Button createButtonByComponent(String text, Component icon, String tooltip, ButtonVariant ... variants) {
        Button button = text != null && !text.isEmpty() ? new Button(text, icon) : new Button(icon);
        button.addThemeVariants((ThemeVariant[])variants);
        if (!tooltip.isBlank()) {
            button.getElement().setProperty("title", tooltip);
        }
        return button;
    }

    public static Button createButton(String text, LineAwesomeIcon icon) {
        return UIUtils.createButton((String)text, (LineAwesomeIcon)icon, (String)"", (ButtonVariant[])new ButtonVariant[0]);
    }

    public static Button createButton(String text, VaadinIcon icon) {
        return UIUtils.createButton((String)text, (VaadinIcon)icon, (String)"", (ButtonVariant[])new ButtonVariant[0]);
    }

    public static Button createButton(String text, VaadinIcon icon, ButtonVariant ... variants) {
        return UIUtils.createButton((String)text, (VaadinIcon)icon, (String)"", (ButtonVariant[])variants);
    }

    public static Button createButton(String text, LineAwesomeIcon icon, String tooltip, ButtonVariant ... variants) {
        return UIUtils.createButtonByComponent((String)text, (Component)icon.create(), (String)tooltip, (ButtonVariant[])variants);
    }

    public static Button createButton(String text, VaadinIcon icon, String tooltip, ButtonVariant ... variants) {
        Icon i = new Icon(icon);
        i.getElement().setAttribute("slot", "prefix");
        Button button = new Button(text, (Component)i);
        if (variants.length > 0) {
            button.addThemeVariants((ThemeVariant[])variants);
        }
        if (!tooltip.isBlank()) {
            button.getElement().setProperty("title", tooltip);
        }
        return button;
    }

    public static void goToUp(String elementId) {
        String js = "document.getElementById('" + elementId + "').scrollTop = -100;";
        UI.getCurrent().getPage().executeJs(js, new Serializable[0]);
    }

    public static void scrollToBottom(String elementId) {
        UI.getCurrent().getPage().executeJs("const container = document.getElementById($0);\nif (!container) return;\n\nfunction scrollToBottom() {\n  container.scrollTop = container.scrollHeight;\n}\n\nscrollToBottom();\n\nconst imgs = container.getElementsByTagName('img');\nfor (let img of imgs) {\n  img.addEventListener('load', () => scrollToBottom());\n}\n", new Serializable[]{elementId});
    }

    public static void setColor(Color color, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("color", color.getValue());
        }
    }

    public static EmailField createEmailField(String Span2) {
        EmailField emailField = new EmailField(Span2);
        emailField.addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_SMALL});
        return emailField;
    }

    public static TextField createTextField(String label) {
        TextField textField = new TextField();
        textField.setLabel(label);
        textField.addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_SMALL});
        textField.setWidth("min-content");
        textField.setClearButtonVisible(true);
        textField.setId(StringUtil.normalizeToId((String)label));
        textField.setAutocomplete(Autocomplete.OFF);
        return textField;
    }

    public static NumberField createNumberField(String label) {
        return UIUtils.createNumberField((String)label, (Integer)0);
    }

    public static NumberField createNumberField(String label, Integer max) {
        NumberField numberField = new NumberField();
        numberField.setLabel(label);
        numberField.setAutocomplete(Autocomplete.OFF);
        numberField.setWidth("min-content");
        if (max > 0) {
            numberField.setMax((double)max.intValue());
        }
        numberField.setId(StringUtil.normalizeToId((String)label));
        return numberField;
    }

    public static Span createSpanWithWrap(String text) {
        Span span = new Span(text == null ? "" : text);
        span.addClassNames(new String[]{"flex-nowrap", "text-s"});
        span.setId(StringUtil.normalizeToId((String)text));
        return span;
    }

    public static DatePicker createDatePicker(String label) {
        DatePicker dp = new DatePicker(label);
        dp.setLocale(Locale.getDefault());
        return dp;
    }

    public static DateTimePicker createDateTimePicker(String label) {
        DateTimePicker dp = new DateTimePicker(label);
        dp.setLocale(Locale.getDefault());
        return dp;
    }

    public static ComboBox<Object> createComboBox(String label) {
        ComboBox comboBox = new ComboBox(label);
        comboBox.setId(StringUtil.normalizeToId((String)label));
        comboBox.setClearButtonVisible(true);
        comboBox.getElement().setAttribute("autocomplete", "off");
        return comboBox;
    }

    public static Span createBadge(String text, String color) {
        Span badge = new Span(text);
        badge.getStyle().set("background-color", UIUtils.getBadgeColor((String)color)).set("color", "#fff").set("border-radius", "8px").set("padding", "2px 8px").set("font-size", "11px").set("font-weight", "bold").set("margin-left", "4px").set("display", "inline-block").set("vertical-align", "middle");
        return badge;
    }

    private static String getBadgeColor(String color) {
        return switch (color.toLowerCase()) {
            case "success" -> "#18bc9c";
            case "danger" -> "#e74c3c";
            case "warning" -> "#f39c12";
            case "info" -> "#3498db";
            case "gray" -> "#888";
            default -> color.startsWith("#") ? color : "#888";
        };
    }
}

