/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.login.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.login.model.DoisFatoresDesativacao;
import br.com.system.app.features.login.repository.DoisFatoresDesativacaoRepository;
import br.com.system.app.features.sessions.model.Sessions;
import br.com.system.app.features.sessions.service.SessionsService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.datetime.DateTimeUtil;
import de.taimos.totp.TOTP;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DoisFatoresService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private DoisFatoresDesativacaoRepository ddr;
    @Autowired
    private SessionsService sessionsService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private UsuarioService usuarioService;

    public String authByLogin(String passcode, String login) throws Exception {
        Usuario usuario = this.usuarioService.getByLogin(login);
        if (usuario == null) {
            throw new Exception("Usu\u00e1rio n\u00e3o encontrado");
        }
        EstruturaUsuario eu = this.eus.getFirstByUsuario(usuario);
        if (eu == null || !eu.isAtivo() || !eu.getEstrutura().isAtivo()) {
            throw new Exception("Usu\u00e1rio n\u00e3o encontrado");
        }
        if (this.byPass2fa(eu)) {
            return "";
        }
        if (eu.getUsuario().getDataCadastro().atStartOfDay().isAfter(LocalDateTime.now().minusHours(48L))) {
            return "Por favor ative seu 2FA, voc\u00ea tem " + DateTimeUtil.intervaloEmHoras((LocalDateTime)eu.getUsuario().getDataCadastro().atStartOfDay(), (LocalDateTime)LocalDateTime.now().plusHours(48L)) + " horas para ativar.";
        }
        if (passcode.isEmpty()) {
            throw new Exception("Informe o C\u00f3digo Autenticador 2FA");
        }
        if (!this.autenticar(passcode, usuario.getSecretCode())) {
            throw new Exception("C\u00f3digo autenticador inv\u00e1lido");
        }
        return "";
    }

    public boolean autenticar(String passcode, String sc) {
        try {
            return passcode.equals(this.getTOTPCode(sc));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void cancelar(Usuario u) {
        DoisFatoresDesativacao dois = this.ddr.findFirstByUsuarioAndDataDesativacao(u, LocalDate.now());
        if (dois != null) {
            dois.setAtivo(false);
            this.ddr.save((Object)dois);
        }
    }

    public boolean byPass2fa(EstruturaUsuario eu) {
        DoisFatoresDesativacao dois = this.ddr.findFirstByUsuarioAndDataDesativacao(eu.getUsuario(), LocalDate.now());
        return dois != null && dois.isAtivo() && dois.getUltimaHora().plusMinutes(10L).isAfter(LocalTime.now());
    }

    @Async(value="asyncDefault")
    public void check10Minutes(String sessionId) {
        try {
            Sessions sessions = this.sessionsService.getBySessionId(sessionId);
            if (sessions == null) {
                return;
            }
            EstruturaUsuario eu = sessions.getEstruturaUsuario();
            if (eu == null) {
                return;
            }
            DoisFatoresDesativacao dois = this.ddr.findFirstByUsuarioAndDataDesativacao(eu.getUsuario(), LocalDate.now());
            if (dois != null && dois.isAtivo() && dois.getUltimaHora().plusMinutes(10L).isBefore(LocalTime.now())) {
                dois.setAtivo(false);
                this.ddr.save((Object)dois);
                this.sessionsService.encerrarSessao(sessionId);
            }
        }
        catch (Exception e) {
            this.sessionsService.encerrarSessao(sessionId);
            throw new BusinessException("Seus 10 minutos expiraram, por favor ative o 2FA");
        }
    }

    private String getTOTPCode(String secretKey) {
        String hexKey = Hex.encodeHexString((byte[])secretKey.getBytes());
        return TOTP.getOTP((String)hexKey);
    }

    public List<DoisFatoresDesativacao> getBloqueados(Pageable pageable) {
        return this.ddr.findByDataDesativacaoAndQuantasx(LocalDate.now(), Integer.valueOf(3), pageable);
    }

    public long countBloqueados() {
        return this.ddr.countByDataDesativacaoAndQuantasx(LocalDate.now(), Integer.valueOf(3));
    }

    public void desbloquear(DoisFatoresDesativacao dfd) {
        dfd.setQuantasx(Integer.valueOf(0));
        this.ddr.save((Object)dfd);
    }
}

