/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.marketing.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.marketing.model.Marketing;
import br.com.system.app.features.marketing.model.MarketingItem;
import br.com.system.app.features.marketing.model.MarketingItemCampos;
import br.com.system.app.features.marketing.model.MarketingItemStatus;
import br.com.system.app.features.marketing.model.MarketingStatus;
import br.com.system.app.features.marketing.repository.MarketingItemCamposRepository;
import br.com.system.app.features.marketing.repository.MarketingItemRepository;
import br.com.system.app.features.marketing.repository.MarketingRepository;
import br.com.system.app.features.marketing.service.MarketingExportacao;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.util.ExcellUtil;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppTemplateCampos;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class MarketingService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MarketingRepository marketingRepository;
    @Autowired
    private MarketingItemRepository marketingItemRepository;
    @Autowired
    private MarketingItemCamposRepository marketingItemCamposRepository;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;

    public Marketing getById(Long id) {
        return (Marketing)this.marketingRepository.findById((Object)id).get();
    }

    public List<Marketing> getByAtendente(WhatsAppAtendente waa) {
        return this.marketingRepository.findByAtendente(waa);
    }

    public MarketingItem getItemByMessageId(String messageId) {
        if (messageId == null || messageId.isEmpty()) {
            return null;
        }
        return this.marketingItemRepository.findFirstByMessageId(messageId);
    }

    public List<MarketingItem> getByNumero(Estrutura estrutura, String numero) {
        return this.marketingItemRepository.findByNumero(numero);
    }

    public MarketingItem getByNumeroWhats(Estrutura estrutura, String numero) {
        return this.marketingItemRepository.findFirstByMarketingEstruturaUsuarioEstruturaAndNumeroWhatsOrderByIdDesc(estrutura, numero);
    }

    public List<MarketingItem> getByMarketingAndStatus(Marketing m, MarketingItemStatus status) {
        return this.marketingItemRepository.findByMarketingAndStatus(m, status);
    }

    public List<MarketingItem> getByMarketing(Marketing m) {
        return this.marketingItemRepository.findByMarketing(m);
    }

    public MarketingItem getByStatus(Estrutura estrutura, MarketingStatus mStatus, MarketingItemStatus miStatus) {
        return this.marketingItemRepository.findFirstByMarketingEstruturaUsuarioEstruturaAndMarketingStatusAndStatus(estrutura, mStatus, miStatus);
    }

    public void iniciarCampanhaNormal(Marketing m) {
        m.setStatus(MarketingStatus.PROCESSANDO);
        this.save(m);
    }

    public void pausarCampanha(Marketing m) {
        m.setStatus(MarketingStatus.PAUSADA);
        this.save(m);
    }

    public List<Marketing> getByHierarquia(EstruturaUsuario eu, Pageable pageable) {
        Set hierarquia = this.hierarquiaService.getHierarquia(eu);
        return this.marketingRepository.findByHierarquia(hierarquia, pageable);
    }

    public long countByHierarquia(EstruturaUsuario eu) {
        Set hierarquia = this.hierarquiaService.getHierarquia(eu);
        return this.marketingRepository.countByHierarquia(hierarquia);
    }

    public String exportar(Marketing m) {
        List itens = this.getByMarketing(m);
        return new MarketingExportacao().exportar(itens);
    }

    public void delete(Marketing marketing) {
        this.marketingItemCamposRepository.deleteByMarketingItemMarketing(marketing);
        this.marketingItemRepository.deleteByMarketing(marketing);
        this.marketingRepository.delete((Object)marketing);
    }

    public void deleteItens(Marketing m) {
        this.marketingItemCamposRepository.deleteByMarketingItemMarketing(m);
        this.marketingItemRepository.deleteByMarketing(m);
    }

    public void criarCampanha(Marketing m) {
        this.marketingRepository.save((Object)m);
    }

    public Marketing save(Marketing m) {
        return (Marketing)this.marketingRepository.save((Object)m);
    }

    public MarketingItem saveItem(MarketingItem item) {
        return (MarketingItem)this.marketingItemRepository.save((Object)item);
    }

    public List<MarketingItemCampos> getCampos(MarketingItem item) {
        return this.marketingItemCamposRepository.findByMarketingItemOrderByPosicao(item);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Marketing salvarCampanha(EstruturaUsuario eu, Marketing m, InputStream isImage, InputStream isFile) {
        xls = null;
        try {
            if (isImage != null && isImage.available() > 0) {
                hashImg /* !! */  = HashUtil.getUUI() + FileUtil.getExtension((String)m.getFilenameImg());
                StorageUtil.uploadObjectInputStream((String)"files-neosales", (String)hashImg /* !! */ , (String)"image/jpeg", (InputStream)isImage);
                m.setHashImagem((String)hashImg /* !! */ );
            }
            m = this.save(m);
            if (isFile == null || isFile.available() <= 0) {
                hashImg /* !! */  = m;
                return hashImg /* !! */ ;
            }
            template = new HashMap<WhatsAppTemplateCampos, Boolean>();
            if (m.getWhatsappTemplate() != null) {
                for (WhatsAppTemplateCampos wc : m.getWhatsappTemplate().getCampos()) {
                    template.put(wc, Boolean.FALSE);
                }
            }
            xls = new XSSFWorkbook(isFile);
            aba = xls.getSheetAt(0);
            rowCab = aba.getRow(0);
            posNumber = -1;
            for (c = 0; c <= rowCab.getLastCellNum(); ++c) {
                if (rowCab.getCell(c) == null) continue;
                campo = rowCab.getCell(c).getStringCellValue().trim();
                if (campo.toLowerCase().equals("#numero")) {
                    posNumber = c;
                    if (m.getWhatsappTemplate() == null) break;
                }
                campo = null;
            }
            if (posNumber < 0) {
                throw new BusinessException("N\u00e3o encontrei coluna #numero");
            }
            i = 1;
            ** GOTO lbl47
        }
        catch (Exception ex) {
            try {
                throw new BusinessException(ex.getMessage());
            }
            finally {
                try {
                    xls.close();
                    isFile.close();
                    xls = null;
                    isFile = null;
                }
                catch (Exception var22_29) {}
            }
lbl47:
            // 1 sources

            while (true) {
                if (i > aba.getLastRowNum()) ** GOTO lbl61
                row = aba.getRow(i);
                if (row == null || !TelefoneUtil.isValid((String)(numero = StringUtil.numbersOnly((String)ExcellUtil.getValueString((Cell)(cellN = row.getCell(posNumber.intValue()))))))) ** GOTO lbl116
                mi = new MarketingItem();
                mi.setMarketing(m);
                mi.setNumero(numero);
                mi.setStatus(MarketingItemStatus.AGUARDANDO);
                mi = (MarketingItem)this.marketingItemRepository.save((Object)mi);
                ** GOTO lbl69
                {
                    block32: {
                        catch (Exception var11_15) {
                            // empty catch block
                            break block32;
                        }
lbl61:
                        // 1 sources

                        var10_13 = m;
                        try {
                            xls.close();
                            isFile.close();
                            return var10_13;
                        }
                        catch (Exception var11_16) {
                            // empty catch block
                        }
                        return var10_13;
lbl69:
                        // 3 sources

                        for (c = 0; c <= row.getLastCellNum(); ++c) {
                            if (rowCab.getCell(c) == null || (campo = rowCab.getCell(c).getStringCellValue().trim()).toLowerCase().equals("#numero")) continue;
                            cab = null;
                            for (Map.Entry<K, V> pair : template.entrySet()) {
                                if (!((WhatsAppTemplateCampos)pair.getKey()).getCampo().equals(campo)) continue;
                                cab = (WhatsAppTemplateCampos)pair.getKey();
                                template.put(cab, true);
                                break;
                            }
                            for (WhatsAppTemplateCampos wc : m.getWhatsappTemplate().getCampos()) {
                                if (!wc.getCampo().equals(campo)) continue;
                                cab = wc;
                                break;
                            }
                            cell = row.getCell(c);
                            valor = ExcellUtil.getValueString((Cell)cell);
                            mic = new MarketingItemCampos();
                            mic.setCampo(campo);
                            mic.setMarketingItem(mi);
                            mic.setValor(valor);
                            if (cab != null) {
                                mic.setPosicao(cab.getPosicao());
                            }
                            this.marketingItemCamposRepository.save((Object)mic);
                            mic = null;
                            campo = null;
                            cell = null;
                            valor = null;
                        }
                        row = null;
                        numero = null;
                        mi = null;
                        erro = "";
                        for (Map.Entry<K, V> pair : template.entrySet()) {
                            if (((Boolean)pair.getValue()).booleanValue()) continue;
                            erro = (String)erro + "Campo " + ((WhatsAppTemplateCampos)pair.getKey()).getCampo() + " n\u00e3o localizado no arquivo";
                        }
                        if (!erro.isEmpty()) {
                            m.setStatus(MarketingStatus.ERRO);
                            m.setObservacao((String)erro);
                            var16_22 = this.save(m);
                            try {
                                xls.close();
                                isFile.close();
                                return var16_22;
                            }
                            catch (Exception var17_24) {
                                // empty catch block
                            }
                            return var16_22;
                        }
lbl116:
                        // 3 sources

                        ** try [egrp 6[TRYBLOCK] [11 : 871->885)] { 
                    }
                    ++i;
                    continue;
                }
                break;
            }
lbl120:
            // 2 sources

            catch (Throwable var21_28) {
                throw var21_28;
            }
        }
    }

    public void checkFinish(Marketing m) {
        List aguardando = this.getByMarketingAndStatus(m, MarketingItemStatus.AGUARDANDO);
        if (aguardando == null || aguardando.size() <= 0) {
            m.setDataHoraFim(LocalDateTime.now());
            m.setStatus(MarketingStatus.FINALIZADA);
            this.save(m);
        }
    }

    public String getMensagem(MarketingItem item) {
        String mensagem = item.getMarketing().getMensagem();
        List campos = this.getCampos(item);
        if (!campos.isEmpty() && mensagem != null) {
            for (MarketingItemCampos mic : campos) {
                mensagem = mensagem.replace(mic.getCampo(), mic.getValor());
            }
        }
        return mensagem;
    }

    public void deleteByEstrutura(Estrutura estrutura) {
        List marketings = this.marketingRepository.findByEstruturaUsuarioEstrutura(estrutura);
        for (Marketing marketing : marketings) {
            this.delete(marketing);
        }
    }
}

