/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.modeloproposta;

import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.modeloproposta.model.ModeloProposta;
import br.com.system.app.features.modeloproposta.repository.ModeloPropostaRepository;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ModeloPropostaForm
extends Dialog {
    private static final long serialVersionUID = 1L;
    private ModeloProposta modeloProposta;
    private final EstruturaUsuario eu;
    private final ModeloPropostaRepository repository;
    private final EquipeService equipeService;
    private TextField nome;
    private Checkbox cbAtivo;
    private Button btnSalvar;
    private Button btnFechar;
    private TextArea conteudoHtml;
    private Set<String> hashImages;
    private String hashSelecionado;
    private TextField linkImage;
    private HorizontalContainer div;
    private String nomeArquivo = "";
    private MultiComboBox<Equipe> cbEquipe;
    private TempFileMultiBuffer mBuffer;
    private DownloadDialog dd;

    public ModeloPropostaForm(EstruturaUsuario eu, ModeloPropostaRepository repository, ModeloProposta modeloProposta, EquipeService equipeService) {
        this.eu = eu;
        this.modeloProposta = modeloProposta;
        this.repository = repository;
        this.equipeService = equipeService;
        this.create();
    }

    private void create() {
        this.dd = new DownloadDialog();
        this.setCloseOnOutsideClick(false);
        this.setWidth("800px");
        this.setHeightFull();
        if (this.modeloProposta == null) {
            this.modeloProposta = new ModeloProposta();
        } else {
            this.hashImages = new HashSet();
            if (this.modeloProposta.getHashImages() != null && !this.modeloProposta.getHashImages().isBlank()) {
                this.hashImages.addAll(Arrays.asList(this.modeloProposta.getHashImages().split(",")));
            }
        }
        this.div = new HorizontalContainer(new Component[0]);
        this.div.setWidth("80%");
        this.div.setAlignItems(FlexComponent.Alignment.CENTER);
        this.div.setHeight("200px");
        this.div.setWidthFull();
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{this.div});
        this.nome = new TextField("Nome Modelo");
        this.nome.setValue(this.modeloProposta.getNome() == null ? "" : this.modeloProposta.getNome());
        this.cbAtivo = new Checkbox("Ativo");
        this.cbAtivo.setValue((Object)this.modeloProposta.getAtivo());
        this.cbEquipe = new MultiComboBox("Equipes", (Collection)this.equipeService.getEquipes(this.eu.getEstrutura()));
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        if (this.modeloProposta.getListaEquipe() != null && !this.modeloProposta.getListaEquipe().isBlank()) {
            this.cbEquipe.setValue(new HashSet(this.equipeService.getByIds(this.modeloProposta.getListaEquipe())));
        }
        if (this.modeloProposta.getId() == null) {
            Button criar = UIUtils.createSmallButton((String)"Criar Modelo", (String)"");
            criar.addClickListener((ComponentEventListener & Serializable)e -> {
                if (this.nome.getValue().isBlank()) {
                    UIUtils.showNotification((String)"Informe um nome para o modelo");
                    return;
                }
                this.modeloProposta.setNome(this.nome.getValue());
                this.modeloProposta.setAtivo((Boolean)this.cbAtivo.getValue());
                this.modeloProposta.setEstrutura(this.eu.getEstrutura());
                this.modeloProposta = (ModeloProposta)this.repository.save((Object)this.modeloProposta);
                this.create();
            });
            this.add(new Component[]{new HorizontalContainer(new Component[]{this.nome, criar})});
            this.open();
            return;
        }
        this.linkImage = new TextField("Link da Imagem");
        this.linkImage.setWidth("300px");
        Button btnExcluir = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir imagem");
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.hashSelecionado == null || this.hashSelecionado.isBlank()) {
                UIUtils.showNotification((String)"Selecione uma imagem para excluir");
                return;
            }
            try {
                StorageUtil.deleteObject((String)this.hashSelecionado);
            }
            catch (Exception e1) {
                UIUtils.showError((String)("Erro ao excluir imagem " + e1.getMessage()));
            }
            this.hashImages.remove(this.hashSelecionado);
            this.setImages();
            this.save();
        });
        this.setImages();
        this.conteudoHtml = new TextArea("Conteudo HTML");
        this.conteudoHtml.setValue(this.modeloProposta.getConteudoHtml() == null ? "" : this.modeloProposta.getConteudoHtml());
        this.conteudoHtml.setWidthFull();
        this.conteudoHtml.setHeightFull();
        this.btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        this.btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.btnSalvar = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX);
        this.btnSalvar.addClickListener((ComponentEventListener & Serializable)salvar -> {
            if (!this.getErros().isEmpty()) {
                UIUtils.showNotification((String)this.getErros());
                return;
            }
            this.save();
            this.close();
        });
        Button btnVisualizar = UIUtils.createSmallButton((String)"Visualizar", (String)"");
        btnVisualizar.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                String link = StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".html"), (byte[])this.conteudoHtml.getValue().getBytes());
                this.dd.open(link, "Modelo-proposta.html");
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
        });
        HorizontalContainer c = new HorizontalContainer(new Component[]{this.div, this.createUpload()});
        c.setAlignItems(FlexComponent.Alignment.START);
        c.setNoWrap();
        HorizontalContainer c2 = new HorizontalContainer(new Component[]{this.linkImage});
        c2.add(new Component[]{btnExcluir});
        c2.setNoWrap();
        this.add(new Component[]{new VerticalContainer(new Component[]{new HorizontalContainer(new Component[]{this.nome, this.cbAtivo, this.cbEquipe}), new Span("#quebraPagina, #nomeCliente, #numeroProposta, #observacaoProposta, #negociacaoCompMensal, #negociacaoOutros, #totalGigas, #valorCompMensal, #valorOutros, #valorOutros10x,#valorOutros12x,#valorOutros24x,#compMensalOutros24x, #valorTotal, #valorFatura, #diferenca, #economia24Meses, #percentualEconomia, #nomeUsuario, #emailUsuario, #celularUsuario"), c, c2, btnVisualizar, new FooterContainer(new Component[]{this.btnFechar, this.btnSalvar}), this.conteudoHtml})});
        this.open();
    }

    private void setImages() {
        this.div.removeAll();
        for (String hash : this.hashImages) {
            StreamResource streamResource;
            if (hash.isBlank() || (streamResource = StorageUtil.getStreamResource((String)hash.trim(), (String)this.nomeArquivo)) == null) continue;
            Image img = new Image((AbstractStreamResource)streamResource, this.nomeArquivo);
            UIUtils.setShadow((Shadow)Shadow.XS, (Component[])new Component[]{img});
            img.setMaxWidth("120px");
            img.setMaxHeight("120px");
            img.setId(hash.trim());
            img.addClickListener((ComponentEventListener & Serializable)e -> {
                this.hashSelecionado = hash.trim();
                this.removeShadow();
                UIUtils.setShadow((Shadow)Shadow.M, (Component[])new Component[]{img});
                this.linkImage.setValue((String)((Image)e.getSource()).getId().get());
            });
            this.div.add(new Component[]{img});
        }
    }

    private void removeShadow() {
        this.div.getChildren().forEach(e -> UIUtils.setShadow((Shadow)Shadow.XS, (Component[])new Component[]{e}));
    }

    public Button getBtnSalvar() {
        return this.btnSalvar;
    }

    public String getErros() {
        Object erros = "";
        if (this.nome.isEmpty()) {
            erros = (String)erros + "Informe um nome\n";
        }
        if (this.conteudoHtml.getValue().isEmpty()) {
            erros = (String)erros + "Informe o conteudo da proposta\n";
        }
        return erros;
    }

    public ModeloProposta save() {
        this.modeloProposta.setEstrutura(this.eu.getEstrutura());
        this.modeloProposta.setAtivo((Boolean)this.cbAtivo.getValue());
        this.modeloProposta.setNome(this.nome.getValue());
        this.modeloProposta.setConteudoHtml(this.conteudoHtml.getValue());
        this.modeloProposta.setHashImages(StringUtils.join((Iterable)this.hashImages, (String)","));
        HashSet<Long> ids = new HashSet<Long>();
        for (Equipe e : this.cbEquipe.getValue()) {
            ids.add(e.getId());
        }
        this.modeloProposta.setListaEquipe(StringUtils.join(ids, (String)","));
        return (ModeloProposta)this.repository.save((Object)this.modeloProposta);
    }

    private VerticalContainer createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{".png", ".jpg", ".jpeg", ".gif"});
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em ENVIAR");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas imagens"));
        Button processar = UIUtils.createSmallButton((String)"Enviar Imagem", (VaadinIcon)VaadinIcon.COGS);
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    String extensao = FileUtil.getExtension((String)this.mBuffer.getFileName());
                    String hashArquivo = HashUtil.getUUI() + extensao;
                    this.hashImages.add(hashArquivo);
                    StorageUtil.uploadObjectInputStream((String)hashArquivo, (String)FileUtil.getContentType((String)this.mBuffer.getFileName()), (InputStream)this.mBuffer.getInputStream());
                    upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                    this.save();
                    this.nomeArquivo = "";
                    this.mBuffer.clear();
                    this.setImages();
                }
                catch (Exception ex) {
                    UIUtils.showNotification((String)ex.getMessage());
                }
            }
        });
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.setWidth("10%");
        v.add(new Component[]{upload});
        v.add(new Component[]{processar});
        return v;
    }
}

