/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.model;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

@Entity
@Table(name="pedido_etapa")
public class PedidoEtapa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @JsonIgnore
    @OneToOne
    private Estrutura estrutura;
    @NotNull
    private String nome;
    private String descricao;
    @NotNull
    private boolean ativo;
    private boolean sincronizavel;
    private boolean editavel;
    @NotNull
    @OneToOne
    private PedidoOrigem pedidoOrigem;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private PedidoTipoEnum pedidoTipo;
    private Integer slaHoras;
    private LocalDateTime dataHoraAtualizacao;
    private Boolean obrigaTagRetornoFuturo;
    private Boolean atualizaDataReferencia;

    public String getNomeAndOrigem() {
        return this.getNome() + "(" + this.getPedidoOrigem().getNome() + ")";
    }

    public String getNomeAndOrigemAndTipo() {
        return this.getNome() + "(" + this.getPedidoOrigem().getNome() + ") - " + this.getPedidoTipo().name();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Estrutura getEstrutura() {
        return this.estrutura;
    }

    public void setEstrutura(Estrutura estrutura) {
        this.estrutura = estrutura;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public PedidoOrigem getPedidoOrigem() {
        return this.pedidoOrigem;
    }

    public void setPedidoOrigem(PedidoOrigem pedidoOrigem) {
        this.pedidoOrigem = pedidoOrigem;
    }

    public boolean isSincronizavel() {
        return this.sincronizavel;
    }

    public void setSincronizavel(boolean sincronizavel) {
        this.sincronizavel = sincronizavel;
    }

    public PedidoTipoEnum getPedidoTipo() {
        return this.pedidoTipo;
    }

    public void setPedidoTipo(PedidoTipoEnum pedidoTipo) {
        this.pedidoTipo = pedidoTipo;
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.editavel = editavel;
    }

    public Integer getSlaHoras() {
        return this.slaHoras;
    }

    public void setSlaHoras(Integer slaHoras) {
        this.slaHoras = slaHoras;
    }

    public LocalDateTime getDataHoraAtualizacao() {
        return this.dataHoraAtualizacao;
    }

    public void setDataHoraAtualizacao(LocalDateTime dataHoraAtualizacao) {
        this.dataHoraAtualizacao = dataHoraAtualizacao;
    }

    public Boolean getObrigaTagRetornoFuturo() {
        return this.obrigaTagRetornoFuturo;
    }

    public void setObrigaTagRetornoFuturo(Boolean obrigaTagRetornoFuturo) {
        this.obrigaTagRetornoFuturo = obrigaTagRetornoFuturo;
    }

    public Boolean getAtualizaDataReferencia() {
        return this.atualizaDataReferencia;
    }

    public void setAtualizaDataReferencia(Boolean atualizaDataReferencia) {
        this.atualizaDataReferencia = atualizaDataReferencia;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PedidoEtapa other = (PedidoEtapa)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "PedidoEtapa{nome=" + this.nome + ", descricao=" + this.descricao + ", ativo=" + this.ativo + ", sincronizavel=" + this.sincronizavel + ", editavel=" + this.editavel + ", pedidoOrigem=" + String.valueOf(this.pedidoOrigem) + ", pedidoTipo=" + String.valueOf(this.pedidoTipo) + ", slaHoras=" + this.slaHoras + "}";
    }
}

