/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.dto.PedidoEtapaBIDTO;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.repository.PedidoEtapaRepository;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoEtapaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String NOME_ETAPA_INICIAL_COMERCIAL = "AGUARDANDO INTERACAO";
    private final String NOME_ETAPA_INICIAL_POS_VENDA = "AGUARDANDO TRATAMENTO";
    private final String NOME_ETAPA_INICIAL_WHATSAPP = "AGUARDANDO ATENDIMENTO";
    private final String NOME_ETAPA_FINAL_WHATSAPP = "FINALIZADO";
    private final String NOME_RETORNO_FUTURO = "RETORNO FUTURO";
    private final String NOME_VENDA_PERDIDA = "VENDA PERDIDA";
    private final String NOME_ARQUIVADO = "ARQUIVADO";
    private final String NOME_AGUARDANDO_SINCRONIA = "AGUARDANDO SINCRONIA";
    private final String NOME_ETAPA_INTERACAO = "INTERACAO COM CLIENTE";
    @Autowired
    private PedidoEtapaRepository pedidoEtapaRepository;
    @Autowired
    private PedidoOrigemService pedidoOrigemService;

    public PedidoEtapa save(PedidoEtapa pe) {
        if (pe.getObrigaTagRetornoFuturo() == null) {
            pe.setObrigaTagRetornoFuturo(Boolean.valueOf(true));
        }
        if (pe.getAtualizaDataReferencia() == null) {
            pe.setAtualizaDataReferencia(Boolean.valueOf(false));
        }
        return (PedidoEtapa)this.pedidoEtapaRepository.save((Object)pe);
    }

    @Transactional
    public void delete(PedidoEtapa pe) {
        this.pedidoEtapaRepository.delete((Object)pe);
    }

    public List<PedidoEtapa> filter(Estrutura estrutura, String nome, PedidoTipoEnum tipo, Boolean ativo, Boolean sincronizavel, Boolean editavel, Pageable pageable) {
        if (nome != null && !nome.isEmpty()) {
            return this.pedidoEtapaRepository.findByEstruturaAndNomeContainsAndPedidoTipo(estrutura, nome, tipo, pageable);
        }
        return this.pedidoEtapaRepository.findByEstruturaAndPedidoTipoAndAtivoAndSincronizavelAndEditavel(estrutura, tipo, ativo, sincronizavel, editavel, pageable);
    }

    public long count(Estrutura estrutura, String nome, PedidoTipoEnum tipo, Boolean ativo, Boolean sincronizavel, Boolean editavel) {
        if (nome != null && !nome.isEmpty()) {
            return this.pedidoEtapaRepository.countByEstruturaAndNomeContainsAndPedidoTipo(estrutura, nome, tipo);
        }
        return this.pedidoEtapaRepository.countByEstruturaAndPedidoTipoAndAtivoAndSincronizavelAndEditavel(estrutura, tipo, ativo, sincronizavel, editavel);
    }

    public PedidoEtapa getById(Long id) {
        Optional optPe = this.pedidoEtapaRepository.findById((Object)id);
        if (optPe.isPresent()) {
            return (PedidoEtapa)optPe.get();
        }
        return null;
    }

    public PedidoEtapa getEtapaAguardandoSincronia(Estrutura estrutura, PedidoOrigem origem) {
        return this.getAndCreate(estrutura, "AGUARDANDO SINCRONIA", origem, PedidoTipoEnum.COMERCIAL);
    }

    public PedidoEtapa getEtapaInicial(Estrutura estrutura, PedidoTipoEnum pte) {
        if (pte.equals((Object)PedidoTipoEnum.COMERCIAL)) {
            return this.getAndCreate(estrutura, "AGUARDANDO INTERACAO", this.pedidoOrigemService.getOrigemAtividade(estrutura), pte);
        }
        if (pte.equals((Object)PedidoTipoEnum.POS_VENDA)) {
            return this.getAndCreate(estrutura, "AGUARDANDO TRATAMENTO", this.pedidoOrigemService.getOrigemAtividade(estrutura), pte);
        }
        if (pte.equals((Object)PedidoTipoEnum.WHATSAPP)) {
            return this.getAndCreate(estrutura, "AGUARDANDO ATENDIMENTO", this.pedidoOrigemService.getOrigemAtividade(estrutura), pte);
        }
        return null;
    }

    public PedidoEtapa getEtapaFinal(Estrutura estrutura, PedidoTipoEnum pte) {
        if (pte.equals((Object)PedidoTipoEnum.WHATSAPP)) {
            return this.getAndCreate(estrutura, "FINALIZADO", this.pedidoOrigemService.getOrigemAtividade(estrutura), pte);
        }
        return null;
    }

    public PedidoEtapa getEtapaArquivamento(Estrutura estrutura, PedidoTipoEnum tipo) {
        return this.getAndCreate(estrutura, "ARQUIVADO", this.pedidoOrigemService.getOrigemAtividade(estrutura), tipo);
    }

    public PedidoEtapa getEtapaRetornoFuturo(Estrutura estrutura, PedidoTipoEnum pte) {
        return this.getAndCreate(estrutura, "RETORNO FUTURO", this.pedidoOrigemService.getOrigemAtividade(estrutura), pte);
    }

    public PedidoEtapa getEtapaVendaPerdida(Estrutura estrutura) {
        return this.getAndCreate(estrutura, "VENDA PERDIDA", this.pedidoOrigemService.getOrigemAtividade(estrutura), PedidoTipoEnum.COMERCIAL);
    }

    public PedidoEtapa getEtapaInteracao(Estrutura estrutura) {
        return this.getAndCreate(estrutura, "INTERACAO COM CLIENTE", this.pedidoOrigemService.getOrigemAtividade(estrutura), PedidoTipoEnum.COMERCIAL);
    }

    public PedidoEtapa getEtapaFinanceiro(Estrutura estrutura) {
        return this.getAndCreate(estrutura, "FINANCEIRO", this.pedidoOrigemService.getOrigemAtividade(estrutura), PedidoTipoEnum.WHATSAPP);
    }

    public List<PedidoEtapa> getAllAtivos(Estrutura estrutura) {
        return this.pedidoEtapaRepository.findByEstruturaAndAtivoOrderByNome(estrutura, Boolean.valueOf(true));
    }

    public List<PedidoEtapa> getAtivos(Estrutura estrutura, PedidoTipoEnum pte) {
        return this.pedidoEtapaRepository.findByEstruturaAndAtivoAndPedidoTipoOrderByNome(estrutura, Boolean.valueOf(true), pte);
    }

    public List<PedidoEtapa> getAtivos(Estrutura estrutura, PedidoTipoEnum pte, PedidoOrigem origem) {
        return this.pedidoEtapaRepository.findByEstruturaAndAtivoAndPedidoTipoAndPedidoOrigemOrderByNome(estrutura, Boolean.valueOf(true), pte, origem);
    }

    public List<PedidoEtapa> getAtivos(Estrutura estrutura, String nome, PedidoTipoEnum pte) {
        return this.pedidoEtapaRepository.findByEstruturaAndNomeAndAtivoAndPedidoTipoOrderByNome(estrutura, nome, Boolean.TRUE, pte);
    }

    public List<PedidoEtapa> getAtivosNomeContains(Estrutura estrutura, String nome, PedidoOrigem po, PedidoTipoEnum pte) {
        try {
            if (!nome.isEmpty()) {
                return this.pedidoEtapaRepository.findByNomeContainingAndEstruturaAndAtivoAndPedidoOrigemAndPedidoTipoOrderByNome(nome, estrutura, Boolean.valueOf(true), po, pte);
            }
            return this.pedidoEtapaRepository.findByEstruturaAndAtivoAndPedidoOrigemAndPedidoTipoOrderByNome(estrutura, Boolean.TRUE, po, pte);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public PedidoEtapa getByNome(Estrutura estrutura, String nome, PedidoOrigem pedidoOrigem, PedidoTipoEnum pte) {
        List lpe = this.pedidoEtapaRepository.findByEstruturaAndNomeAndPedidoOrigemAndPedidoTipoOrderByNome(estrutura, nome, pedidoOrigem, pte);
        if (lpe == null || lpe.size() <= 0) {
            return null;
        }
        return (PedidoEtapa)lpe.get(0);
    }

    public PedidoEtapa getAndCreate(Estrutura estrutura, String nome, PedidoOrigem pedidoOrigem, PedidoTipoEnum pte) {
        if ((nome = StringUtil.normalize((String)nome).toUpperCase()).isEmpty()) {
            throw new BusinessException("Nome da etapa do pedido n\u00e3o informado");
        }
        List lpe = this.pedidoEtapaRepository.findByEstruturaAndNomeAndPedidoOrigemAndPedidoTipoOrderByNome(estrutura, nome, pedidoOrigem, pte);
        if (lpe == null || lpe.size() <= 0) {
            return this.createEtapa(estrutura, nome, pedidoOrigem, pte);
        }
        PedidoEtapa pe = (PedidoEtapa)lpe.get(0);
        return pe;
    }

    private PedidoEtapa createEtapa(Estrutura estrutura, String nome, PedidoOrigem pedidoOrigem, PedidoTipoEnum pte) {
        PedidoEtapa pe = new PedidoEtapa();
        pe.setAtivo(true);
        pe.setEstrutura(estrutura);
        pe.setNome(nome);
        pe.setPedidoOrigem(pedidoOrigem);
        pe.setSincronizavel(true);
        pe.setEditavel(true);
        pe.setPedidoTipo(pte);
        pe.setSlaHoras(Integer.valueOf(24));
        pe.setObrigaTagRetornoFuturo(Boolean.TRUE);
        return this.salvar(pe, estrutura);
    }

    public PedidoEtapa salvar(PedidoEtapa etapa, Estrutura estrutura) {
        etapa.setEstrutura(estrutura);
        etapa.setDataHoraAtualizacao(LocalDateTime.now());
        if (etapa.getSlaHoras() == null) {
            etapa.setSlaHoras(Integer.valueOf(0));
        }
        return (PedidoEtapa)this.pedidoEtapaRepository.save((Object)etapa);
    }

    public List<PedidoEtapaBIDTO> getForBi(Long estruturaId, LocalDateTime dataHoraUltimaCarga) {
        return this.pedidoEtapaRepository.findForBi(estruturaId, dataHoraUltimaCarga);
    }

    public String exportar(EstruturaUsuario eu, List<PedidoEtapa> etapas) {
        InputStream isModelo = null;
        XSSFWorkbook appXls = null;
        try {
            isModelo = StorageUtil.getObjectModelo((String)"ExportacaoEtapa-v1.xlsx");
            appXls = new XSSFWorkbook(isModelo);
            Sheet aba = appXls.getSheet("Exportacao");
            int ind = 0;
            for (PedidoEtapa pe : etapas) {
                Row row = aba.createRow(++ind);
                row.createCell(0).setCellValue(pe.getNome());
                row.createCell(1).setCellValue(pe.isAtivo() ? "SIM" : "N\u00c3O");
                row.createCell(2).setCellValue(pe.isEditavel() ? "SIM" : "N\u00c3O");
                row.createCell(3).setCellValue(pe.isSincronizavel() ? "SIM" : "N\u00c3O");
                row.createCell(4).setCellValue((double)pe.getSlaHoras().intValue());
                row.createCell(5).setCellValue(pe.getPedidoOrigem().getNome());
                row.createCell(6).setCellValue(pe.getPedidoTipo().name());
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)appXls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                isModelo.close();
                appXls.close();
                isModelo = null;
                appXls = null;
            }
            catch (Exception exception) {}
        }
    }
}

