/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.enriquecimento.model.EnriquecimentoItens;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoFindService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.oportunidade.model.OportunidadeFileItem;
import br.com.system.app.features.oportunidade.service.OportunidadeFindService;
import br.com.system.app.features.pedido.dto.AtividadeTagsActionEnum;
import br.com.system.app.features.pedido.dto.PedidoResumeDTO;
import br.com.system.app.features.pedido.dto.PedidoTipoEncarteiramentoEnum;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoAnexo;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoItem;
import br.com.system.app.features.pedido.model.PedidoItemDados;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.model.PedidoTipoNegociacaoEnum;
import br.com.system.app.features.pedido.repository.PedidoRepository;
import br.com.system.app.features.pedido.service.LeadTypeEnum;
import br.com.system.app.features.pedido.service.PedidoAnexoService;
import br.com.system.app.features.pedido.service.PedidoDeleteService;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemService;
import br.com.system.app.features.pedido.service.PedidoMovimentacaoService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoStatusService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoFilter;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.exception.ResourceNotFoundException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.service.WhatsAppTransfService;
import br.com.system.commons.FileUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(PedidoService.class);
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoOrigemService pedidoOrigemService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private PedidoTagsService pedidoTagsService;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoMovimentacaoService pedidoMovimentacaoService;
    @Autowired
    private PedidoItemService pedidoItemService;
    @Autowired
    private ProducaoPainelRepository producaoPainelRepository;
    @Autowired
    private PedidoAnexoService pedidoAnexoService;
    @Autowired
    private EstruturaComplementoService complementoService;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private PedidoStatusService pedidoStatuService;
    @Autowired
    private WhatsAppTransfService whatsAppTransfService;
    @Autowired
    private PedidoDeleteService pedidoDeleteService;
    @Autowired
    private EnriquecimentoFindService enriquecimentoFindService;
    @Autowired
    private OportunidadeFindService oportunidadeFindService;

    public Pedido salvar(Pedido pedido, String movimentacao, EstruturaUsuario euContext, boolean notificar) {
        Pedido pO = this.getById(pedido.getId());
        if (pO != null && !pO.getPedidoEtapa().getId().equals(pedido.getPedidoEtapa().getId())) {
            this.pedidoStatuService.movimentar(pO, pedido.getPedidoEtapa(), euContext, movimentacao);
        }
        pedido = this.salvar(pedido);
        if (movimentacao != null && !movimentacao.isBlank()) {
            this.pedidoMovimentacaoService.insertMovimentacao(pedido, euContext, movimentacao, notificar, true);
        }
        return pedido;
    }

    public Pedido salvar(Pedido pedido) {
        if (pedido == null) {
            throw new BusinessException("Pedido invalido");
        }
        if (pedido.getEstruturaUsuario() == null) {
            throw new BusinessException("Estrutura nao informada");
        }
        if (pedido.getEstruturaUsuario() == null) {
            pedido.setEstruturaUsuario(pedido.getEstruturaUsuario());
        }
        if (pedido.getDataCadastro() == null) {
            pedido.setDataCadastro(LocalDate.now());
        }
        pedido.setDataHoraAtualizacao(LocalDateTime.now());
        pedido.setNumeroPedidoVinculado(pedido.getNumeroPedidoVinculado() == null ? null : pedido.getNumeroPedidoVinculado().trim());
        pedido.setNumeroPedidoOrigem(pedido.getNumeroPedidoOrigem() == null ? null : pedido.getNumeroPedidoOrigem().trim());
        if (pedido.getLeadSistema() == null) {
            EnriquecimentoItens enriquecimento = this.enriquecimentoFindService.getByEstruturaAndCpfCnpj(pedido.getEstruturaUsuario().getEstrutura(), pedido.getCliente().getCpfCnpj());
            if (enriquecimento != null) {
                pedido.setLeadSistema(LeadTypeEnum.HOT_LEAD);
            } else {
                OportunidadeFileItem item = this.oportunidadeFindService.getByEstruturaAndCpfCnpj(pedido.getEstruturaUsuario().getEstrutura(), pedido.getCliente().getCpfCnpj());
                if (item != null) {
                    pedido.setLeadSistema(LeadTypeEnum.HOT_LEAD);
                }
            }
        }
        return this.persistir(pedido);
    }

    @Transactional
    private Pedido persistir(Pedido pedido) {
        if (pedido.getCliente() == null) {
            throw new BusinessException("Cliente n\u00e3o encontrado: " + pedido.getId());
        }
        if (pedido.getPedidoTipo() == null) {
            throw new BusinessException("Pedido Tipo nao definido");
        }
        if (pedido.getPedidoEtapa() == null) {
            pedido.setPedidoEtapa(this.pedidoEtapaService.getEtapaInicial(pedido.getEstruturaUsuario().getEstrutura(), pedido.getPedidoTipo()));
        }
        if (pedido.getPedidoOrigem() == null) {
            pedido.setPedidoOrigem(this.pedidoOrigemService.getOrigemAtividade(pedido.getEstruturaUsuario().getEstrutura()));
        }
        if (pedido.getDataHoraAtualizacao() == null) {
            pedido.setDataHoraAtualizacao(LocalDateTime.now());
        }
        if (pedido.getNumero() == null) {
            pedido.setNumero("");
        }
        if (pedido.getTipoNegociacao() == null) {
            pedido.setTipoNegociacao(PedidoTipoNegociacaoEnum.NOVO);
        }
        if (pedido.getDataHoraUltimaMov() == null) {
            pedido.setDataHoraUltimaMov(LocalDateTime.now());
        }
        if (pedido.getTags() == null) {
            pedido.setTags("");
        }
        if (pedido.getTotal() == null) {
            pedido.setTotal(BigDecimal.ZERO);
        }
        if (pedido.getValorFaturaOrigem() == null) {
            pedido.setValorFaturaOrigem(BigDecimal.ZERO);
        }
        if (pedido.getCompromissoMensal() == null) {
            pedido.setCompromissoMensal(BigDecimal.ZERO);
        }
        boolean novo = pedido.getId() == null;
        Pedido pedidoGravado = (Pedido)this.pedidoRepository.save((Object)pedido);
        if (pedidoGravado.getNumero().isBlank()) {
            pedidoGravado.setNumero(pedidoGravado.getId().toString());
            pedidoGravado = (Pedido)this.pedidoRepository.save((Object)pedidoGravado);
        }
        if (pedido.getTags() != null && !pedido.getTags().isBlank()) {
            this.pedidoTagsService.saveTags(pedido.getTags(), pedido.getPedidoTipo(), pedido.getEstruturaUsuario());
        }
        if (pedido.getId() == null) {
            this.pedidoStatuService.entrar(pedidoGravado, pedidoGravado.getPedidoEtapa(), pedido.getEstruturaUsuario(), "Cadastro atividade");
        }
        if (novo) {
            this.pedidoMovimentacaoService.insertMovimentacao(pedidoGravado.getId(), pedidoGravado.getEstruturaUsuario(), "Cadastro atividade", false, true);
        }
        return pedidoGravado;
    }

    public Pedido getLast(Estrutura estrutura, Long clienteId) {
        return this.pedidoRepository.findFirstByEstruturaUsuarioEstruturaAndClienteIdOrderByIdDesc(estrutura, clienteId);
    }

    @Transactional
    public void excluirTag(List<PedidoTags> pts, EstruturaUsuario eu, Set<Long> hierarquia) {
        Thread.currentThread().setName("asyncDefault-excluir-tag");
        StringBuilder s = new StringBuilder();
        for (PedidoTags pt : pts) {
            try {
                this.removerTag(pt, eu, hierarquia, true, false);
                this.pedidoTagsService.delete(pt);
                s.append("Tag ").append(pt.getTag()).append(" excluida\n");
            }
            catch (Exception e) {
                s.append("Tag ").append(pt.getTag()).append(" erro ").append(e.getMessage()).append("\n");
            }
        }
        this.notificacoesService.notify(eu, "Exclus\u00e3o de tags Atividade", s.toString());
    }

    @Transactional
    public void excluirTag(PedidoTags pt, EstruturaUsuario eu, Set<Long> hierarquia) throws Exception {
        this.removerTag(pt, eu, hierarquia, true, true);
        this.pedidoTagsService.delete(pt);
    }

    @Transactional
    public void removerTag(PedidoTags pt, EstruturaUsuario eu, Set<Long> hierarquia, boolean forcar, boolean notificar) {
        HashSet<PedidoTags> htag = new HashSet<PedidoTags>();
        htag.add(pt);
        ProducaoPedidoFilter filter = new ProducaoPedidoFilter(pt.getEstrutura(), new HashSet(), hierarquia, new HashSet(), new HashSet(), htag, pt.getPedidoTipo(), null, "", null, null);
        List listaPedido = this.producaoPainelRepository.getProducaoByPedido(eu, filter, Boolean.valueOf(false), null);
        if (!listaPedido.isEmpty()) {
            this.alterarTags(AtividadeTagsActionEnum.EXCLUIR, eu, listaPedido, pt.getPedidoTipo(), pt, forcar, notificar);
        }
    }

    public Pedido getById(Long id) {
        if (id == null) {
            return null;
        }
        Pedido pedido = this.pedidoRepository.findById((Object)id).orElse(null);
        if (pedido == null) {
            throw new ResourceNotFoundException();
        }
        return pedido;
    }

    public Pedido getByHashProposta(String hashProposta) {
        return this.pedidoRepository.findByHashProposta(hashProposta);
    }

    public Pedido getByNumeroAndEstrutura(String numeroPedido, Estrutura estrutura) {
        List pedidos = this.pedidoRepository.findByNumeroAndEstruturaUsuarioEstrutura(numeroPedido, estrutura);
        if (!pedidos.isEmpty()) {
            return (Pedido)pedidos.get(0);
        }
        return null;
    }

    public void verificarRetornoFuturo() {
        List l = this.pedidoRepository.findByDataRetornoFuturoBefore(LocalDate.now().plusDays(1L));
        for (Pedido pedido : l) {
            try {
                PedidoEtapa peInicial = this.pedidoEtapaService.getEtapaInicial(pedido.getEstruturaUsuario().getEstrutura(), pedido.getPedidoTipo());
                EstruturaUsuario master = this.eus.getMasterEstrutura(pedido.getEstruturaUsuario().getEstrutura());
                this.pedidoStatuService.movimentar(pedido, peInicial, master, "Retorno Futuro");
                pedido.setPedidoEtapa(peInicial);
                pedido.setDataRetornoFuturo(null);
                pedido.setDataHoraUltimaMov(LocalDateTime.now());
                pedido.setLeadSistema(LeadTypeEnum.RETORNO_FUTURO);
                this.salvar(pedido);
                this.pedidoMovimentacaoService.insertMovimentacao(pedido.getId(), master, "RETORNO FUTURO ALTERADO PARA AG INTERACAO");
            }
            catch (Exception e) {
                this.logger.error("Erro pedido retorno futuro: " + e.getMessage());
            }
        }
    }

    @Transactional
    public void alterarEtapaPedido(Long pedidoId, PedidoEtapa pedidoEtapa, EstruturaUsuario eu) {
        Pedido pedido = this.getById(pedidoId);
        if (pedido.getPedidoEtapa().getId().equals(pedidoEtapa.getId())) {
            return;
        }
        this.pedidoRepository.updatePedidoEtapa(pedidoEtapa, pedido);
        if (pedidoEtapa.getAtualizaDataReferencia() != null && pedidoEtapa.getAtualizaDataReferencia().booleanValue()) {
            this.pedidoItemService.updateData(pedidoId, LocalDate.now());
        }
        this.pedidoMovimentacaoService.insertMovimentacao(pedidoId, eu, "Movimentado para " + pedidoEtapa.getNome());
        this.alterarEtapaNegociacao(pedido, eu);
        this.pedidoStatuService.movimentar(pedido, pedidoEtapa, eu, "Movimentado para " + pedidoEtapa.getNome());
    }

    @Transactional
    public void alterarEtapaPedido(ProducaoPedidoDTO pedido, PedidoEtapa pedidoEtapa, EstruturaUsuario eu, boolean forcar, boolean notificar) {
        ArrayList<ProducaoPedidoDTO> listaPedidos = new ArrayList<ProducaoPedidoDTO>();
        listaPedidos.add(pedido);
        this.alterarEtapaPedido(listaPedidos, pedidoEtapa, eu, forcar, notificar);
    }

    @Transactional
    @Async(value="asyncDefault")
    public void alterarEtapaPedido(List<ProducaoPedidoDTO> listaPedidos, PedidoEtapa pedidoEtapa, EstruturaUsuario eu, boolean forcar, boolean notificar) {
        Pedido negociacao;
        HashSet<Long> lista = new HashSet<Long>();
        ArrayList<String> listaNegociacao = new ArrayList<String>();
        StringBuilder log = new StringBuilder();
        for (ProducaoPedidoDTO p : listaPedidos) {
            if (!p.getEditavel().booleanValue() && !eu.haveRole("ATIVIDADE_MOVER_NAO_EDITAVEIS")) continue;
            lista.add(p.getId());
            log.append("Atividade ").append(p.getNumeroPedido()).append("\n");
            if (p.getNumeroPedidoOrigem() == null || p.getNumeroPedidoOrigem().isBlank()) continue;
            listaNegociacao.add(p.getNumeroPedidoOrigem());
        }
        if (!listaNegociacao.isEmpty() && (negociacao = this.getByNumeroAndEstrutura((String)listaNegociacao.get(0), eu.getEstrutura())) != null) {
            PedidoEtapa etapaNegociacao = this.pedidoEtapaService.getAndCreate(eu.getEstrutura(), pedidoEtapa.getNome(), negociacao.getPedidoOrigem(), negociacao.getPedidoTipo());
            if (!forcar) {
                this.pedidoRepository.updateListaPedidoEtapaByNumero(etapaNegociacao.getId(), listaNegociacao);
            } else {
                this.pedidoRepository.updateListaPedidoEtapaByNumeroForcar(etapaNegociacao.getId(), listaNegociacao);
            }
        }
        if (lista.size() <= 0) {
            this.notificacoesService.notify(eu, "Movimenta\u00e7\u00e3o massiva", "Todas as atividades est\u00e3o em etapas nao editaveis e voc\u00ea n\u00e3o tem permiss\u00e3o para movimenta-las");
            return;
        }
        this.pedidoStatuService.movimentar(lista, pedidoEtapa, eu, forcar);
        HashSet<Long> listaData = new HashSet<Long>();
        for (ProducaoPedidoDTO ppd : listaPedidos) {
            if (ppd.getAtualizaDataReferencia() == null || !ppd.getAtualizaDataReferencia().booleanValue()) continue;
            listaData.add(ppd.getId());
        }
        if (forcar) {
            this.pedidoRepository.updateListaPedidoEtapaForcar(pedidoEtapa.getId(), lista);
            this.pedidoItemService.updateDataForce(listaData, LocalDate.now());
        } else {
            this.pedidoRepository.updateListaPedidoEtapa(pedidoEtapa.getId(), lista);
            for (ProducaoPedidoDTO producaoPedidoDTO : listaPedidos) {
                if (!producaoPedidoDTO.getAtualizaDataReferencia().booleanValue()) continue;
                lista.add(producaoPedidoDTO.getId());
                log.append(producaoPedidoDTO.getNumeroPedido()).append(", alterado data ");
            }
            this.pedidoItemService.updateData(listaData, LocalDate.now());
        }
        this.pedidoMovimentacaoService.insertMovimentacao(lista, eu, "Movimentado para " + pedidoEtapa.getNome(), notificar, forcar);
        if (lista.size() > 1) {
            this.notificacoesService.notify(eu, "Movimenta\u00e7\u00e3o massiva", "Movimenta\u00e7\u00e3o das etapas finalizada com sucesso: " + log.toString());
        }
        lista = null;
        listaNegociacao = null;
    }

    private void alterarEtapaNegociacao(Pedido pedido, EstruturaUsuario eu) {
        Pedido negociacao;
        if (pedido.getNumeroPedidoOrigem() != null && (negociacao = this.getByNumeroAndEstrutura(pedido.getNumeroPedidoOrigem(), eu.getEstrutura())) != null && negociacao.getTipoNegociacao().equals((Object)pedido.getTipoNegociacao())) {
            try {
                if (!negociacao.getPedidoEtapa().getNome().equals(pedido.getPedidoEtapa().getNome()) && negociacao.getPedidoEtapa().isSincronizavel()) {
                    this.pedidoStatuService.movimentar(negociacao, negociacao.getPedidoEtapa(), eu, "Movimentado para " + negociacao.getPedidoEtapa().getNome());
                    negociacao.setPedidoEtapa(this.pedidoEtapaService.getAndCreate(eu.getEstrutura(), pedido.getPedidoEtapa().getNome(), negociacao.getPedidoOrigem(), negociacao.getPedidoTipo()));
                    this.pedidoMovimentacaoService.insertMovimentacao(negociacao.getId(), eu, "Movimentado para " + negociacao.getPedidoEtapa().getNome());
                    this.salvar(negociacao);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<Pedido> getByPedidoEtapa(PedidoEtapa pedidoEtapa) {
        return this.pedidoRepository.findByPedidoEtapa(pedidoEtapa);
    }

    @Transactional
    public void alterarUsuarioPedido(ProducaoPedidoDTO pedido, HierarquiaDTO usuarioCarteira, EstruturaUsuario euContext, PedidoTipoEncarteiramentoEnum tipo, boolean forcar) {
        ArrayList<ProducaoPedidoDTO> listaPedidos = new ArrayList<ProducaoPedidoDTO>();
        listaPedidos.add(pedido);
        HashSet<HierarquiaDTO> hierarquia = new HashSet<HierarquiaDTO>();
        hierarquia.add(usuarioCarteira);
        this.alterarUsuarioListaPedido(listaPedidos, hierarquia, euContext, tipo, forcar);
    }

    @Transactional
    @Async(value="asyncDefault")
    public void alterarUsuarioListaPedido(List<ProducaoPedidoDTO> listaPedidos, Set<HierarquiaDTO> hierarquia, EstruturaUsuario euContext, PedidoTipoEncarteiramentoEnum tipo, boolean forcar) {
        try {
            ArrayList<HierarquiaDTO> lh = new ArrayList<HierarquiaDTO>(hierarquia);
            HashMap distribuicao = new HashMap();
            int ind = 0;
            HashSet<Long> pedidos = new HashSet<Long>();
            StringBuilder log = new StringBuilder();
            for (ProducaoPedidoDTO p : listaPedidos) {
                pedidos.add(p.getId());
                log.append(p.getNumeroPedido()).append(", ");
                ind = ind >= lh.size() ? 0 : ind;
                HierarquiaDTO h = (HierarquiaDTO)lh.get(ind);
                if (distribuicao.containsKey(h)) {
                    ((Set)distribuicao.get(h)).add(p.getId());
                } else {
                    HashSet<Long> lp = new HashSet<Long>();
                    lp.add(p.getId());
                    distribuicao.put(h, lp);
                }
                ++ind;
            }
            EstruturaComplemento ec = this.complementoService.getComplementos(euContext.getEstrutura());
            for (Map.Entry me : distribuicao.entrySet()) {
                if (tipo.equals((Object)PedidoTipoEncarteiramentoEnum.PROPRIETARIO_PEDIDO)) {
                    if (forcar) {
                        this.pedidoRepository.updateListaPedidoUsuarioForcar(((HierarquiaDTO)me.getKey()).getEstruturaUsuarioId(), (Set)me.getValue());
                    } else {
                        this.pedidoRepository.updateListaPedidoUsuario(((HierarquiaDTO)me.getKey()).getEstruturaUsuarioId(), (Set)me.getValue());
                    }
                } else {
                    this.pedidoRepository.updateListaPedidoUsuarioAdm(((HierarquiaDTO)me.getKey()).getEstruturaUsuarioId(), (Set)me.getValue());
                }
                boolean notificar = false;
                if (ec.getEnviarEmailTrocaProprietario().booleanValue() && listaPedidos.size() == 1) {
                    notificar = true;
                }
                this.pedidoMovimentacaoService.insertMovimentacao((Set)me.getValue(), euContext, "Enviado (" + tipo.name() + "): " + ((HierarquiaDTO)me.getKey()).getUsuarioNome(), notificar);
            }
            this.whatsAppTransfService.sincronizarAtendimentoPedido(pedidos);
            if (listaPedidos.size() > 1) {
                this.notificacoesService.notify(euContext, "Altera\u00e7\u00e3o Usu\u00e1rio Atividade", "Altera\u00e7\u00e3o massiva de usu\u00e1rios finalizada com sucesso: " + log.toString());
            }
        }
        catch (Exception e) {
            this.notificacoesService.notify(euContext, "Altera\u00e7\u00e3o Usu\u00e1rio Atividade", "Erro ao alterar " + e.getMessage());
        }
    }

    @Transactional
    @Async(value="asyncDefault")
    public void alterarData(EstruturaUsuario eu, List<ProducaoPedidoDTO> listaPedido, LocalDate data, boolean forcar) {
        HashSet<Long> lista = new HashSet<Long>();
        StringBuilder log = new StringBuilder();
        for (ProducaoPedidoDTO producaoPedidoDTO : listaPedido) {
            if (!forcar && !producaoPedidoDTO.getAtualizaDataReferencia().booleanValue()) continue;
            lista.add(producaoPedidoDTO.getId());
            log.append(producaoPedidoDTO.getNumeroPedido()).append(", ");
        }
        if (forcar) {
            this.pedidoItemService.updateDataForce(lista, data);
        } else {
            this.pedidoItemService.updateData(lista, data);
        }
        this.pedidoMovimentacaoService.insertMovimentacao(lista, eu, "Data Alterada para: " + data.format(FormatDate.DATE_BR.toDTF()), true, forcar);
        this.notificacoesService.notify(eu, "Altera\u00e7\u00e3o massiva datas", "Altera\u00e7\u00e3o massiva de datas finalizada com sucesso: " + log.toString());
    }

    @Transactional
    @Async(value="asyncDefault")
    public void alterarTags(AtividadeTagsActionEnum action, EstruturaUsuario eu, List<ProducaoPedidoDTO> listaPedido, PedidoTipoEnum pte, PedidoTags tag, boolean forcar, boolean notificar) {
        HashSet<Long> lista = new HashSet<Long>();
        StringBuilder log = new StringBuilder();
        for (ProducaoPedidoDTO producaoPedidoDTO : listaPedido) {
            lista.add(producaoPedidoDTO.getId());
            log.append(producaoPedidoDTO.getNumeroPedido()).append(", ");
        }
        this.pedidoRepository.updateListaPedidoTags(eu.getEstrutura(), action, tag == null ? "" : tag.getTag(), lista);
        this.pedidoMovimentacaoService.insertMovimentacao(lista, eu, (String)(tag != null ? "Tags " + tag.getTag() : "") + " a\u00e7\u00e3o (" + action.name() + ") ", notificar, forcar);
        if (tag != null) {
            this.pedidoTagsService.saveTags(tag.getTag(), pte, eu);
        }
        this.notificacoesService.notify(eu, "Altera\u00e7\u00e3o de tag", "Altera\u00e7\u00e3o massiva de tags finalizada com sucesso: " + log.toString());
    }

    public Pedido createPedidoByMailing(Long euId, Cliente cliente, MailingLimited m, String descricao, String tags, PedidoTipoEnum pte) {
        EstruturaUsuario eu = this.eus.getById(euId);
        return this.createPedidoByMailing(eu, cliente, m, descricao, tags, pte);
    }

    public Pedido createPedidoByMailing(EstruturaUsuario eu, Cliente cliente, MailingLimited m, String descricao, String tags, PedidoTipoEnum pte) {
        Pedido pedido = new Pedido();
        pedido.setCliente(cliente);
        pedido.setComplementos(descricao);
        pedido.setDataCadastro(LocalDate.now());
        pedido.setDataHoraAtualizacao(LocalDateTime.now());
        pedido.setEstruturaUsuario(eu);
        pedido.setPedidoEtapa(this.pedidoEtapaService.getEtapaInicial(eu.getEstrutura(), pte));
        pedido.setPedidoOrigem(this.pedidoOrigemService.getOrigemAtividade(eu.getEstrutura()));
        pedido.setTags(tags);
        pedido.setPedidoTipo(pte);
        pedido.setTotal(BigDecimal.ZERO);
        return this.salvar(pedido);
    }

    public List<Pedido> getByNumeroVinculado(Estrutura estrutura, String numero) {
        return this.pedidoRepository.findByEstruturaUsuarioEstruturaAndNumeroPedidoVinculado(estrutura, numero);
    }

    public Set<PedidoItem> getItens(Pedido pedido) {
        Set itens = this.pedidoItemService.getByPedido(pedido);
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal comp = BigDecimal.ZERO;
        for (PedidoItem item : itens) {
            total = total.add(item.getValorUnitario().subtract(item.getDescontoPorItem()).multiply(BigDecimal.valueOf(item.getQuantidade().longValue())));
            if (!item.getProduto().getCompromissoMensal().booleanValue()) continue;
            comp = comp.add(item.getValorUnitario().subtract(item.getDescontoPorItem()).multiply(BigDecimal.valueOf(item.getQuantidade().longValue())));
        }
        if (!pedido.getTotal().equals(total) || !pedido.getCompromissoMensal().equals(comp)) {
            pedido.setTotal(total);
            pedido.setCompromissoMensal(comp);
            this.pedidoRepository.save((Object)pedido);
        }
        return itens;
    }

    @Transactional
    public Pedido desmembrarPedido(EstruturaUsuario eu, Pedido pedido, HashMap<PedidoItem, PedidoItemDados> itensDesmembramento) {
        Pedido fp = new Pedido();
        BeanUtils.copyProperties((Object)pedido, (Object)fp, (String[])new String[]{"id", "numero", "itens", "movimentacao"});
        HashSet<PedidoItem> lista = new HashSet<PedidoItem>();
        for (Map.Entry<PedidoItem, PedidoItemDados> map : itensDesmembramento.entrySet()) {
            if (map.getKey() == null || map.getValue() == null) continue;
            map.getKey().setPedido(fp);
            map.getKey().setId(null);
            ((PedidoItemDados)map.getValue()).setPedidoItem((PedidoItem)map.getKey());
            lista.add((PedidoItem)map.getKey());
        }
        fp.setItens(lista);
        fp.setDataHoraAtualizacao(LocalDateTime.now());
        fp.setHashProposta(null);
        Pedido salvo = this.salvar(fp);
        for (Map.Entry entry : itensDesmembramento.entrySet()) {
            this.pedidoItemService.saveItemDados((PedidoItemDados)entry.getValue());
        }
        this.pedidoMovimentacaoService.insertMovimentacao(pedido.getId(), eu, "Desmembrado para: " + salvo.getNumero());
        this.pedidoMovimentacaoService.insertMovimentacao(salvo.getId(), eu, "Desmembrado de: " + pedido.getNumero());
        List anexosOriginais = this.pedidoAnexoService.getAnexo(pedido);
        for (PedidoAnexo original : anexosOriginais) {
            try {
                String extensao = FileUtil.getExtension((String)original.getNomeArquivo());
                Object arquivo = original.getHashArquivo().contains(extensao) ? original.getHashArquivo() : original.getHashArquivo() + extensao;
                InputStream file = StorageUtil.getObject((String)arquivo);
                this.pedidoAnexoService.save(salvo, original.getEstruturaUsuario(), file, original.getNomeArquivo());
            }
            catch (Exception e) {
                throw new BusinessException("Erro ao copiar anexos " + e.getMessage());
            }
        }
        return salvo;
    }

    public PedidoOrigem getOrigemAtividade(Estrutura estrutura) {
        return this.pedidoOrigemService.getOrigemAtividade(estrutura);
    }

    public List<PedidoResumeDTO> getForResume(EstruturaUsuario eu, String cpfCnpj) {
        return this.pedidoRepository.findForResume(eu, cpfCnpj);
    }

    public String getInformacoesPedido(Pedido pedido, EstruturaTipoEnum tipo) {
        Pedido p;
        Object complemento = pedido.getComplementos();
        if (pedido.getNotasFiscais() != null && !pedido.getNotasFiscais().isBlank()) {
            complemento = tipo.equals((Object)EstruturaTipoEnum.TIM) ? (String)complemento + "<BR><B>P2B: " + pedido.getNotasFiscais() + "</B>" : (String)complemento + "<BR><B>Notas Fiscais: " + pedido.getNotasFiscais() + "</B>";
        }
        if (pedido.getNumeroPedidoVinculado() != null && !pedido.getNumeroPedidoVinculado().isBlank()) {
            complemento = (String)complemento + "<BR><B>Vinculado \u00e0: " + pedido.getNumeroPedidoVinculado() + "</B>";
        }
        if (pedido.getLoginOperadora() != null && !pedido.getLoginOperadora().isBlank()) {
            complemento = (String)complemento + "<BR><B>Login: " + pedido.getLoginOperadora() + "</B>";
        }
        if (pedido.getPedidoTipo() != null) {
            complemento = (String)complemento + "<BR><B>Tipo: " + pedido.getPedidoTipo().name() + "</B>";
        }
        if (pedido.getClusterOrigem() != null && !pedido.getClusterOrigem().isBlank()) {
            complemento = (String)complemento + "<BR><B>Cluster Origem: " + pedido.getClusterOrigem() + "</B>";
        }
        if (pedido.getPercentualDesconto() != null) {
            complemento = (String)complemento + "<BR><B>% Desconto: " + pedido.getPercentualDesconto() + "</B>";
        }
        if (pedido.getAparelhoCartaoCredito() != null) {
            complemento = (String)complemento + "<BR><B>Aparelho Cart\u00e3o Cr\u00e9dito: " + (pedido.getAparelhoCartaoCredito() != false ? "SIM" : "N\u00c3O") + "</B>";
        }
        if (tipo.equals((Object)EstruturaTipoEnum.VIVO) && pedido.getAtividades() != null && !pedido.getAtividades().isBlank()) {
            complemento = (String)complemento + "<BR><BR><B>Atividades VIVO-CORP</B><BR>" + pedido.getAtividades();
        }
        if (pedido.getNumeroPedidoOrigem() != null && !pedido.getNumeroPedidoOrigem().isBlank() && (p = this.getByNumeroAndEstrutura(pedido.getNumeroPedidoOrigem(), pedido.getEstruturaUsuario().getEstrutura())) != null) {
            complemento = (String)complemento + "<BR><BR><B>Informa\u00e7\u00f5es Atividade Origem: " + p.getNumero() + "</B><BR>";
            if (p.getComplementos() != null) {
                complemento = (String)complemento + p.getComplementos();
            }
            if (tipo.equals((Object)EstruturaTipoEnum.VIVO) && p.getAtividades() != null && !p.getAtividades().isBlank()) {
                complemento = (String)complemento + "<BR><BR>Atividades VIVO-CORP<BR>" + p.getAtividades();
            }
        }
        complemento = ((String)complemento).replace("\n", "<BR>").replace("null", "");
        return complemento;
    }

    public List<Pedido> getByCliente(Cliente cliente) {
        return this.pedidoRepository.findByCliente(cliente);
    }

    public Integer countByTag(Estrutura estrutura, LocalDate dataCadastro, String tag) {
        return this.pedidoRepository.countByEstruturaUsuarioEstruturaAndDataCadastroAndTagsContains(estrutura, dataCadastro, tag);
    }

    public void delete(Pedido pedido) throws Exception {
        this.pedidoDeleteService.delete(pedido);
    }

    public List<Long> getAllComTags() {
        return this.pedidoRepository.findAllComTags();
    }

    public Set<Long> getByEstruturaAndDataHoraAtualizacaoBetween(Estrutura e, LocalDateTime dtIni, LocalDateTime dtFim) {
        return this.pedidoRepository.findByEstruturaUsuarioEstruturaAndDataHoraAtualizacaoBetween(e.getId(), dtIni, dtFim);
    }

    public Pedido getPedidoByNumeroSimulacao(EstruturaUsuario master, String numeroSimulacao) {
        return this.pedidoRepository.findFirstByNumeroSimulacaoAndEstruturaUsuarioEstrutura(numeroSimulacao, master.getEstrutura());
    }

    public Pedido getPedidoByNumeroCotacao(EstruturaUsuario master, String numeroCotacao) {
        return this.pedidoRepository.findFirstByCotacaoAndEstruturaUsuarioEstrutura(numeroCotacao, master.getEstrutura());
    }

    public void movimentarInteracao(Pedido pedido, EstruturaUsuario eu, PedidoEtapa pe, String observacao) {
        this.pedidoMovimentacaoService.insertMovimentacao(pedido.getId(), eu, observacao, false, true);
        this.pedidoStatuService.entrar(pedido, pe, eu, observacao);
        this.pedidoStatuService.sair(pedido, pe, eu);
    }

    public Set<Pedido> getByEstrutura(Long estruturaId) {
        return this.pedidoRepository.findByEstruturaUsuarioEstruturaId(estruturaId);
    }
}

