/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.model.PedidoTagsCategoria;
import br.com.system.app.features.pedido.repository.PedidoTagsCategoriaRepository;
import br.com.system.app.features.pedido.repository.PedidoTagsRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoTagsService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoTagsRepository pedidoTagsRepository;
    @Autowired
    private PedidoTagsCategoriaRepository categoriaRepository;

    public PedidoTagsCategoria getAndCreateCategoriaOutros(Estrutura e) {
        PedidoTagsCategoria tagOutros = this.categoriaRepository.findFirstByEstruturaAndNome(e, "OUTROS");
        if (tagOutros == null) {
            PedidoTagsCategoria outros = new PedidoTagsCategoria();
            outros.setAtivo(Boolean.TRUE);
            outros.setEstrutura(e);
            outros.setNome("Outros");
            return this.save(outros);
        }
        return tagOutros;
    }

    public List<PedidoTagsCategoria> getCategoria(Estrutura e, Pageable pageable) {
        return this.categoriaRepository.findByEstrutura(e, pageable);
    }

    public List<PedidoTagsCategoria> getCategoria(Estrutura e) {
        return this.categoriaRepository.findByEstrutura(e);
    }

    public long countCategoria(Estrutura e) {
        return this.categoriaRepository.countByEstrutura(e);
    }

    public PedidoTagsCategoria save(PedidoTagsCategoria pts) {
        return (PedidoTagsCategoria)this.categoriaRepository.save((Object)pts);
    }

    @Transactional
    public String saveTags(String tags, PedidoTipoEnum pedidoTipo, EstruturaUsuario eu) {
        String normalizedTags = StringUtil.normalizeTags((String)tags);
        for (String tag : normalizedTags.split(",")) {
            if ((tag = tag.trim()).isEmpty() || this.pedidoTagsRepository.findByEstruturaAndPedidoTipoAndTag(eu.getEstrutura(), pedidoTipo, tag) != null) continue;
            PedidoTags pt = new PedidoTags();
            pt.setEstrutura(eu.getEstrutura());
            pt.setTag(tag);
            pt.setPedidoTipo(pedidoTipo);
            pt.setUsuario(eu.getUsuario());
            pt.setPedidoTagsCategoria(this.getAndCreateCategoriaOutros(eu.getEstrutura()));
            this.pedidoTagsRepository.save((Object)pt);
        }
        return normalizedTags;
    }

    public PedidoTags save(PedidoTags pedidoTags) {
        if (pedidoTags.getEstrutura() == null) {
            throw new BusinessException("Estrutura  \u00e9 obrigatorio");
        }
        if (pedidoTags.getUsuario() == null) {
            throw new BusinessException("Usuario criacao  \u00e9 obrigatorio");
        }
        if (pedidoTags.getTag() == null || pedidoTags.getTag().isBlank()) {
            throw new BusinessException("Tag \u00e9 obrigatoria");
        }
        if (pedidoTags.getPedidoTipo() == null) {
            throw new BusinessException("Tipo \u00e9 obrigatorio");
        }
        if (pedidoTags.getPedidoTagsCategoria() == null) {
            pedidoTags.setPedidoTagsCategoria(this.getAndCreateCategoriaOutros(pedidoTags.getEstrutura()));
        }
        return (PedidoTags)this.pedidoTagsRepository.save((Object)pedidoTags);
    }

    public Set<PedidoTags> getHashTags(String tags, EstruturaUsuario eu) {
        HashSet<PedidoTags> hTags = new HashSet<PedidoTags>();
        for (String t : tags.split(",")) {
            hTags.add(new PedidoTags(eu.getEstrutura(), eu.getUsuario(), t));
        }
        return hTags;
    }

    public String getStringtags(Set<PedidoTags> tags) {
        ArrayList<String> l = new ArrayList<String>();
        for (PedidoTags tag : tags) {
            l.add(tag.getTag());
        }
        return StringUtils.join(l, (String)",");
    }

    public PedidoTags getById(Long id) {
        return (PedidoTags)this.pedidoTagsRepository.findById((Object)id).get();
    }

    public List<Long> getAll() {
        return this.pedidoTagsRepository.findAllTags();
    }

    public List<PedidoTags> getAllTags(Estrutura estrutura) {
        return this.pedidoTagsRepository.findByEstrutura(estrutura);
    }

    public List<PedidoTags> getTags(Estrutura estrutura, PedidoTipoEnum pte) {
        return this.pedidoTagsRepository.findByEstruturaAndPedidoTipo(estrutura, pte);
    }

    public Set<PedidoTags> getTags(Estrutura estrutura, PedidoTipoEnum pte, String tags) {
        ArrayList<String> arrTags = new ArrayList<String>();
        for (String s : tags.split(",")) {
            arrTags.add(s);
        }
        return this.getTags(estrutura, pte, arrTags);
    }

    public Set<PedidoTags> getTags(Estrutura estrutura, PedidoTipoEnum pte, List<String> tags) {
        return this.pedidoTagsRepository.findByEstruturaAndPedidoTipoAndTagIn(estrutura, pte, tags);
    }

    @Transactional
    public void delete(PedidoTags pt) {
        this.pedidoTagsRepository.delete((Object)pt);
    }

    public List<PedidoTags> getByEstruturaAndTipo(Estrutura e, PedidoTipoEnum tipo, Set<String> tags, PedidoTagsCategoria categoria, Pageable pageable) {
        if (!tags.isEmpty() && categoria != null) {
            return this.pedidoTagsRepository.findByEstruturaAndPedidoTipoAndTagInAndPedidoTagsCategoria(e, tipo, tags, categoria, pageable);
        }
        if (tags.isEmpty() && categoria == null) {
            return this.pedidoTagsRepository.findByEstruturaAndPedidoTipo(e, tipo, pageable);
        }
        if (tags.isEmpty()) {
            return this.pedidoTagsRepository.findByEstruturaAndPedidoTipoAndPedidoTagsCategoria(e, tipo, categoria, pageable);
        }
        return this.pedidoTagsRepository.findByEstruturaAndPedidoTipoAndTagIn(e, tipo, tags, pageable);
    }

    public long countByEstruturaAndTipo(Estrutura e, PedidoTipoEnum tipo, Set<String> tags, PedidoTagsCategoria categoria) {
        if (!tags.isEmpty() && categoria != null) {
            return this.pedidoTagsRepository.countByEstruturaAndPedidoTipoAndTagInAndPedidoTagsCategoria(e, tipo, tags, categoria);
        }
        if (tags.isEmpty() && categoria == null) {
            return this.pedidoTagsRepository.countByEstruturaAndPedidoTipo(e, tipo);
        }
        if (tags.isEmpty()) {
            return this.pedidoTagsRepository.countByEstruturaAndPedidoTipoAndPedidoTagsCategoria(e, tipo, categoria);
        }
        return this.pedidoTagsRepository.countByEstruturaAndPedidoTipoAndTagIn(e, tipo, tags);
    }
}

