/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.popnovidade.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.popnovidade.model.PopNovidade;
import br.com.system.app.features.popnovidade.model.PopNovidadeVisto;
import br.com.system.app.features.popnovidade.repository.PopNovidadeRepository;
import br.com.system.app.features.popnovidade.repository.PopNovidadeVistoRepository;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PopNovidadeService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PopNovidadeRepository popNovidadeRepository;
    @Autowired
    private PopNovidadeVistoRepository popNovidadeVistoRepository;

    public PopNovidade getPopNovidade(EstruturaUsuario eu) {
        try {
            String estruturaTipo = eu.getEstrutura().getEstruturaTipo().getNome();
            PopNovidade pn = this.popNovidadeRepository.findFirstByListaEstruturaTipoContainsAndListaPerfilContainsAndAtivo(estruturaTipo, eu.getUsuario().getPerfil().name(), Boolean.TRUE);
            if (pn == null) {
                return null;
            }
            PopNovidadeVisto pnv = this.popNovidadeVistoRepository.findByPopNovidadeAndEstruturaUsuario(pn, eu);
            if (pnv != null) {
                return null;
            }
            return pn;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void saveVisto(PopNovidade pn, EstruturaUsuario eu) {
        PopNovidadeVisto pnv = this.popNovidadeVistoRepository.findByPopNovidadeAndEstruturaUsuario(pn, eu);
        if (pnv != null) {
            return;
        }
        pnv = new PopNovidadeVisto();
        pnv.setEstruturaUsuario(eu);
        pnv.setPopNovidade(pn);
        this.popNovidadeVistoRepository.save((Object)pnv);
    }
}

