/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.service;

import br.com.system.app.features.producaopainel.model.ProducaoColunas;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.repository.ProducaoColunasRepository;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ProducaoColunasService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProducaoColunasRepository pcr;

    public ProducaoColunas getById(Long id) {
        return (ProducaoColunas)this.pcr.findById((Object)id).get();
    }

    public List<ProducaoColunas> getColunas(ProducaoPainel pp, String nome, Pageable pageable) {
        if (nome != null && !nome.isEmpty()) {
            return this.pcr.findByProducaoPainelAndNomeContains(pp, nome, pageable);
        }
        return this.pcr.findByProducaoPainel(pp, pageable);
    }

    public long countColunas(ProducaoPainel pp, String nome) {
        if (nome != null && !nome.isEmpty()) {
            return this.pcr.countByProducaoPainelAndNomeContains(pp, nome);
        }
        return this.pcr.countByProducaoPainel(pp);
    }

    public ProducaoColunas save(ProducaoColunas pc) {
        return (ProducaoColunas)this.pcr.save((Object)pc);
    }

    @Transactional
    public void delete(ProducaoColunas pc) {
        pc = (ProducaoColunas)this.pcr.findByIdWithChildren(pc.getId()).get();
        System.out.println("Filhos etapa: " + pc.getProducaoPedidoEtapa().size());
        System.out.println("Filhos item etapa: " + pc.getProducaoPedidoItemEtapa().size());
        this.pcr.delete((Object)pc);
        this.pcr.flush();
    }
}

