/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.service;

import br.com.system.app.features.producaopainel.model.ProducaoLinhas;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.repository.ProducaoLinhasRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProducaoLinhasService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProducaoLinhasRepository producaoLinhasRepository;

    public ProducaoLinhas getById(Long id) {
        return (ProducaoLinhas)this.producaoLinhasRepository.findById((Object)id).get();
    }

    public ProducaoLinhas save(ProducaoLinhas pl) {
        return (ProducaoLinhas)this.producaoLinhasRepository.save((Object)pl);
    }

    @Transactional
    public void delete(ProducaoLinhas pl) {
        this.producaoLinhasRepository.delete((Object)pl);
    }

    public List<ProducaoLinhas> getLinhas(ProducaoPainel pp, String nome, Pageable pageable) {
        if (nome != null && !nome.isEmpty()) {
            return this.producaoLinhasRepository.findByProducaoPainelAndNomeContains(pp, nome, pageable);
        }
        return this.producaoLinhasRepository.findByProducaoPainel(pp, pageable);
    }

    public long countLinhas(ProducaoPainel pp, String nome) {
        if (nome != null && !nome.isEmpty()) {
            return this.producaoLinhasRepository.countByProducaoPainelAndNomeContains(pp, nome);
        }
        return this.producaoLinhasRepository.countByProducaoPainel(pp);
    }
}

