/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views.cadastro;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.repository.PedidoItemEtapaRepository;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.producaopainel.model.ProducaoColunas;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.repository.ProducaoPedidoItemEtapaRepository;
import br.com.system.app.features.producaopainel.service.ProducaoColunasService;
import br.com.system.app.features.producaopainel.service.ProducaoPedidoEtapaService;
import br.com.system.app.features.producaopainel.views.cadastro.ProducaoEtapaView;
import br.com.system.app.features.producaopainel.views.cadastro.ProducaoItemEtapaView;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.CrudOperation;
import org.vaadin.crudui.crud.impl.GridCrud;

public class ProducaoColunaView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProducaoColunasService pcs;
    private final PedidoEtapaService pes;
    private final ProducaoPedidoEtapaService ppes;
    private final ProducaoPedidoItemEtapaRepository ppier;
    private final PedidoItemEtapaRepository pier;
    private final ProducaoPainel painel;
    private GridCrud<ProducaoColunas> crud;
    private ComboBox<PedidoTipoEnum> cbTipo;

    public ProducaoColunaView(ProducaoColunasService pcs, PedidoEtapaService pes, ProducaoPedidoEtapaService ppes, ProducaoPedidoItemEtapaRepository ppier, PedidoItemEtapaRepository pier, ProducaoPainel painel) {
        this.pcs = pcs;
        this.pes = pes;
        this.ppes = ppes;
        this.ppier = ppier;
        this.pier = pier;
        this.painel = painel;
        this.createContent();
    }

    private void createContent() {
        if (this.painel == null) {
            UIUtils.showNotification((String)"Painel esta nulo");
            return;
        }
        this.cbTipo = new ComboBox("Selecione Tipo", (Object[])PedidoTipoEnum.values());
        this.cbTipo.setItemLabelGenerator(Enum::name);
        this.crud = new GridCrud(ProducaoColunas.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        this.crud.getCrudLayout().addToolbarComponent((Component)this.getOptions());
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn("nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn("posicaoColuna").setFlexGrow(0).setWidth("120px");
        this.crud.getGrid().addColumn("considerarData").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn("executados").setFlexGrow(0).setWidth("180px");
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "nomeBi", "posicaoColuna", "considerarData", "executados"});
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.ADD, new String[]{"nome", "nomeBi", "posicaoColuna", "considerarData", "executados"});
        this.crud.getAddButton().setVisible(this.hasPermission("PAINEL_PROUCAO_SAVE"));
        this.crud.getUpdateButton().setVisible(this.hasPermission("PAINEL_PROUCAO_SAVE"));
        this.crud.getDeleteButton().setVisible(this.hasPermission("PAINEL_PRODUCAO_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        Button fechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        fechar.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        this.add(new Component[]{UIUtils.createHeader((String)"Configura\u00e7\u00e3o de Colunas"), new VerticalContainer(new Component[]{this.cbTipo, this.crud, fechar})});
    }

    public HorizontalContainer getOptions() {
        Button btnEtapa = UIUtils.createSmallButton((String)"Etapa");
        btnEtapa.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.isValido()) {
                ProducaoEtapaView producaoEtapaView = new ProducaoEtapaView(this.pes, this.ppes, (ProducaoColunas)this.crud.getGrid().getSelectedItems().iterator().next(), this.getEu(), (PedidoTipoEnum)this.cbTipo.getValue());
                producaoEtapaView.open();
            }
        });
        Button btnEtapaItem = UIUtils.createSmallButton((String)"Etapa Item");
        btnEtapaItem.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.isValido()) {
                ProducaoItemEtapaView producaoItemEtapaView = new ProducaoItemEtapaView(this.getEu(), (ProducaoColunas)this.crud.getGrid().getSelectedItems().iterator().next(), this.ppier, this.pier);
                producaoItemEtapaView.open();
            }
        });
        return new HorizontalContainer(new Component[]{btnEtapa, btnEtapaItem});
    }

    private boolean isValido() {
        if (this.cbTipo.getValue() == null) {
            UIUtils.showNotification((String)"Selecione um tipo");
            return false;
        }
        if (this.crud.getGrid().getSelectedItems().size() <= 0) {
            UIUtils.showNotification((String)"Selecione uma linha");
            return false;
        }
        return true;
    }
}

