/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioSenhas;
import br.com.system.app.features.usuario.repository.UsuarioRepository;
import br.com.system.app.features.usuario.repository.UsuarioSenhasRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UsuarioSenhaService {
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private UsuarioSenhasRepository senhasRepository;

    public Usuario atualizarSenha(Usuario usuario, String newPassword) {
        if (newPassword == null || newPassword.isEmpty()) {
            return null;
        }
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)newPassword));
        usuario.setConfirmado(true);
        usuario = (Usuario)this.usuarioRepository.save((Object)usuario);
        this.gravarSenhasUtilizadas(usuario);
        return usuario;
    }

    public boolean checarSenhasUtilizadas(Usuario usuario, String senha) {
        UsuarioSenhas us = this.senhasRepository.findByUsuario(usuario);
        if (us == null) {
            return true;
        }
        if (senha == null || senha.isEmpty()) {
            return false;
        }
        if (this.passwordEncoder.matches((CharSequence)senha, us.getSenha1())) {
            return false;
        }
        if (this.passwordEncoder.matches((CharSequence)senha, us.getSenha2())) {
            return false;
        }
        if (this.passwordEncoder.matches((CharSequence)senha, us.getSenha3())) {
            return false;
        }
        if (this.passwordEncoder.matches((CharSequence)senha, us.getSenha4())) {
            return false;
        }
        return !this.passwordEncoder.matches((CharSequence)senha, us.getSenha5());
    }

    private void gravarSenhasUtilizadas(Usuario usuario) {
        UsuarioSenhas us = this.senhasRepository.findByUsuario(usuario);
        if (us == null) {
            us = new UsuarioSenhas();
            us.setUsuario(usuario);
        }
        us.setSenha5(us.getSenha4());
        us.setSenha4(us.getSenha3());
        us.setSenha3(us.getSenha2());
        us.setSenha2(us.getSenha1());
        us.setSenha1(usuario.getSenha());
        this.senhasRepository.save((Object)us);
    }
}

