/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioConfirmacaoTipoEnum;
import br.com.system.app.features.usuario.model.UsuarioConfirmacaoTipoEnvioEnum;
import br.com.system.app.features.usuario.service.UsuarioConfirmacaoService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.views.UsuarioConfirmacaoItemView;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.strings.FieldMask;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;

public class UsuarioConfirmacaoItemView
extends VerticalContainer {
    private static final long serialVersionUID = 1L;
    private final UsuarioConfirmacaoService service;
    private final UsuarioService usuarioService;
    private EmailField email;
    private TextField celular;
    private TextField txtConfirmacao;
    private Button btnConf;

    public UsuarioConfirmacaoItemView(UsuarioConfirmacaoService service, UsuarioService usuarioService) {
        super(new Component[0]);
        this.service = service;
        this.usuarioService = usuarioService;
    }

    public Button getBtnConfirmar() {
        return this.btnConf;
    }

    public void change(EstruturaUsuario eu, UsuarioConfirmacaoTipoEnum tipo) {
        Usuario usuario = (Usuario)this.usuarioService.getById(eu.getUsuario().getId()).get();
        if (tipo.equals((Object)UsuarioConfirmacaoTipoEnum.EMAIL)) {
            usuario.setEmail(this.email.getValue());
        } else if (tipo.equals((Object)UsuarioConfirmacaoTipoEnum.EMAIL_ALTERNATIVO)) {
            usuario.setEmailAlternativo(this.email.getValue());
        } else if (tipo.equals((Object)UsuarioConfirmacaoTipoEnum.TELEFONE)) {
            usuario.setCelular(this.celular.getValue());
        } else if (tipo.equals((Object)UsuarioConfirmacaoTipoEnum.TELEFONE_ALTERNATIVO)) {
            usuario.setCelularAlternativo(this.celular.getValue());
        }
        this.usuarioService.salvar(usuario, eu);
    }

    public boolean isValido(EstruturaUsuario eu, UsuarioConfirmacaoTipoEnum tipo) {
        if (this.txtConfirmacao.getValue() == null || this.txtConfirmacao.getValue().length() != 6) {
            return false;
        }
        return this.service.isValid(eu, this.txtConfirmacao.getValue(), tipo);
    }

    public void ocultarConfirmacao() {
        this.btnConf.setVisible(false);
        this.txtConfirmacao.setVisible(false);
    }

    public void mostrarConfirmacao() {
        this.txtConfirmacao.setVisible(true);
        this.btnConf.setVisible(true);
    }

    public VerticalContainer createCard(EstruturaUsuario eu, UsuarioConfirmacaoTipoEnum tipo, boolean changePermition, UsuarioConfirmacaoTipoEnvioEnum tipoEnvio, String thema) {
        Usuario usuario = (Usuario)this.usuarioService.getById(eu.getUsuario().getId()).get();
        this.btnConf = UIUtils.createSmallButton((String)"Confirmar");
        this.txtConfirmacao = new TextField("Codigo Verifica\u00e7\u00e3o");
        this.ocultarConfirmacao();
        this.email = new EmailField("Email " + (tipo.equals((Object)UsuarioConfirmacaoTipoEnum.EMAIL) ? "Principal" : "Alternativo"));
        this.email.setVisible(changePermition);
        this.email.setWidthFull();
        this.celular = new TextField("Celular " + (tipo.equals((Object)UsuarioConfirmacaoTipoEnum.TELEFONE) ? "Principal" : "Alternativo"));
        this.celular.setVisible(changePermition);
        this.celular.setWidthFull();
        this.setSpacingOn();
        this.setPaddingOn();
        this.getThemeList().add((Object)thema);
        switch (1.$SwitchMap$br$com$system$app$features$usuario$model$UsuarioConfirmacaoTipoEnum[tipo.ordinal()]) {
            case 1: {
                this.add(new Component[]{UIUtils.createHeader((String)"Email Principal")});
                this.add(new Component[]{this.email});
                if (usuario.getEmail() == null) break;
                this.email.setValue(usuario.getEmail());
                break;
            }
            case 2: {
                this.add(new Component[]{UIUtils.createHeader((String)"Email Alternativo")});
                this.add(new Component[]{this.email});
                if (usuario.getEmailAlternativo() == null) break;
                this.email.setValue(usuario.getEmailAlternativo());
                break;
            }
            case 3: {
                this.add(new Component[]{UIUtils.createHeader((String)"Celular Principal")});
                this.add(new Component[]{this.celular});
                if (usuario.getCelular() == null) break;
                this.celular.setValue(usuario.getCelular());
                break;
            }
            case 4: {
                this.add(new Component[]{UIUtils.createHeader((String)"Celular Alternativo")});
                this.add(new Component[]{this.celular});
                if (usuario.getCelularAlternativo() == null) break;
                this.celular.setValue(usuario.getCelularAlternativo());
                break;
            }
            default: {
                return null;
            }
        }
        this.add(new Component[]{new HorizontalContainer(new Component[]{this.txtConfirmacao, this.btnConf}).setSpacingOn()});
        Button btnAuth = UIUtils.createSmallButton((String)"Autenticar");
        btnAuth.setVisible(changePermition);
        btnAuth.addClickListener((ComponentEventListener & Serializable)b -> this.autenticar(eu, tipo, tipoEnvio));
        this.add(new Component[]{new FooterContainer(new Component[]{btnAuth})});
        return this;
    }

    public void autenticar(EstruturaUsuario eu, UsuarioConfirmacaoTipoEnum tipo, UsuarioConfirmacaoTipoEnvioEnum tipoEnvio) {
        boolean isEmail;
        boolean bl = isEmail = tipo.equals((Object)UsuarioConfirmacaoTipoEnum.EMAIL) || tipo.equals((Object)UsuarioConfirmacaoTipoEnum.EMAIL_ALTERNATIVO);
        if (isEmail && !ValidationUtil.isValidEmail((String)this.email.getValue())) {
            UIUtils.showNotification((String)"Email inv\u00e1lido");
            return;
        }
        if (!isEmail && !TelefoneUtil.isCelular((String)this.celular.getValue())) {
            UIUtils.showNotification((String)"Telefone inv\u00e1lido");
            return;
        }
        if (isEmail) {
            UIUtils.showNotification((String)("Codigo enviado para " + FieldMask.emailMask((String)this.email.getValue()) + " verifique sua caixa de entrada, informe o c\u00f3digo e clique em confirmar."));
            this.service.sendByEmail(eu, this.email.getValue(), tipo, Integer.valueOf(30));
        } else {
            UIUtils.showNotification((String)("Codigo enviado via " + tipoEnvio.name() + " para " + FieldMask.telMask((String)this.celular.getValue()) + ". Informe o c\u00f3digo e clique em confirmar."));
            this.service.sendByPhone(eu, this.celular.getValue(), tipo, tipoEnvio, Integer.valueOf(30));
        }
        this.mostrarConfirmacao();
    }
}

