/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.util;

import br.com.system.app.MainLayout;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.features.util.service.ExcelAgrupadorService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.XLSUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@Route(value="excel-agrupador", layout=MainLayout.class)
@PageTitle(value="Agrupamento Excel")
@RolesAllowed(value={"MASTER"})
public class ExcelAgrupadorView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ExcelAgrupadorService service;
    private DownloadDialog dd;
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;

    public ExcelAgrupadorView(ExcelAgrupadorService service) {
        this.service = service;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        VerticalLayout lay = new VerticalLayout();
        XLSUtil xlsUtil = new XLSUtil();
        ComboBox cbAgrupador = new ComboBox("Agrupar por?", (Collection)xlsUtil.getColuns());
        MultiComboBox cbColsAgrupar = new MultiComboBox("Agrupar quais colunas?", (Collection)xlsUtil.getColuns());
        MultiComboBox cbColsConcatenar = new MultiComboBox("Concatenar quais colunas?", (Collection)xlsUtil.getColuns());
        TextField separador = new TextField("Separador");
        separador.setValue("<BR>");
        Button btn = UIUtils.createSmallButton((String)"Agrupar");
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                this.showNotification("Selecione um arquivo");
                return;
            }
            ArrayList l = new ArrayList();
            cbColsConcatenar.getValue().forEach(v -> l.add(v));
            String url = this.service.processar(this.mBuffer.getInputStream(), (String)cbAgrupador.getValue(), cbColsAgrupar.getValue(), l, separador.getValue());
            this.dd.open(url, "Exportacao-agrupamento.xlsx", true);
            this.mBuffer.clear();
            this.nomeArquivo = "";
        });
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{".xlsx"});
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        lay.add(new Component[]{upload, cbAgrupador, cbColsAgrupar, cbColsConcatenar, separador, new FooterContainer(new Component[]{btn})});
        return lay;
    }
}

