/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.EmojiView;
import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.broadcast.service.BroadcasterWhats;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.view.form.ClienteFormView;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.BorderStyle;
import br.com.system.app.features.naoperturbe.service.NaoPerturbeService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.service.PedidoLogService;
import br.com.system.app.features.pedido.service.PedidoMovimentacaoService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.view.PedidoMovimentacaoView;
import br.com.system.app.features.shared.service.TranscricaoAudioService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.trescx.service.TrescxChamadaService;
import br.com.system.app.features.whatsapp.WhatsAppAtendimentoDialog;
import br.com.system.app.features.whatsapp.WhatsAppFileDialog;
import br.com.system.app.features.whatsapp.WhatsAppRespostaDialog;
import br.com.system.app.features.whatsapp.WhatsAppTransfDialog;
import br.com.system.app.features.whatsapp.WhatsMsgView;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppBloqueioService;
import br.com.system.app.features.whatsapp.service.WhatsAppCheckMessage;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppRespostaService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import com.vdurmont.emoji.EmojiParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.vaadin.lineawesome.LineAwesomeIcon;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
@JavaScript.Container(value={@JavaScript(value="./src/audio.js"), @JavaScript(value="./src/whatsappview.js"), @JavaScript(value="https://cdn.jsdelivr.net/npm/opus-media-recorder@latest/OpusMediaRecorder.umd.js"), @JavaScript(value="https://cdn.jsdelivr.net/npm/opus-media-recorder@latest/encoderWorker.umd.js")})
public class WhatsAppConversaView
extends VerticalContainer
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private NaoPerturbeService naoPerturbeService;
    @Autowired
    private TrescxChamadaService trescxChamadaService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;
    @Autowired
    private WhatsAppSendService send;
    @Autowired
    private WhatsAppCheckMessage whatsAppCheckMessage;
    @Autowired
    private WhatsAppTransfDialog whatsAppTransfDialog;
    @Autowired
    private ClienteFormView clienteFormView;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private PedidoMovimentacaoService pedidoMovimentacaoService;
    @Autowired
    private PedidoLogService pedidoLogService;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppAtendimentoDialog whatsAppConversasView;
    @Autowired
    private WhatsAppBloqueioService whatsAppBloqueioService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private WhatsAppRespostaService whatsAppRespostaService;
    @Autowired
    private TranscricaoAudioService transcricaoAudioService;
    private WhatsAppAtendimento wa;
    private TextArea txtMensagem;
    private Button btnSend;
    private final Button btnEmoji = UIUtils.createIconButton((LineAwesomeIcon)LineAwesomeIcon.SMILE, (String)"Emojis");
    private Button btnFile;
    private Button btnLoad;
    private Button btn3cx;
    private Registration respListener;
    private Registration fileListener;
    private Boolean needRefresh;
    private boolean gravando;
    private Icon redMic;
    private Icon normalMic;
    private VerticalContainer messageContainer;
    private boolean isBloqueado;
    private WhatsAppRespostaDialog whatsAppRespostaDialog;
    private final String messageContainerId = "messageContainer" + HashUtil.getUUI();
    private final EmojiView emojiView = new EmojiView();
    private final Button btnExit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar tela do atendimento");
    private List<KanbanPedidos> filas;
    private Consumer<Map<WhatsAppAtendimento, PedidoEtapa>> listener;
    private Registration broadcasterRegistration;

    public WhatsAppConversaView() {
        super(new com.vaadin.flow.component.Component[0]);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.whatsAppCheckMessage.setDetachWa(Boolean.valueOf(false));
        this.broadcasterRegistration = BroadcasterWhats.register(atendimento -> {
            if (atendimento.getId().equals(this.wa.getId())) {
                this.getUI().ifPresent(ui -> ui.access(() -> this.povoa()));
            }
        });
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.clear();
        super.onDetach(detachEvent);
        this.whatsAppCheckMessage.setDetachWa(Boolean.valueOf(true));
    }

    private void clear() {
        if (this.respListener != null) {
            this.respListener.remove();
        }
        if (this.fileListener != null) {
            this.fileListener.remove();
        }
        if (this.broadcasterRegistration != null) {
            this.broadcasterRegistration.remove();
            this.broadcasterRegistration = null;
        }
    }

    public Button getBtnExit() {
        return this.btnExit;
    }

    public Boolean getNeedRefresh() {
        return this.needRefresh;
    }

    public VerticalContainer create(WhatsAppAtendimento wa) {
        return this.create(wa, null, null);
    }

    public VerticalContainer create(WhatsAppAtendimento wa, List<KanbanPedidos> filas, Consumer<Map<WhatsAppAtendimento, PedidoEtapa>> listener) {
        this.setHeightFull();
        this.listener = listener;
        this.filas = filas;
        this.clear();
        this.removeAll();
        this.isBloqueado = this.whatsAppBloqueioService.isBloqueado(this.getEstrutura(), wa.getWhatsapp().getNumero());
        this.messageContainer = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.messageContainer.setPadding(true);
        this.messageContainer.setSpacing(true);
        this.messageContainer.setId(this.messageContainerId);
        this.messageContainer.getStyle().set("overflow-y", "auto");
        this.messageContainer.setWidthFull();
        this.messageContainer.setHeightFull();
        this.messageContainer.getStyle().set("background-image", "url('images/fundo-whats-light-1920.png')");
        this.redMic = VaadinIcon.MICROPHONE.create();
        this.redMic.setColor(Color.RED.getValue());
        this.normalMic = VaadinIcon.MICROPHONE.create();
        this.gravando = false;
        this.needRefresh = false;
        this.wa = wa;
        this.btnLoad = UIUtils.createButton((String)"Carregando", (VaadinIcon)VaadinIcon.CLOCK);
        this.btnLoad.setVisible(false);
        this.txtMensagem = new TextArea();
        this.txtMensagem.setReadOnly(wa.isFechado() || this.isBloqueado);
        this.txtMensagem.setHeight("80px");
        this.txtMensagem.setWidth("100%");
        this.txtMensagem.setId("txtMensagem");
        UIUtils.setBorder((BorderStyle)BorderStyle.DOTTED, (String)"1px", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.txtMensagem});
        UI.getCurrent().getPage().executeJs("init($0,$1)", new Serializable[]{this, this.txtMensagem});
        try {
            this.whatsAppControleService.deleteByAtendimento(wa);
        }
        catch (Exception e2) {
            UIUtils.showNotification((String)("Erro, favor enviar ao suporte: " + e2.getMessage()));
        }
        Button btnTransf = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.USER, (String)"Transferir Atendimento");
        btnTransf.setEnabled(!wa.isFechado());
        btnTransf.addClickListener((ComponentEventListener & Serializable)e -> {
            this.whatsAppTransfDialog.create(wa);
            this.needRefresh = true;
        });
        Button btnCli = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.USERS, (String)"Abrir cadastro do cliente");
        btnCli.setVisible(wa.getCnpj() != null);
        btnCli.addClickListener((ComponentEventListener & Serializable)e -> this.clienteFormView.create(this.clienteService.buscarPeloCnpj(wa.getCnpj(), this.getEstrutura())));
        Button btnRecords = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.RECORDS, (String)"Movimenta\u00e7\u00f5es da atividade");
        btnRecords.addClickListener((ComponentEventListener & Serializable)e -> new PedidoMovimentacaoView(wa.getPedido(), this.pedidoMovimentacaoService, this.pedidoLogService, this.pedidoService));
        Button btnRefresh = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REFRESH, (String)"Recarregar mensagens");
        btnRefresh.setEnabled(!wa.isFechado());
        btnRefresh.addClickListener((ComponentEventListener & Serializable)e -> this.povoa());
        Image anchorTel = new Image("images/phone16.png", "3CX");
        this.btn3cx = UIUtils.createSmallButton((String)"", (String)"Ligar via 3CX");
        this.btn3cx.setIcon((com.vaadin.flow.component.Component)anchorTel);
        this.btn3cx.setEnabled(this.getUsuario().getRamal() != null);
        this.btn3cx.addClickListener((ComponentEventListener & Serializable)e -> {
            String numero = TelefoneUtil.normalize((String)wa.getWhatsapp().getNumero());
            if (this.naoPerturbeService.isNaoPerturbe(numero)) {
                InformationDialog.show((String)"N\u00e3o Perturbe", (String)"Este n\u00famero est\u00e1 na base de N\u00c3O PERTURBE, imposs\u00edvel continuar com a liga\u00e7\u00e3o.");
                return;
            }
            if (this.getUsuario().getRamal() == null) {
                UIUtils.showNotification((String)"Ramal 3CX n\u00e3o definido no cadastro do Usu\u00e1rio");
                return;
            }
            UI.getCurrent().getPage().executeJs("window.open('https://neocrm.my3cx.com.br/webclient/#/people?phone=" + numero + "','3cxWindow','width=500,height=500')", new Serializable[0]);
            this.trescxChamadaService.gravarChamada3cx(this.getEu(), numero, wa.getPedido().getCliente().getCpfCnpj(), wa.getPedido().getId());
        });
        this.whatsAppRespostaDialog = new WhatsAppRespostaDialog(this.whatsAppRespostaService);
        this.respListener = this.whatsAppRespostaDialog.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
            String msg;
            if (!close.isOpened() && (msg = this.whatsAppRespostaDialog.getMensagem()) != null) {
                msg = EmojiParser.parseToUnicode((String)msg);
                this.txtMensagem.setValue(msg);
            }
        });
        Button btnGoBottom = UIUtils.createSmallButton((LineAwesomeIcon)LineAwesomeIcon.ARROW_CIRCLE_DOWN_SOLID, (String)"Ir ao final da conversa");
        btnGoBottom.addClickListener((ComponentEventListener & Serializable)e -> this.goBootom());
        Button bMove = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_FORWARD, (String)"Mover a atividade");
        bMove.setVisible(filas != null && !filas.isEmpty());
        bMove.setEnabled(this.hasPermission("KANBAN_ETAPA_CHANGE"));
        bMove.addClickListener((ComponentEventListener & Serializable)e -> this.moveEtapa(wa.getPedido()));
        ComboBox cbOpcoes = new ComboBox();
        cbOpcoes.setPlaceholder("Outras opcoes");
        cbOpcoes.addClassName("whats_view");
        cbOpcoes.setItems((Object[])new String[]{"Fechar Atendimento", "Marcar como Nao Lida", "Criar Atividade", "Criar Anotacao", "Alterar Cnpj", "Bloquear Numero", "Conversas Anteriores"});
        cbOpcoes.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.doOptions((String)e.getValue());
            cbOpcoes.setValue((Object)"");
        });
        HorizontalContainer containerButtons = new HorizontalContainer(new com.vaadin.flow.component.Component[]{btnRefresh, btnCli, btnTransf, btnRecords, this.btn3cx, bMove, btnGoBottom, cbOpcoes, this.btnExit});
        this.add(new com.vaadin.flow.component.Component[]{containerButtons});
        String titulo = wa.getWhatsapp().getNumero() + " " + (wa.getWhatsapp().getNome() == null ? "" : wa.getWhatsapp().getNome());
        titulo = titulo + " " + wa.getEtapa().name();
        H5 header = UIUtils.createHeader((String)titulo);
        this.add(new com.vaadin.flow.component.Component[]{header});
        this.add(new com.vaadin.flow.component.Component[]{this.messageContainer});
        if (!wa.isFechado()) {
            this.add(new com.vaadin.flow.component.Component[]{this.getRodape()});
        }
        this.povoa();
        UIUtils.setColor((Color)Color.WHITE, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.messageContainer});
        return this;
    }

    private void povoa() {
        this.messageContainer.removeAll();
        for (WhatsAppMensagem m : this.whatsAppMensagemService.getByAtendimentoNoOrder(this.wa)) {
            try {
                this.messageContainer.add(new com.vaadin.flow.component.Component[]{new WhatsMsgView(m, this.transcricaoAudioService)});
            }
            catch (Exception e) {
                this.messageContainer.add(new com.vaadin.flow.component.Component[]{new Span("Uma mensagem nao pode ser carregada")});
            }
        }
        this.goBootom();
    }

    private void goBootom() {
        UIUtils.scrollToBottom((String)this.messageContainerId);
    }

    private FooterContainer getRodape() {
        FooterContainer footer = new FooterContainer(new com.vaadin.flow.component.Component[0]);
        UIUtils.setBackgroundColor((Color)Color.WHITE, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{footer});
        footer.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        footer.setNoWrap();
        if (this.isBloqueado) {
            footer.add(new com.vaadin.flow.component.Component[]{new Span("N\u00famero destino Bloqueado")});
            return footer;
        }
        Button btnResp = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.FONT, (String)"Respostas Prontas");
        btnResp.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.wa == null) {
                return;
            }
            this.whatsAppRespostaDialog.show();
        });
        Icon cancel = VaadinIcon.TRASH.create();
        cancel.setColor(Color.RED.getValue());
        Button btnAudioCancel = UIUtils.createSmallButton((Icon)cancel, (String)"Cancelar audio");
        btnAudioCancel.setVisible(false);
        Button btnAudio = UIUtils.createSmallButton((Icon)this.normalMic, (String)"Gravar audio");
        btnAudio.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.gravando) {
                btnAudio.setIcon((com.vaadin.flow.component.Component)this.normalMic);
                UIUtils.setTooltip((String)"Gravar audio", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{btnAudio});
                UI.getCurrent().getPage().executeJs("stopRecord()", new Serializable[0]);
                btnAudioCancel.setVisible(false);
                this.txtMensagem.setEnabled(true);
                this.btnSend.setEnabled(true);
            } else {
                btnAudio.setIcon((com.vaadin.flow.component.Component)this.redMic);
                UIUtils.setTooltip((String)"Enviar grava\u00e7\u00e3o", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{btnAudio});
                UI.getCurrent().getPage().executeJs("startRecord($0)", new Serializable[]{this});
                btnAudioCancel.setVisible(true);
                this.txtMensagem.setEnabled(false);
                this.btnSend.setEnabled(false);
            }
            this.gravando = !this.gravando;
        });
        btnAudioCancel.addClickListener((ComponentEventListener & Serializable)e -> {
            this.gravando = false;
            btnAudio.setIcon((com.vaadin.flow.component.Component)this.normalMic);
            UIUtils.setTooltip((String)"Gravar audio", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{btnAudio});
            btnAudioCancel.setVisible(false);
            this.txtMensagem.setEnabled(true);
            this.btnSend.setEnabled(true);
            UI.getCurrent().getPage().executeJs("cancelRecord()", new Serializable[0]);
        });
        this.emojiView.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.txtMensagem.focus();
            }
        });
        this.emojiView.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.txtMensagem.focus();
            }
        });
        this.btnEmoji.addClickListener((ComponentEventListener & Serializable)e -> this.emojiView.show(arg_0 -> this.listenerEmoji(arg_0)));
        WhatsAppFileDialog whatsAppFileDialog = new WhatsAppFileDialog();
        this.btnFile = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PAPERCLIP, (String)"Enviar arquivos");
        this.btnFile.addClickListener((ComponentEventListener & Serializable)e -> {
            this.btnLoad.setVisible(true);
            whatsAppFileDialog.show();
        });
        this.fileListener = whatsAppFileDialog.addOpenedChangeListener((ComponentEventListener & Serializable)cl -> {
            if (!cl.isOpened()) {
                this.btnLoad.setVisible(false);
                if (whatsAppFileDialog.getFile() != null && whatsAppFileDialog.getFileName() != null) {
                    this.send.sendMessageFile(this.wa, this.getEu(), whatsAppFileDialog.getFile(), whatsAppFileDialog.getFileName(), arg_0 -> this.listenerMessageSender(arg_0));
                }
                whatsAppFileDialog.clear();
            }
        });
        this.btnSend = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_CIRCLE_RIGHT, (String)"Enviar Mensagem");
        this.btnSend.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.wa == null || this.txtMensagem.getValue() == null || this.txtMensagem.getValue().isEmpty()) {
                return;
            }
            this.btnLoad.setVisible(true);
            this.send.sendMessageText(this.wa, this.getEu(), this.txtMensagem.getValue(), arg_0 -> this.listenerMessageSender(arg_0));
            this.txtMensagem.setValue("");
        });
        footer.add(new com.vaadin.flow.component.Component[]{this.btnEmoji, this.btnFile, btnResp, this.txtMensagem, this.btnSend, btnAudioCancel, btnAudio});
        return footer;
    }

    public void listenerEmoji(Button emoji) {
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            if (emoji == null) {
                UIUtils.showWarning((String)"Selecione um Emoji");
                return;
            }
            this.txtMensagem.setValue(this.txtMensagem.getValue() + emoji.getText());
            this.txtMensagem.focus();
        });
    }

    @ClientCallable
    public void dropFile(String base64, String filename) {
        ConfirmationDialog cd = new ConfirmationDialog("Enviar arquivo", "Confirma o envio do arquivo " + filename + "?");
        cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
        cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
            byte[] bytes = Base64.decodeBase64((String)base64.split(",")[1]);
            this.send.sendMessageFile(this.wa, this.getEu(), bytes, filename, arg_0 -> this.listenerMessageSender(arg_0));
            cd.close();
        });
    }

    @ClientCallable
    public void pastFile(String base64) {
        try {
            if (!base64.contains(",") || !base64.contains("data:image")) {
                return;
            }
            Dialog d = new Dialog();
            Button btnS = UIUtils.createSmallButton((String)"Enviar");
            btnS.addClickListener((ComponentEventListener & Serializable)e -> {
                byte[] bytes = Base64.decodeBase64((String)base64.split(",")[1]);
                this.send.sendMessageFile(this.wa, this.getEu(), bytes, "image.png", arg_0 -> this.listenerMessageSender(arg_0));
                d.close();
            });
            Button btnC = UIUtils.createSmallButton((String)"Cancelar");
            btnC.addClickListener((ComponentEventListener & Serializable)e -> d.close());
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<img src='" + base64 + "'>");
            div.setWidthFull();
            div.setHeightFull();
            UIUtils.setBorder((BorderStyle)BorderStyle.DASHED, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{div});
            VerticalLayout lay = new VerticalLayout();
            lay.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Visualiza\u00e7\u00e3o da imagem")});
            lay.add(new com.vaadin.flow.component.Component[]{div});
            lay.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnC, btnS})});
            d.add(new com.vaadin.flow.component.Component[]{lay});
            d.open();
        }
        catch (Exception e2) {
            UIUtils.showNotification((String)e2.getMessage());
        }
    }

    @ClientCallable
    public void errorReturn(String erro) {
        if (erro.contains("Permission denied")) {
            UIUtils.showNotification((String)"Voc\u00ea precisa autorizar o uso do microfone.");
        } else {
            UIUtils.showNotification((String)erro);
        }
    }

    @ClientCallable
    public void audioReturn(String audiobase64) {
        try {
            if (audiobase64.contains(",")) {
                audiobase64 = audiobase64.split(",")[1];
            }
            byte[] bytes = Base64.decodeBase64((String)audiobase64);
            String url = StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".mp3"), (String)"audio/ogg", (byte[])bytes);
            this.send.sendMessageAudio(this.wa, this.getEu(), url, arg_0 -> this.listenerMessageSender(arg_0));
        }
        catch (Exception e) {
            UIUtils.showError((String)("Erro no retorno do audio " + e.getMessage()));
        }
    }

    private void listenerMessageSender(WhatsAppMensagem m) {
        if (!this.getUI().isPresent()) {
            return;
        }
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.btnLoad.setVisible(false);
            if (this.wa != null) {
                BroadcasterWhats.broadcast((WhatsAppAtendimento)this.wa);
            }
        });
    }

    private void criarNovaAtividade() {
        Dialog d = new Dialog();
        VerticalContainer v = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        RadioButtonGroup rbTipo = new RadioButtonGroup();
        rbTipo.setValue((Object)PedidoTipoEnum.COMERCIAL);
        rbTipo.setItems((Object[])PedidoTipoEnum.values());
        rbTipo.setItemLabelGenerator(Enum::name);
        TextArea ta = new TextArea("Informa\u00e7\u00f5es");
        TextField txtCnpj = new TextField("CPF-CNPJ");
        if (this.wa.getCnpj() != null && !this.wa.getCnpj().isEmpty()) {
            txtCnpj.setValue(this.wa.getCnpj());
        }
        Button bFechar = UIUtils.createSmallButton((String)"Fechar");
        bFechar.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        Button bCriar = UIUtils.createSmallButton((String)"Criar Atividade");
        bCriar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!ValidationUtil.isValidCnpjAndCpf((String)txtCnpj.getValue())) {
                UIUtils.showNotification((String)"CPF-CNPJ inv\u00e1lido");
                return;
            }
            Pedido p = new Pedido();
            p.setEstruturaUsuario(this.getEu());
            p.setCliente(this.clienteService.getAndCreateCliente(this.getEu(), txtCnpj.getValue(), new ClienteContato[0]));
            p.setComplementos(ta.getValue());
            p.setPedidoTipo((PedidoTipoEnum)rbTipo.getValue());
            p.setNumeroPedidoOrigem(this.wa.getPedido().getNumero());
            p = this.pedidoService.salvar(p);
            UIUtils.showSucess((String)("Nova Atividade criada sob o n\u00famero #" + p.getNumero()));
            d.close();
        });
        v.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Criar nova Atividade")});
        v.add(new com.vaadin.flow.component.Component[]{rbTipo, txtCnpj, ta});
        v.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{bFechar, bCriar})});
        d.add(new com.vaadin.flow.component.Component[]{v});
        d.open();
    }

    private void doOptions(String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (value.equals("Fechar Atendimento")) {
            ConfirmationDialog cd = new ConfirmationDialog("Fechar Atendimento", "Tem certeza que deseja Encerrar este atendimento?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.needRefresh = true;
                cd.close();
                this.whatsAppAtendimentoService.fechar(this.wa, this.getEu(), true);
            });
        } else if (value.equals("Alterar Cnpj")) {
            Dialog d = new Dialog();
            TextField t = new TextField("CNPJ");
            Button b = UIUtils.createSmallButton((String)"Alterar");
            b.addClickListener((ComponentEventListener & Serializable)xx -> {
                if (!ValidationUtil.isValidCnpjAndCpf((String)t.getValue())) {
                    UIUtils.showNotification((String)"CNPJ inv\u00e1lido");
                    return;
                }
                this.wa.setCnpj(StringUtil.numbersOnly((String)t.getValue()));
                this.whatsAppAtendimentoService.save(this.wa);
                WhatsApp w = this.wa.getWhatsapp();
                if (w.getCpfCnpj() == null) {
                    w.setCpfCnpj(this.wa.getCnpj());
                } else if (!this.wa.getWhatsapp().getCpfCnpj().contains(this.wa.getCnpj())) {
                    w.setCpfCnpj(w.getCnpjEscolhido() + "," + this.wa.getCnpj());
                }
                this.whatsAppService.save(w);
                this.needRefresh = true;
                UIUtils.showNotification((String)"Altera\u00e7\u00e3o efetuada com sucesso");
                d.close();
            });
            d.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Alterar CNPJ")});
            d.add(new com.vaadin.flow.component.Component[]{t});
            d.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{b})});
            d.open();
        } else if (value.equals("Marcar como Nao Lida")) {
            WhatsAppMensagem notRead = this.whatsAppMensagemService.inserirAnotacao(this.wa, this.getEu(), "Marcado como n\u00e3o lido");
            this.whatsAppControleService.gravarNova(notRead, WhatsAppStatusEnum.ENVIADA);
            this.needRefresh = true;
        } else if (value.equals("Criar Atividade")) {
            this.criarNovaAtividade();
        } else if (value.equals("Criar Anotacao")) {
            Dialog d = new Dialog();
            d.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Inserir Anota\u00e7\u00f5es")});
            TextArea ta = new TextArea("Anota\u00e7\u00e3o");
            ta.setWidth("200px");
            ta.setHeight("300px");
            Button bf = UIUtils.createSmallButton((String)"Fechar");
            bf.addClickListener((ComponentEventListener & Serializable)xx -> d.close());
            Button bg = UIUtils.createSmallButton((String)"Gravar");
            bg.addClickListener((ComponentEventListener & Serializable)xx -> {
                if (ta.getValue() == null || ta.getValue().isEmpty()) {
                    UIUtils.showNotification((String)"Insira uma nota\u00e7\u00e3o para gravar");
                    return;
                }
                WhatsAppMensagem m = this.whatsAppMensagemService.inserirAnotacao(this.wa, this.getEu(), ta.getValue());
                this.whatsAppControleService.gravarNova(m, WhatsAppStatusEnum.LIDA);
                d.close();
            });
            d.add(new com.vaadin.flow.component.Component[]{ta, new FooterContainer(new com.vaadin.flow.component.Component[]{bf, bg})});
            d.open();
        } else if (value.equals("Bloquear Numero")) {
            ConfirmationDialog cd = new ConfirmationDialog("Bloqueio de N\u00fameros", "Confirma bloqueio deste n\u00famero?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                this.whatsAppBloqueioService.bloquear(this.getEu(), this.wa.getWhatsapp().getNumero());
                UIUtils.showNotification((String)"N\u00famero bloqueado com sucesso");
                this.create(this.wa);
            });
        } else if (value.equals("Conversas Anteriores")) {
            this.whatsAppConversasView.show(this.wa.getWhatsapp(), this.wa.getCnpj());
        } else {
            UIUtils.showNotification((String)("Nao localizei essa opcao " + value));
        }
    }

    private void moveEtapa(Pedido pedido) {
        ComboBox cbMove = new ComboBox("Fila");
        cbMove.setWidth("300px");
        cbMove.setItemLabelGenerator(PedidoEtapa::getNome);
        ArrayList<PedidoEtapa> etapas = new ArrayList<PedidoEtapa>();
        for (KanbanPedidos kp : this.filas) {
            if (kp.getPedidoEtapa().getId().equals(pedido.getPedidoEtapa().getId())) continue;
            etapas.add(kp.getPedidoEtapa());
        }
        cbMove.setItems(etapas);
        Dialog d = new Dialog();
        Button btnConfirmar = UIUtils.createSmallButton((String)"Confirmar");
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        btnConfirmar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbMove.getValue() == null) {
                UIUtils.showNotification((String)"Selecione uma etapa para movimentar");
                return;
            }
            this.pedidoService.alterarEtapaPedido(pedido.getId(), (PedidoEtapa)cbMove.getValue(), this.getEu());
            UIUtils.showNotification((String)"Conversa movida com sucesso");
            if (this.listener != null) {
                HashMap<WhatsAppAtendimento, PedidoEtapa> map = new HashMap<WhatsAppAtendimento, PedidoEtapa>();
                map.put(this.wa, (PedidoEtapa)cbMove.getValue());
                this.listener.accept(map);
            }
            d.close();
        });
        d.add(new com.vaadin.flow.component.Component[]{new VerticalContainer(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Mover Conversa"), cbMove, new FooterContainer(new com.vaadin.flow.component.Component[]{btnFechar, btnConfirmar})})});
        d.open();
    }
}

