/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.whatsapp.model.WhatsAppTemplate;
import br.com.system.app.features.whatsapp.model.WhatsAppTemplateCampos;
import br.com.system.app.features.whatsapp.service.WhatsAppTemplateService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WhatsAppTemplateFormView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private TextField name;
    private TextArea texto;
    private Button bClose;
    private Button bSave;
    private Button bInsert;
    private Button bDelete;
    private FooterContainer footer;
    private VerticalLayout mainLayout;
    private HorizontalContainer form;
    private TextField campo;
    private NumberField posicao;
    private Checkbox obrigaImagem;
    private WhatsAppTemplate template;
    private Grid<WhatsAppTemplateCampos> grid;
    @Autowired
    private WhatsAppTemplateService whatsAppTemplateService;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(WhatsAppTemplate t) {
        this.removeAll();
        this.template = t;
        if (this.template == null) {
            this.template = new WhatsAppTemplate();
            this.template.setEstrutura(this.getEstrutura());
        }
        this.name = new TextField("Template Name");
        this.name.setWidthFull();
        if (this.template.getTemplateName() != null) {
            this.name.setValue(this.template.getTemplateName());
        }
        this.texto = new TextArea("Template Text");
        this.texto.setWidth("250px");
        this.texto.setHeight("250px");
        if (this.template.getTemplateText() != null) {
            this.texto.setValue(this.template.getTemplateText());
        }
        this.obrigaImagem = new Checkbox("Obriga Imagem");
        if (this.template.getObrigaImagem() != null && this.template.getObrigaImagem().booleanValue()) {
            this.obrigaImagem.setValue((Object)true);
        } else {
            this.obrigaImagem.setValue((Object)false);
        }
        this.grid = new Grid();
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getCampo())).setHeader("Campo").setSortable(true).setFlexGrow(0).setWidth("120px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPosicao().toString())).setHeader("Posicao").setSortable(true).setFlexGrow(0).setWidth("120px");
        this.campo = new TextField("Campo(Inicia com #)");
        this.posicao = new NumberField("Posi\u00e7\u00e3o");
        this.bInsert = UIUtils.createSmallButton((String)"Inserir");
        this.bInsert.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.campo.getValue() == null || this.campo.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe o campo para inserir");
                return;
            }
            if (this.posicao.getValue() == null || (Double)this.posicao.getValue() <= 0.0) {
                UIUtils.showNotification((String)"Informe a posi\u00e7\u00e3o do campo no template(Maior que zero)");
                return;
            }
            this.template.getCampos().add(new WhatsAppTemplateCampos(this.template, this.campo.getValue(), Integer.valueOf(((Double)this.posicao.getValue()).intValue())));
            this.posicao.setValue(null);
            this.campo.setValue("");
            this.povoa();
        });
        this.bDelete = UIUtils.createSmallButton((String)"Excluir");
        this.bDelete.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.grid.getSelectedItems() == null || this.grid.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione um campo para Excluir");
                return;
            }
            WhatsAppTemplateCampos c = (WhatsAppTemplateCampos)this.grid.getSelectedItems().iterator().next();
            this.template.getCampos().remove(c);
            this.povoa();
        });
        this.bClose = UIUtils.createSmallButton((String)"Fechar");
        this.bClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.bSave = UIUtils.createSmallButton((String)"Salvar");
        this.bSave.addClickListener((ComponentEventListener & Serializable)e -> {
            this.template.setTemplateName(this.name.getValue());
            this.template.setTemplateText(this.texto.getValue());
            this.template.setObrigaImagem((Boolean)this.obrigaImagem.getValue());
            this.whatsAppTemplateService.save(this.template);
            this.close();
        });
        this.footer = new FooterContainer(new com.vaadin.flow.component.Component[]{this.bClose, this.bSave});
        this.form = new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.campo, this.posicao, this.bInsert, this.bDelete});
        this.mainLayout = new VerticalLayout();
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.name, this.texto, this.obrigaImagem, this.grid, this.form, this.footer});
        this.add(new com.vaadin.flow.component.Component[]{this.mainLayout});
        this.open();
        this.povoa();
    }

    private void povoa() {
        this.grid.setItems((Collection)this.template.getCampos());
    }
}

