/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.dto.WhatsAppExportacaoDTO;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.repository.WhatsAppRepository;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppExportacaoService {
    @Autowired
    private WhatsAppRepository repository;

    public String exportarCadastros(Estrutura estrutura, LocalDate inicio, LocalDate fim, WhatsAppAtendente atendente, WhatsAppEtapaEnum etapa, Set<String> cnpjs, Set<String> numeros) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            List lista = this.repository.exportarCadastro(estrutura, inicio, fim, atendente, etapa, cnpjs, numeros);
            is = StorageUtil.getObjectModelo((String)"ExportacaoCadastroWhatsapp-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int linha = 1;
            for (WhatsAppExportacaoDTO p : lista) {
                Row row = aba.createRow(linha);
                row.createCell(0).setCellValue(p.getNumero());
                row.createCell(1).setCellValue(p.getNome());
                row.createCell(2).setCellValue(p.getCpfCnpj());
                row.createCell(3).setCellValue(p.getEmail());
                row.createCell(4).setCellValue(p.getFuncao());
                row.createCell(5).setCellValue(p.getDataHoraCriacao() == null ? "" : p.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(6).setCellValue(p.getAtendimentoId() == null ? "N\u00c3O" : "SIM");
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }
}

