/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.model.WhatsAppHaveFile;
import br.com.system.app.features.whatsapp.repository.WhatsAppHaveFileRepository;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppHaveExportService {
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;
    @Autowired
    private WhatsAppHaveFileRepository repository;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private WhatsAppService whatsAppService;

    public WhatsAppHaveFile save(WhatsAppHaveFile file) {
        return (WhatsAppHaveFile)this.repository.save((Object)file);
    }

    public WhatsAppHave have(String numero, boolean force) {
        return this.whatsAppHaveService.getHave(numero, force);
    }

    @Async(value="asyncDefault")
    public void processarLote(EstruturaUsuario eu, String fileName, Set<String> numeros) throws Exception {
        BigDecimal valor = this.configurationsService.get(ConfigurationEnum.VALOR_TEM_WHATS).getBigDecimal();
        InputStream is = null;
        XSSFWorkbook xls = null;
        WhatsAppHaveFile file = new WhatsAppHaveFile();
        file.setDataHora(LocalDateTime.now());
        file.setEstruturaUsuario(eu);
        file.setListaNumeros(StringUtils.join(numeros, (String)","));
        file.setNomeArquivo(fileName);
        file.setStatusAnalise(StatusProcessoEnum.PROCESSANDO);
        file = this.save(file);
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoWhatsHave-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int ind = 1;
            for (String num : numeros) {
                try {
                    num = StringUtil.numbersOnly((String)num);
                    if (num.isEmpty()) continue;
                    Row row = aba.createRow(ind);
                    ++ind;
                    int col = 0;
                    WhatsAppHave have = this.whatsAppHaveService.getHave(num);
                    if (have == null) {
                        row.createCell(col).setCellValue(num);
                        row.createCell(++col).setCellValue("N\u00c3O");
                        row.createCell(++col).setCellValue("N\u00famero inv\u00e1lido ou n\u00e3o localizado");
                        continue;
                    }
                    row.createCell(col).setCellValue(num);
                    row.createCell(++col).setCellValue(have.getHave() != false ? "SIM" : "N\u00c3O");
                    row.createCell(++col).setCellValue(have.getNumeroWhats());
                    this.whatsAppService.cobrarConsultaWhats(num, eu, valor);
                }
                catch (Exception e) {
                    aba.createRow(++ind).createCell(1).setCellValue("Erro, esta consulta n\u00e3o foi cobrada: " + (e.getMessage() == null ? "" : e.getMessage()));
                }
            }
            String hashFile = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String hash = StorageUtil.uploadObjectInputStream((String)hashFile, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            file.setHashArquivo(hash);
            file.setStatusAnalise(StatusProcessoEnum.FINALIZADO);
            this.save(file);
            this.notificacoesService.notify(eu, "Consulta Whats", "Consulta Whats finalizada com sucesso", Boolean.FALSE, Boolean.FALSE, "whatsapp-have-view");
        }
        catch (Exception e) {
            file.setStatusAnalise(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            file.setObservacao(e.getMessage());
            throw e;
        }
        finally {
            try {
                is.close();
                xls.close();
            }
            catch (Exception exception) {}
        }
    }

    public void delete(WhatsAppHaveFile item) {
        this.repository.delete((Object)item);
    }

    public void deleteFileByEstrutura(Estrutura e) {
        this.repository.deleteByEstruturaUsuarioEstrutura(e);
    }

    public List<WhatsAppHaveFile> getByEstruturaUsuario(EstruturaUsuario eu, Pageable pageable) {
        return this.repository.findByEstruturaUsuarioOrderByIdDesc(eu, pageable);
    }

    public long countByEstruturaUsuario(EstruturaUsuario eu) {
        return this.repository.countByEstruturaUsuario(eu);
    }
}

