/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppContentTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagemTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppDayOffService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.features.whatsapp.service.bot.WhatsAppBotAliancasul1452;
import br.com.system.app.features.whatsapp.service.bot.WhatsAppBotGoldcell2;
import br.com.system.app.features.whatsapp.service.bot.WhatsAppBotIOCM1772;
import br.com.system.app.features.whatsapp.service.bot.WhatsAppBotInoveline1608;
import br.com.system.app.features.whatsapp.service.bot.WhatsAppBotMaxplanet325;
import br.com.system.app.features.whatsapp.service.bot.WhatsAppBotNeoCrm1512;
import br.com.system.app.features.whatsapp.service.bot.WhatsAppBotPdvVivo86;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.RandomUtil;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppRecebimentoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppSendService whatsAppSendService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private WhatsAppBotMaxplanet325 whatsAppBotMaxplanet325;
    @Autowired
    private WhatsAppBotGoldcell2 botGoldcell2;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;
    @Autowired
    private WhatsAppBotAliancasul1452 whatsAppBotAliancasul1452;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppBotInoveline1608 whatsAppBotInoveline1608;
    @Autowired
    private WhatsAppDayOffService whatsAppDayOffService;
    @Autowired
    private WhatsAppBotPdvVivo86 whatsAppBotPdvVivo86;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;
    @Autowired
    private WhatsAppBotNeoCrm1512 whatsAppBotNeoCrm1512;
    @Autowired
    private WhatsAppBotIOCM1772 whatsAppBotCamargo1772;
    @Autowired
    private ConfigurationsService configurationsService;

    public WhatsAppAtendimento respondido(JSONObject json, WhatsAppConta conta) {
        String content;
        this.validarJson(json);
        if (conta == null) {
            conta = this.whatsappContaService.getContaByMoorseId(json.getString("integrationId"));
        }
        EstruturaUsuario master = this.eus.getMasterEstrutura(conta.getEstrutura());
        SleepUtil.inMiliseconds((Integer)RandomUtil.getRandom((Integer)100, (Integer)2000));
        WhatsApp w = this.getWhats(json, conta, master);
        if (!this.verificarUltimoAtendimento(w, json.optString("content"))) {
            return null;
        }
        WhatsAppAtendimento wa = this.whatsAppAtendimentoService.getAndCreate(w, null);
        if (wa == null) {
            if (!w.getEtapa().equals((Object)WhatsAppEtapaEnum.FECHADO)) {
                w.setEtapa(WhatsAppEtapaEnum.FECHADO);
                this.whatsAppService.save(w);
            }
            return null;
        }
        wa.setLida(Boolean.valueOf(false));
        w.setEtapa(wa.getEtapa());
        WhatsAppMensagem wm = this.receiveMessage(wa, json);
        wa.setUltimaMensagem(wm.getContent());
        wa.setDataHoraUltimaMensagem(wm.getDataHoraCriacao());
        wa = this.whatsAppAtendimentoService.save(wa);
        w = this.whatsAppService.save(w);
        if (!this.whatsAppDayOffService.validaDayOff(wa, master)) {
            return null;
        }
        if (w.getEtapa().equals((Object)WhatsAppEtapaEnum.ATENDENTE)) {
            this.whatsAppControleService.gravarNova(wm, wm.getStatus());
            return wa;
        }
        for (String idS : this.configurationsService.get(ConfigurationEnum.CONTAS_WHATS_NO_BOT).getValor().split(",")) {
            if (!conta.getId().toString().equals(idS)) continue;
            this.noBot(wm, master);
            return wa;
        }
        String string = content = !json.opt("content").equals(null) ? json.getString("content") : "";
        if (conta.getId().equals(68L)) {
            this.botGoldcell2.notBot(wm, master);
            return wa;
        }
        if (conta.getId().equals(60L)) {
            this.whatsAppBotAliancasul1452.comercial(wa, master, content);
            return wa;
        }
        if (conta.getId().equals(124L)) {
            this.whatsAppBotAliancasul1452.lista(wa, master, content);
            return wa;
        }
        if (conta.getId().equals(39L) || conta.getId().equals(158L)) {
            this.whatsAppBotNeoCrm1512.botDefault(wa, master, content);
            return wa;
        }
        if (!wa.getEtapa().equals((Object)WhatsAppEtapaEnum.INICIAL) && !json.has("content") && json.has("urlFile")) {
            this.whatsAppSendService.sendMessageText(wa, master, "Desculpe, n\u00e3o consigo entender arquivos e audios.\nVoc\u00ea poder\u00e1 enviar ap\u00f3s ser encaminhado para um atendente.");
            return wa;
        }
        if (conta.getId().equals(2L) || conta.getId().equals(42L)) {
            this.botGoldcell2.botDefault(wa, master, content);
        } else if (conta.getEstrutura().getId().equals(1452L)) {
            this.whatsAppBotAliancasul1452.botDefault(wa, master, content);
        } else if (conta.getEstrutura().getId().equals(325L)) {
            this.whatsAppBotMaxplanet325.botDefault(wa, master, content);
        } else if (conta.getEstrutura().getId().equals(1608L)) {
            this.whatsAppBotInoveline1608.botDefault(wa, master, content);
        } else if (conta.getEstrutura().getId().equals(86L)) {
            this.whatsAppBotPdvVivo86.botDefault(wa, master, content);
        } else if (conta.getEstrutura().getId().equals(1772L)) {
            this.whatsAppBotCamargo1772.botDefault(wa, master, content);
        }
        return wa;
    }

    private WhatsAppMensagem receiveMessage(WhatsAppAtendimento wa, JSONObject json) {
        WhatsAppMensagem m = new WhatsAppMensagem();
        m.setContent(json.has("content") && !json.isNull("content") ? json.getString("content") : "");
        try {
            m.setContentTipo(WhatsAppContentTipoEnum.valueOf((String)json.getString("type").toUpperCase()));
        }
        catch (Exception e) {
            if (json.has("type") && json.getString("type").toUpperCase().contains("BUTTON")) {
                m.setContentTipo(WhatsAppContentTipoEnum.BUTTONS);
            }
            m.setContentTipo(WhatsAppContentTipoEnum.ARQUIVO);
        }
        m.setDataHoraCriacao(DateTimeUtil.timeStampToDate((String)json.getString("answeredDate")));
        m.setStatus(WhatsAppStatusEnum.RESPONDIDA);
        m.setTipo(WhatsAppMensagemTipoEnum.RECEBIDA);
        m.setWhatsappAtendimento(wa);
        m.setEstruturaUsuario(wa.getAtendente());
        if (m.getContentTipo().equals((Object)WhatsAppContentTipoEnum.CONTATO)) {
            m.setContent(this.getContato(json));
        } else if (!m.getContentTipo().equals((Object)WhatsAppContentTipoEnum.TEXTO) && json.has("urlFile")) {
            try {
                String extensao = FileUtil.getExtension((String)json.getString("urlFile"));
                String filenameOriginal = FilenameUtils.getName((String)json.getString("urlFile"));
                String fileName = HashUtil.getUUI() + extensao;
                int retry = 0;
                InputStream input = null;
                while (retry <= 10) {
                    try {
                        input = new URL(json.getString("urlFile")).openStream();
                        retry = 99;
                    }
                    catch (Exception ex) {
                        SleepUtil.inSeconds((Integer)5);
                        ++retry;
                    }
                }
                if (input != null) {
                    String url = StorageUtil.uploadObjectInputStream((String)fileName, input);
                    m.setUrlFile(url);
                }
                m.setFileName(fileName);
                m.setNomeOriginal(filenameOriginal);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(WhatsAppRecebimentoService.class).error(e.getMessage());
            }
        }
        return this.whatsAppMensagemService.saveMessage(m);
    }

    private void validarJson(JSONObject json) {
        if (!(json.has("integrationId") && json.has("from") && json.has("status"))) {
            throw new BusinessException("Falta to ou from ou stats");
        }
    }

    private WhatsApp getWhats(JSONObject json, WhatsAppConta conta, EstruturaUsuario master) {
        WhatsApp w = this.whatsAppService.getByNumeroAndConta(json.getString("from"), conta);
        if (w == null) {
            w = this.whatsAppService.criar(json.getString("from"), master, conta);
        }
        return w;
    }

    private boolean verificarUltimoAtendimento(WhatsApp w, String resposta) {
        if (resposta != null && (resposta.equals("1") || resposta.equals("Abrir Atendimento")) || !w.getEtapa().equals((Object)WhatsAppEtapaEnum.FECHADO)) {
            return true;
        }
        List lista = this.whatsAppAtendimentoService.getByWhatsappAndEtapa(w, WhatsAppEtapaEnum.FECHADO);
        for (WhatsAppAtendimento wa : lista) {
            if (wa.getDataHoraUltimaMensagem() == null || !wa.getDataHoraUltimaMensagem().plusMinutes(3L).isAfter(LocalDateTime.now())) continue;
            return false;
        }
        return true;
    }

    public WhatsAppAtendimento errorReceived(JSONObject json) {
        try {
            if (!json.has("error") || !json.has("id")) {
                return null;
            }
            JSONObject jError = json.getJSONObject("error");
            String msgId = json.getString("id");
            WhatsAppMensagem m = this.whatsAppMensagemService.getByMessageId(msgId);
            if (this.foraSessao(jError)) {
                if (m == null) {
                    return null;
                }
                if (!m.getContentTipo().equals((Object)WhatsAppContentTipoEnum.TEXTO)) {
                    m.setObservacoes("Sess\u00e3o de 24 horas encerrada, Voc\u00ea precisa iniciar uma conversa com mensagem de texto.");
                    m.setStatus(WhatsAppStatusEnum.ERRO);
                    this.whatsAppMensagemService.saveMessage(m);
                    this.whatsAppControleService.gravarNova(m, WhatsAppStatusEnum.ERRO);
                } else {
                    WhatsAppMensagem mt = this.whatsAppSendService.sendTemplate(m.getWhatsappAtendimento(), m.getEstruturaUsuario(), m.getContent());
                    this.whatsAppControleService.deleteByAtendimento(m.getWhatsappAtendimento());
                    this.whatsAppMensagemService.deleteMensage(m);
                    this.whatsAppControleService.gravarNova(mt, mt.getStatus());
                }
            } else {
                if (json.optJSONObject("error") != null && json.getJSONObject("error").optString("description") != null) {
                    m.setObservacoes(json.getJSONObject("error").getString("description"));
                } else {
                    m.setObservacoes("erro ao receber mensagem: " + jError.toString());
                }
                m = this.whatsAppMensagemService.saveMessage(m);
                this.whatsAppControleService.gravarNova(m, WhatsAppStatusEnum.ERRO);
            }
            return m.getWhatsappAtendimento();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(WhatsAppRecebimentoService.class).error(e.getMessage());
            return null;
        }
    }

    private String getContato(JSONObject json) {
        StringBuilder retorno = new StringBuilder();
        try {
            if (!json.has("contact")) {
                return retorno.toString();
            }
            JSONObject jContato = json.getJSONObject("contact");
            if (jContato.has("name") && jContato.getJSONObject("name").has("formattedName")) {
                retorno.append("Nome Contato: ").append(jContato.getJSONObject("name").getString("formattedName")).append("<BR>");
            } else if (jContato.has("org") && jContato.getJSONObject("org").has("company")) {
                retorno.append("Nome Comercial: ").append(jContato.getJSONObject("org").getString("company")).append("<BR>");
            }
            if (jContato.has("phones")) {
                for (int i = 0; i < jContato.getJSONArray("phones").length(); ++i) {
                    JSONObject jPhone = jContato.getJSONArray("phones").getJSONObject(i);
                    retorno.append("N\u00famero Contato: ").append(jPhone.getString("phone")).append("<BR>");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno.toString();
    }

    private boolean foraSessao(JSONObject jError) {
        if (jError.has("description")) {
            for (String s : this.configurationsService.get(ConfigurationEnum.FRASES_SESSAO_INATIVA_META).getValor().split(",")) {
                if (!jError.getString("description").contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    private void noBot(WhatsAppMensagem wm, EstruturaUsuario master) {
        EstruturaUsuario eu = this.whatsAppAtendenteService.getAtendenteOnline(wm.getWhatsappAtendimento().getWhatsapp(), master);
        if (eu == null) {
            eu = master;
        }
        WhatsAppAtendimento wa = wm.getWhatsappAtendimento();
        WhatsApp w = wa.getWhatsapp();
        w.setUltimoAtendente(eu);
        w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        wa.setAtendente(eu);
        wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
        this.whatsAppControleService.gravarNova(wm, wm.getStatus());
    }

    public static void main(String[] args) {
        JSONObject j = new JSONObject("{\n \"content\":null\n }");
        System.out.println(j.has("content"));
        System.out.println(j.opt("content"));
        System.out.println(j.opt("content").equals(null));
    }
}

