/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.whatsapp.model.WhatsAppResposta;
import br.com.system.app.features.whatsapp.model.WhatsAppRespostaCategoria;
import br.com.system.app.features.whatsapp.repository.WhatsAppRespostaCategoriaRepository;
import br.com.system.app.features.whatsapp.repository.WhatsAppRespostaRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WhatsAppRespostaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppRespostaRepository repository;
    @Autowired
    private WhatsAppRespostaCategoriaRepository whatsAppRespostaCategoriaRepository;

    public List<WhatsAppRespostaCategoria> getCategoria(Estrutura estrutura) {
        return this.whatsAppRespostaCategoriaRepository.findByEstruturaOrderByNome(estrutura);
    }

    public List<WhatsAppRespostaCategoria> getCategoria(Estrutura estrutura, Pageable pageable) {
        return this.whatsAppRespostaCategoriaRepository.findByEstruturaOrderByNome(estrutura);
    }

    public long countCategoria(Estrutura estrutura) {
        return this.whatsAppRespostaCategoriaRepository.countByEstruturaOrderByNome(estrutura);
    }

    public List<WhatsAppResposta> getRespostas(Estrutura estrutura, WhatsAppRespostaCategoria categoria, Pageable pageable) {
        if (categoria == null) {
            return this.repository.findByEstruturaOrderByOrdem(estrutura, pageable);
        }
        return this.repository.findByEstruturaAndWhatsappRespostaCategoriaOrderByOrdem(estrutura, categoria, pageable);
    }

    public long countRespostas(Estrutura estrutura, WhatsAppRespostaCategoria categoria) {
        if (categoria == null) {
            return this.repository.countByEstrutura(estrutura);
        }
        return this.repository.countByEstruturaAndWhatsappRespostaCategoria(estrutura, categoria);
    }

    public List<WhatsAppResposta> getRespostas(Estrutura estrutura, WhatsAppRespostaCategoria categoria, String resposta) {
        if (resposta.isEmpty()) {
            resposta = null;
        }
        if (categoria == null && resposta == null) {
            return this.repository.findByEstruturaOrderByOrdem(estrutura);
        }
        if (categoria == null) {
            return this.repository.findByEstruturaAndRespostaContainsOrderByOrdem(estrutura, resposta);
        }
        if (resposta == null) {
            return this.repository.findByEstruturaAndWhatsappRespostaCategoriaOrderByOrdem(estrutura, categoria);
        }
        return this.repository.findByEstruturaAndRespostaContainsAndWhatsappRespostaCategoriaOrderByOrdem(estrutura, resposta, categoria);
    }

    public WhatsAppResposta save(WhatsAppResposta wr) {
        if (wr.getOrdem() == null) {
            wr.setOrdem(Integer.valueOf(0));
        }
        return (WhatsAppResposta)this.repository.save((Object)wr);
    }

    public WhatsAppRespostaCategoria saveCategoria(WhatsAppRespostaCategoria wrc) {
        return (WhatsAppRespostaCategoria)this.whatsAppRespostaCategoriaRepository.save((Object)wrc);
    }

    public void delete(WhatsAppResposta wr) {
        this.repository.delete((Object)wr);
    }

    public void deleteCategoria(WhatsAppRespostaCategoria wrc) {
        this.whatsAppRespostaCategoriaRepository.delete((Object)wrc);
    }

    @Modifying
    @Transactional
    public void deleteByEstrutura(Estrutura e) {
        this.repository.deleteByEstrutura(e);
        List categorias = this.getCategoria(e);
        for (WhatsAppRespostaCategoria categoria : categorias) {
            this.deleteCategoria(categoria);
        }
    }
}

