/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service.bot;

import br.com.system.app.features.cobranca.model.ProprietarioEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.suportnumber.SuportNumberService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.TelefoneUtil;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppBotNeoCrm1512
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppSendService sendService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    @Autowired
    private SuportNumberService suportNumber;

    public void botDefault(WhatsAppAtendimento wa, EstruturaUsuario master, String resposta) {
        WhatsApp w;
        block11: {
            w = wa.getWhatsapp();
            w.setUltimoAtendente(master);
            wa.setAtendente(master);
            if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.INICIAL)) {
                this.sendService.sendMessageText(wa, master, "Ol\u00e1, seja bem vindo.\nSou o atendente virtual da NEO SALES e vou guia-lo no atendimento.");
                try {
                    if (w.getLogin() != null && !w.getLogin().isEmpty()) {
                        Usuario u = this.usuarioService.getByLogin(w.getLogin());
                        if (u != null) {
                            EstruturaUsuario eu = this.eus.getFirstByUsuario(u);
                            this.acharLogin(eu, w, wa, master);
                        } else {
                            this.solicitarLogin(w, wa, master);
                        }
                        break block11;
                    }
                    List lu = this.usuarioService.getByCelular(TelefoneUtil.normalize((String)w.getNumero()));
                    if (lu.size() == 1) {
                        EstruturaUsuario eu = this.eus.getFirstByUsuario((Usuario)lu.get(0));
                        this.acharLogin(eu, w, wa, master);
                        break block11;
                    }
                    this.solicitarLogin(w, wa, master);
                }
                catch (Exception e) {
                    this.problemaLogin(w, wa, master, "Erro " + e.getMessage());
                }
            } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.LOGIN_ACESSO)) {
                Usuario u = this.usuarioService.getByLogin(resposta.trim());
                if (u == null) {
                    this.problemaLogin(w, wa, master, "Login n\u00e3o encontrado, por favor informe seu login de acesso, o mesmo que voc\u00ea usa para se logar no NEO ex: usuario@estrutura SEM o .com.br");
                } else {
                    w.setLogin(resposta.trim());
                    EstruturaUsuario eu = this.eus.getFirstByUsuario(u);
                    this.acharLogin(eu, w, wa, master);
                }
            }
        }
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
    }

    private void solicitarLogin(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master) {
        this.sendService.sendMessageText(wa, master, "Seu telefone ainda n\u00e3o est\u00e1 no nosso cadastro.");
        this.sendService.sendMessageText(wa, master, "*Para ser atendido, por favor informe seu login de acesso ex: usuario@estrutura SEM o .com.br*");
        w.setEtapa(WhatsAppEtapaEnum.LOGIN_ACESSO);
        wa.setEtapa(WhatsAppEtapaEnum.LOGIN_ACESSO);
    }

    private void acharLogin(EstruturaUsuario eu, WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master) {
        try {
            w.setCnpjEscolhido(eu.getEstrutura().getCpfCnpj());
            w.setCpfCnpj(w.getCnpjEscolhido());
            w.setEmail(eu.getUsuario().getEmail());
            w.setNome(eu.getUsuario().getNome());
            w.setLogin(eu.getUsuario().getLogin());
            wa.setCnpj(w.getCnpjEscolhido());
            w.setEtapa(WhatsAppEtapaEnum.FECHADO);
            w.setUltimoAtendente(master);
            wa.setAtendente(master);
            wa.setDataHoraTransferencia(LocalDateTime.now());
            wa.setFechado(true);
            wa.setEtapa(WhatsAppEtapaEnum.FECHADO);
            this.sendService.sendMessageText(wa, master, "J\u00e1 te achei aqui\nLogin: *" + eu.getUsuario().getLogin() + "*\nNome: *" + eu.getUsuario().getNome() + "*\nPerfil: *" + String.valueOf(eu.getUsuario().getPerfil()) + "*\nSegue o n\u00famero do seu chamado #" + wa.getPedido().getId());
            ProprietarioEnum proprietario = this.estruturaComplementoService.getComplementos(eu.getEstrutura()).getCobrancaAssinatura().getProprietario();
            String telefoneRaw = this.suportNumber.getForWhats(proprietario);
            String telefoneFormatado = this.suportNumber.getFormmated(proprietario);
            String mensagem = String.format("Ol\u00e1, meu login \u00e9 %s e preciso de suporte.", eu.getUsuario().getLogin() + " Meu perfil \u00e9 " + String.valueOf(eu.getUsuario().getPerfil()) + ".");
            String mensagemCodificada = URLEncoder.encode(mensagem, StandardCharsets.UTF_8);
            String linkWhats = "https://wa.me/" + telefoneRaw + "?text=" + mensagemCodificada;
            String novoWhats = String.format("\ud83d\udea8 Aten\u00e7\u00e3o!\nEstamos com um novo n\u00famero de suporte \ud83d\udcde\n\nClique no link abaixo para j\u00e1 iniciar o atendimento com seus dados:\n\ud83d\udd17 %s\n\nA partir de agora, todo atendimento ser\u00e1 feito exclusivamente pelo n\u00famero:\n\ud83d\udcf2 %s\n\nSalve esse novo contato para continuar falando com a gente com rapidez e seguran\u00e7a!\nSe precisar de ajuda, estamos por aqui. \ud83d\ude09\n", linkWhats, telefoneFormatado);
            this.sendService.sendMessageText(wa, master, novoWhats);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void problemaLogin(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master, String anotacao) {
        w.setEtapa(WhatsAppEtapaEnum.LOGIN_ACESSO);
        w.setUltimoAtendente(master);
        wa.setAtendente(master);
        wa.setDataHoraTransferencia(LocalDateTime.now());
        wa.setFechado(false);
        wa.setEtapa(WhatsAppEtapaEnum.LOGIN_ACESSO);
        this.whatsAppMensagemService.inserirAnotacao(wa, master, anotacao);
        this.sendService.sendMessageText(wa, master, anotacao);
    }
}

