/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.security;

import br.com.system.app.features.googlecron.CronResource;
import br.com.system.app.features.login.LoginView;
import br.com.system.app.features.login.RecuperarAcessoView;
import br.com.system.app.features.pedido.view.AtividadePropostaView;
import br.com.system.app.security.CustomUserDetails;
import br.com.system.app.security.HasPermissionView;
import com.vaadin.flow.server.HandlerHelper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SecurityUtils
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static String getUsername() {
        SecurityContext context = SecurityContextHolder.getContext();
        Object principal = context.getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)context.getAuthentication().getPrincipal();
            return userDetails.getUsername();
        }
        return null;
    }

    public static boolean isAccessGrantedView(Class<?> securedClass) {
        boolean publicView;
        boolean bl = publicView = LoginView.class.equals(securedClass) || RecuperarAcessoView.class.equals(securedClass) || AtividadePropostaView.class.equals(securedClass) || CronResource.class.equals(securedClass);
        if (publicView) {
            return true;
        }
        Authentication userAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (!SecurityUtils.isUserLoggedIn((Authentication)userAuthentication)) {
            return false;
        }
        CustomUserDetails userDetails = (CustomUserDetails)userAuthentication.getPrincipal();
        if (userDetails.getEu().getUsuario().isMaster()) {
            return true;
        }
        HasPermissionView hasPermissionView = (HasPermissionView)AnnotationUtils.findAnnotation(securedClass, HasPermissionView.class);
        if (hasPermissionView == null) {
            return true;
        }
        if (userDetails.getEu().getRules() == null) {
            return false;
        }
        List<String> rulesRequested = Arrays.asList(hasPermissionView.value());
        for (String string : rulesRequested) {
            if (!userDetails.getEu().getRules().contains(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUserLoggedIn() {
        return SecurityUtils.isUserLoggedIn((Authentication)SecurityContextHolder.getContext().getAuthentication());
    }

    private static boolean isUserLoggedIn(Authentication authentication) {
        return authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
    }

    static boolean isFrameworkInternalRequest(HttpServletRequest request) {
        String parameterValue = request.getParameter("v-r");
        return parameterValue != null && Stream.of(HandlerHelper.RequestType.values()).anyMatch(r -> r.getIdentifier().equals(parameterValue));
    }
}

