/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

/*
 * Exception performing whole class analysis ignored.
 */
public class CurrencyUtil {
    public static String toCurrency(BigDecimal valor) {
        Locale ptBR = new Locale("pt", "BR");
        NumberFormat moedaFormat = NumberFormat.getCurrencyInstance(ptBR);
        DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)moedaFormat).getDecimalFormatSymbols();
        decimalFormatSymbols.setCurrencySymbol("");
        ((DecimalFormat)moedaFormat).setDecimalFormatSymbols(decimalFormatSymbols);
        return moedaFormat.format(valor);
    }

    public static String toCurrencyWithR$(Double valor) {
        if (valor == null) {
            return "R$ 0,00";
        }
        return CurrencyUtil.toCurrencyWithR$((BigDecimal)BigDecimal.valueOf(valor));
    }

    public static String toCurrencyWithR$(BigDecimal valor) {
        if (valor == null) {
            return "R$ 0,00";
        }
        if (valor.equals(BigDecimal.ZERO)) {
            return "R$ 0,00";
        }
        Locale ptBR = new Locale("pt", "BR");
        NumberFormat moedaFormat = NumberFormat.getCurrencyInstance(ptBR);
        return moedaFormat.format(valor);
    }

    public static BigDecimal parse(String amount) {
        if (amount == null || amount.isEmpty()) {
            return new BigDecimal(0);
        }
        char lastSeparator = CurrencyUtil.getLastCurrencySeparator((String)amount);
        String nonParseable = "[^\\d\\-" + lastSeparator + "]";
        String genericNum = amount.replaceAll(nonParseable, "").replaceAll(",", ".");
        try {
            return new BigDecimal(genericNum);
        }
        catch (NumberFormatException nfe) {
            return new BigDecimal(genericNum.replaceAll("\\.", ""));
        }
    }

    private static char getLastCurrencySeparator(String valueStr) {
        for (int i = valueStr.length(); i > 0; --i) {
            char ch = valueStr.charAt(i - 1);
            if (ch != ',' && ch != '.') continue;
            return ch;
        }
        return '\u0000';
    }
}

