/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons;

import br.com.system.commons.StringUtil;
import br.com.system.commons.exception.InvalidExtensionException;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    public static String readFile(String path) throws IOException {
        return FileUtil.readFile((String)path, (Charset)StandardCharsets.UTF_8);
    }

    public static String readFile(String path, Charset encoding) throws IOException {
        byte[] content = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(content, encoding);
    }

    public static boolean isPDF(String value) {
        return FileUtil.matchExtension((String)value, (String)".pdf");
    }

    public static boolean isCSV(String value) {
        return FileUtil.matchExtension((String)value, (String)".csv");
    }

    public static boolean isJSON(String value) {
        return FileUtil.matchExtension((String)value, (String)".json");
    }

    public static boolean isXML(String value) {
        return FileUtil.matchExtension((String)value, (String)".xml");
    }

    public static boolean matchExtension(String fileNameOrPath, String matchExtension) {
        String fileExt = FileUtil.getExtension((String)fileNameOrPath);
        return fileExt.equalsIgnoreCase(matchExtension);
    }

    public static String getExtensionWithOutDot(String fileName) {
        return FileUtil.getExtension((String)fileName).replace(".", "");
    }

    public static String getExtension(String fileNameOrPath) {
        return FileUtil.getExtension((String)fileNameOrPath, (boolean)true);
    }

    public static String getExtension(String fileNameOrPath, boolean lowercase) {
        int extIdx = fileNameOrPath.lastIndexOf(".");
        if (extIdx == -1) {
            return "";
        }
        String fileExt = fileNameOrPath.substring(extIdx);
        return lowercase ? ".".concat(fileExt.replaceAll("[^\\pL\\pN\\pM ]", "")).toLowerCase() : ".".concat(fileExt.replaceAll("[^\\pL\\pN\\pM ]", ""));
    }

    public static String getContentType(String fileNameOrPath) throws IOException, InvalidExtensionException {
        if (FileUtil.matchExtension((String)fileNameOrPath, (String)".json")) {
            return "application/json";
        }
        File file = new File(fileNameOrPath);
        String contentType = Files.probeContentType(file.toPath());
        if (contentType == null) {
            contentType = "application/x-www-form-urlencoded";
        }
        return contentType;
    }

    public static String normalizeFileName(String filename) {
        String extension = FileUtil.getExtension((String)filename);
        return StringUtil.removeSpecialChars((String)FilenameUtils.normalize((String)filename.replace(extension, ""))) + extension;
    }

    public static boolean isImage(String fileName) {
        String extensao = FileUtil.getExtension((String)fileName);
        ArrayList<String> extensoes = new ArrayList<String>();
        extensoes.add(".ai");
        extensoes.add(".art");
        extensoes.add(".art");
        extensoes.add(".blend");
        extensoes.add(".bmp");
        extensoes.add(".cdr");
        extensoes.add(".cgm");
        extensoes.add(".cin");
        extensoes.add(".cpt");
        extensoes.add(".dpx");
        extensoes.add(".dxf");
        extensoes.add(".dwg");
        extensoes.add(".eps");
        extensoes.add(".emf");
        extensoes.add(".exr");
        extensoes.add(".fla");
        extensoes.add(".fpx");
        extensoes.add(".gif");
        extensoes.add(".iff");
        extensoes.add(".ilbm");
        extensoes.add(".jpeg");
        extensoes.add(".jpg");
        extensoes.add(".jpg2");
        extensoes.add(".jp2");
        extensoes.add(".mng");
        extensoes.add(".pbm");
        extensoes.add(".pcd");
        extensoes.add(".pgm");
        extensoes.add(".pict");
        extensoes.add(".png");
        extensoes.add(".ppm");
        extensoes.add(".ps");
        extensoes.add(".psd");
        extensoes.add(".psp");
        extensoes.add(".svg");
        extensoes.add(".svgz");
        extensoes.add(".skp");
        extensoes.add(".skb");
        extensoes.add(".swf");
        extensoes.add(".tiff");
        extensoes.add(".tif");
        extensoes.add(".wbm");
        extensoes.add(".wmf");
        extensoes.add(".xar");
        extensoes.add(".xbm");
        extensoes.add(".xcf");
        extensoes.add(".xpm");
        return extensoes.contains(extensao);
    }

    public static StreamResource getStreamResource(byte[] byteArray, String fileName) throws Exception {
        return new StreamResource(fileName, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(byteArray));
    }
}

