/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons;

import br.com.system.commons.StringUtil;
import br.com.system.commons.exception.FieldValidationException;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ValidationUtil {
    private static ValidationUtil instance = null;

    private ValidationUtil() {
    }

    public static synchronized ValidationUtil getInstance() {
        if (instance == null) {
            instance = new ValidationUtil();
        }
        return instance;
    }

    public static boolean isNumber(String str) {
        return StringUtil.isNumber((String)str);
    }

    public ValidationUtil isBlank(Object obj, String message) throws FieldValidationException {
        if (StringUtil.isBlank((Object)obj)) {
            throw new FieldValidationException(message);
        }
        return this;
    }

    public ValidationUtil isValidEmail(String email, String message) throws FieldValidationException {
        if (!ValidationUtil.isValidEmail((String)email)) {
            throw new FieldValidationException(message);
        }
        return this;
    }

    public static boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        return !ValidationUtil.isBlank((Object)(email = email.trim())) && email.matches("\\b[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z]{2,20}\\b");
    }

    public static boolean isBlank(Object obj) {
        return StringUtil.isBlank((Object)obj);
    }

    public static boolean hasAnyBlank(List<Object> objs) {
        return ValidationUtil.hasAnyBlank((Object[])objs.toArray());
    }

    public static boolean hasAnyBlank(Object ... objs) {
        if (objs == null) {
            return true;
        }
        for (Object obj : objs) {
            if (!StringUtil.isBlank((Object)obj)) continue;
            objs = null;
            return true;
        }
        objs = null;
        return false;
    }

    public ValidationUtil isNull(Object obj, String message) throws FieldValidationException {
        if (ValidationUtil.isNull((Object)obj)) {
            throw new FieldValidationException(message);
        }
        return this;
    }

    public ValidationUtil greaterThanZero(Integer value, String message) throws FieldValidationException {
        if (ValidationUtil.isNull((Object)value) || value <= 0) {
            throw new FieldValidationException(message);
        }
        return this;
    }

    public ValidationUtil isValidCNPJ(String cnpj, String message) throws FieldValidationException {
        if (!(ValidationUtil.isNull((Object)cnpj) || ValidationUtil.isValidCNPJ((String)cnpj) || ValidationUtil.isValidCPF((String)cnpj))) {
            if (StringUtil.isBlank((Object)message)) {
                message = "Por favor informe um CNPJ/CPF v\u00e1lido.";
            }
            throw new FieldValidationException(message);
        }
        return this;
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean hasAnyNull(List<Object> objs) {
        return ValidationUtil.hasAnyNull((Object[])objs.toArray());
    }

    public static boolean hasAnyNull(Object ... objs) {
        if (objs == null) {
            return true;
        }
        for (Object obj : objs) {
            if (!ValidationUtil.isNull((Object)obj)) continue;
            objs = null;
            return true;
        }
        objs = null;
        return false;
    }

    public static boolean isValidCnpjAndCpf(String cnpjCpf) {
        return ValidationUtil.isValidCNPJ((String)cnpjCpf) || ValidationUtil.isValidCPF((String)cnpjCpf);
    }

    public static boolean isValidCNPJ(String cnpj) {
        int i;
        if ((cnpj = StringUtil.numbersOnly((String)cnpj)) == null || cnpj.isEmpty() || cnpj.length() != 14 || cnpj.equals("00000000000000")) {
            return false;
        }
        Integer soma = 0;
        Object cnpj_calc = cnpj.substring(0, 12);
        char[] chr_cnpj = cnpj.toCharArray();
        for (i = 0; i < 4; ++i) {
            if (chr_cnpj[i] - 48 < 0 || chr_cnpj[i] - 48 > 9) continue;
            soma = soma + (chr_cnpj[i] - 48) * (6 - (i + 1));
        }
        for (i = 0; i < 8; ++i) {
            if (chr_cnpj[i + 4] - 48 < 0 || chr_cnpj[i + 4] - 48 > 9) continue;
            soma = soma + (chr_cnpj[i + 4] - 48) * (10 - (i + 1));
        }
        Integer dig = 11 - soma % 11;
        cnpj_calc = (String)cnpj_calc + (dig == 10 || dig == 11 ? "0" : Integer.toString(dig));
        soma = 0;
        for (i = 0; i < 5; ++i) {
            if (chr_cnpj[i] - 48 < 0 || chr_cnpj[i] - 48 > 9) continue;
            soma = soma + (chr_cnpj[i] - 48) * (7 - (i + 1));
        }
        for (i = 0; i < 8; ++i) {
            if (chr_cnpj[i + 5] - 48 < 0 || chr_cnpj[i + 5] - 48 > 9) continue;
            soma = soma + (chr_cnpj[i + 5] - 48) * (10 - (i + 1));
        }
        dig = 11 - soma % 11;
        cnpj_calc = (String)cnpj_calc + (dig == 10 || dig == 11 ? "0" : Integer.toString(dig));
        Boolean b = cnpj.equals(cnpj_calc);
        soma = null;
        dig = null;
        cnpj = null;
        cnpj_calc = null;
        return b;
    }

    public static boolean isValidCPF(String cpf) {
        Integer n;
        if ((cpf = StringUtil.numbersOnly((String)cpf)) == null || cpf.isEmpty() || cpf.length() != 11 || cpf.equals("00000000000")) {
            return false;
        }
        Boolean digitosIguais = true;
        Integer i = 0;
        while (i < cpf.length() - 1) {
            if (cpf.charAt(i) != cpf.charAt(i + 1)) {
                digitosIguais = false;
                break;
            }
            n = i;
            i = i + 1;
        }
        if (!digitosIguais.booleanValue()) {
            Integer tmp;
            Character caracter;
            String numeros = cpf.substring(0, 9);
            String digitos = cpf.substring(9);
            Integer soma = 0;
            i = 10;
            while (i > 1) {
                caracter = Character.valueOf(numeros.charAt(10 - i));
                tmp = StringUtil.toInt((String)caracter.toString());
                soma = soma + tmp * i;
                n = i;
                i = i - 1;
            }
            Integer resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
            if (!resultado.equals(tmp = Integer.valueOf(StringUtil.toInt((String)(caracter = Character.valueOf(digitos.charAt(0))).toString())))) {
                return false;
            }
            numeros = cpf.substring(0, 10);
            soma = 0;
            i = 11;
            while (i > 1) {
                caracter = Character.valueOf(numeros.charAt(11 - i));
                tmp = StringUtil.toInt((String)caracter.toString());
                soma = soma + tmp * i;
                n = i;
                i = i - 1;
            }
            resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
            caracter = Character.valueOf(digitos.charAt(1));
            tmp = StringUtil.toInt((String)caracter.toString());
            return resultado.equals(tmp);
        }
        return false;
    }
}

