/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.decimal;

import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.decimal.PrecisionOutOfRangeException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DecimalParser {
    private static final int MIN_PRECISION = 0;
    private static final int MAX_PRECISION = 100;
    private int precision;

    public DecimalParser() {
        this(2);
    }

    public DecimalParser(int precision) {
        this.throwExceptionWhenInvalidPrecision(precision);
        this.precision = precision;
    }

    public DecimalParser setPrecision(int precision) {
        this.throwExceptionWhenInvalidPrecision(precision);
        this.precision = precision;
        return this;
    }

    public String parse(Object value, int precision) {
        this.setPrecision(precision);
        return this.parse(value);
    }

    public String parse(Object value) {
        if (value == null) {
            return "0";
        }
        String pattern = this.getDecimalPattern();
        String rawValue = value.toString();
        return new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.ENGLISH)).format(CurrencyUtil.parse((String)rawValue));
    }

    private String getDecimalPattern() {
        Object decimalFormat = "0";
        if (this.precision > 0) {
            decimalFormat = (String)decimalFormat + ".";
            for (int i = 0; i < this.precision; ++i) {
                decimalFormat = (String)decimalFormat + "0";
            }
        }
        return decimalFormat;
    }

    private void throwExceptionWhenInvalidPrecision(int precision) {
        if (this.isInvalidPrecision(precision)) {
            throw new PrecisionOutOfRangeException(0, 100);
        }
    }

    private boolean isInvalidPrecision(int precision) {
        return precision < 0 || precision > 100;
    }
}

