/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.integreation.conexaoExterna;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class RequestParameters {
    private List<NameValuePair> params = new ArrayList();
    private List<NameValuePair> paramsDefault = new ArrayList();
    private File multiPartParam;
    private JSONObject jsonParams = new JSONObject();
    private String body = "";
    private boolean resetParameters = true;

    public RequestParameters add(String key, String value) {
        this.params.add(new BasicNameValuePair(key, value));
        return this;
    }

    public RequestParameters addUrlQueryParams(String urlQueryParams) {
        String[] pars;
        for (String linha : pars = urlQueryParams.split("\n")) {
            String[] colunas = linha.split(": ");
            this.params.add(new BasicNameValuePair(colunas[0], colunas.length == 2 ? colunas[1] : ""));
        }
        return this;
    }

    public RequestParameters addDefault(String key, String value) {
        this.paramsDefault.add(new BasicNameValuePair(key, value));
        return this;
    }

    public RequestParameters del(String key) {
        ArrayList interateList = new ArrayList(this.params);
        for (NameValuePair param : interateList) {
            if (!param.getName().equals(key)) continue;
            this.params.remove(param);
        }
        return this;
    }

    public RequestParameters setJsonParameters(JSONObject jsonParameters) {
        this.jsonParams = jsonParameters;
        return this;
    }

    public RequestParameters setMultiPartParameters(File file) {
        this.multiPartParam = file;
        return this;
    }

    public RequestParameters setBody(String body) {
        this.body = body;
        return this;
    }

    public RequestParameters setResetParameters(boolean resetParameters) {
        this.resetParameters = resetParameters;
        return this;
    }

    public String getParametersGet(String url) {
        ArrayList<CallSite> tempReturn = new ArrayList<CallSite>();
        for (NameValuePair entry : this.params) {
            tempReturn.add((CallSite)((Object)(entry.getName() + "=" + URLEncoder.encode(entry.getValue()))));
        }
        for (NameValuePair entry : this.paramsDefault) {
            tempReturn.add((CallSite)((Object)(entry.getName() + "=" + URLEncoder.encode(entry.getValue()))));
        }
        if (this.resetParameters) {
            this.resetparams();
        }
        if (!tempReturn.isEmpty()) {
            return url + "?" + String.join((CharSequence)"&", tempReturn);
        }
        return url;
    }

    public List<NameValuePair> getParamsDefault() {
        return this.paramsDefault;
    }

    public HttpEntity getParametersPost() throws UnsupportedEncodingException {
        if (!this.params.isEmpty()) {
            return this.getUrlEncodedFormEntityParams();
        }
        if (this.jsonParams.length() > 0) {
            return this.getStringEntityParamsJson();
        }
        if (this.body != null && this.body.length() > 0) {
            return this.getStringEntityBody();
        }
        if (this.multiPartParam != null) {
            return this.getMultiPartParam();
        }
        return null;
    }

    private HttpEntity getMultiPartParam() {
        return MultipartEntityBuilder.create().addBinaryBody("file", this.multiPartParam).build();
    }

    private HttpEntity getUrlEncodedFormEntityParams() throws UnsupportedEncodingException {
        this.params.addAll(this.paramsDefault);
        UrlEncodedFormEntity postParams = new UrlEncodedFormEntity(this.params);
        if (this.resetParameters) {
            this.params = new ArrayList();
        }
        return postParams;
    }

    private StringEntity getStringEntityParamsJson() {
        return new StringEntity(this.jsonParams.toString(), ContentType.APPLICATION_JSON);
    }

    private StringEntity getStringEntityBody() {
        return new StringEntity(this.body, ContentType.DEFAULT_TEXT);
    }

    public void resetparams() {
        this.params = new ArrayList();
    }

    public void resetparamsDefault() {
        this.paramsDefault = new ArrayList();
    }
}

