/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.integreation.soap;

import jakarta.xml.soap.SOAPConnection;
import jakarta.xml.soap.SOAPConnectionFactory;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public class SoapExecutor {
    private URL urlWs;
    private SOAPMessage retornoRequisicao;

    public SoapExecutor(URL urlWs) {
        this.urlWs = urlWs;
    }

    public SoapExecutor execute(SOAPMessage soapMessage) throws SOAPException {
        SOAPConnection con = SOAPConnectionFactory.newInstance().createConnection();
        this.retornoRequisicao = con.call(soapMessage, (Object)this.urlWs);
        con.close();
        return this;
    }

    public String getStringRetornoRequisicao() throws Exception {
        StringWriter sw = new StringWriter();
        DOMSource source = new DOMSource(this.retornoRequisicao.getSOAPPart().getEnvelope().getBody().getFirstChild());
        TransformerFactory.newInstance().newTransformer().transform(source, new StreamResult(sw));
        return sw.toString();
    }

    public SOAPMessage getRetornoRequisicao() {
        return this.retornoRequisicao;
    }

    public SoapExecutor setUrlWs(URL urlWs) {
        this.urlWs = urlWs;
        return this;
    }
}

