/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
@Tag(value="my-recaptcha")
public class ReCaptcha
extends Component {
    private static final long serialVersionUID = 1L;
    private final String secretKey;
    private final String websiteKey;
    private boolean valid;

    public ReCaptcha(String websiteKey, String secretKey) {
        this.websiteKey = websiteKey;
        this.secretKey = secretKey;
        this.create();
    }

    private void create() {
        Element div = new Element("div");
        div.setAttribute("class", "g-recaptcha");
        div.setAttribute("data-sitekey", this.websiteKey);
        div.setAttribute("data-callback", "myCallback");
        this.getElement().appendChild(new Element[]{div});
        Element script = new Element("script");
        script.setAttribute("type", "text/javascript");
        script.setAttribute("src", "https://www.google.com/recaptcha/api.js?hl=en");
        this.getElement().appendChild(new Element[]{script});
        UI.getCurrent().getPage().executeJs("$0.init = function () {\n    function myCallback(token) {\n        $0.$server.callback(token);\n    }\n    window.myCallback = myCallback;};\n$0.init();\n", new Serializable[]{this});
    }

    public boolean isValid() {
        return this.valid;
    }

    @ClientCallable
    public void callback(String response) {
        try {
            this.valid = this.checkResponse(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkResponse(String response) throws IOException {
        try {
            String remoteAddr = ReCaptcha.getRemoteAddr((VaadinRequest)VaadinService.getCurrentRequest());
            String url = "https://www.google.com/recaptcha/api/siteverify";
            ExternalConnection conexao = new ExternalConnection();
            JSONObject parse = conexao.addParameter("secret", URLEncoder.encode(this.secretKey, "UTF-8")).addParameter("remoteip=", URLEncoder.encode(remoteAddr, "UTF-8")).addParameter("response", URLEncoder.encode(response, "UTF-8")).executePost(url).toJsonObject();
            return parse.has("success") && parse.getBoolean("success");
        }
        catch (Exception e) {
            throw new BusinessException("Erro Captcha: " + e.getMessage());
        }
    }

    private static String getRemoteAddr(VaadinRequest request) {
        String ret = request.getHeader("x-forwarded-for");
        if (ret == null || ret.isEmpty()) {
            ret = request.getRemoteAddr();
        }
        return ret;
    }
}

