/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components.importacao;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.components.importacao.ImportacaoColunas;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.util.TempFileMultiBuffer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportacaoExcel
extends HorizontalContainer {
    private static final long serialVersionUID = 1L;
    private final List<ImportacaoColunas> colunas;
    private List<ImportacaoColunas> colunasArquivo;
    private String nomeArquivo;
    private TempFileMultiBuffer mBuffer;
    private Grid<ImportacaoColunas> gridColunas;
    private Grid<ImportacaoColunas> gridArquivo;
    private Button btnConfirmar;
    private Button btnFechar;
    private Upload upload;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public HashMap<String, Integer> getPosicoes() {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        for (ImportacaoColunas ic : this.colunas) {
            hm.put(ic.getNome(), ic.getPosicao());
        }
        return hm;
    }

    public List<ImportacaoColunas> getColunas() {
        return this.colunas;
    }

    public Integer getPositionByName(String nome) {
        for (ImportacaoColunas item : this.colunas) {
            if (!item.getNome().equals(nome)) continue;
            return item.getPosicao();
        }
        return null;
    }

    public Button getBtnConfirmar() {
        return this.btnConfirmar;
    }

    public Button getBtnFechar() {
        return this.btnFechar;
    }

    public InputStream getContent() {
        return this.mBuffer.getInputStream();
    }

    public ImportacaoExcel(List<ImportacaoColunas> colunas) {
        super(new Component[0]);
        this.colunas = colunas;
        this.create();
    }

    private void create() {
        this.setWidth("900px");
        this.setHeightFull();
        this.setHeight("600px");
        UIUtils.createHeader((String)"Importa\u00e7\u00e3o");
        this.gridColunas = new Grid(ImportacaoColunas.class);
        this.gridColunas.setColumns(new String[0]);
        this.gridColunas.setHeight("450px");
        this.gridColunas.addColumn("nome").setHeader("Coluna").setFlexGrow(0).setWidth("220px");
        this.gridColunas.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)col -> col.getObrigatoria() != false ? "Sim" : "N\u00e3o")).setHeader("OBR").setFlexGrow(0).setWidth("80px");
        this.gridColunas.addColumn("colunaVinculada").setHeader("Link").setFlexGrow(0).setWidth("200px");
        this.gridColunas.addThemeVariants(new GridVariant[]{GridVariant.LUMO_COMPACT});
        this.gridArquivo = new Grid(ImportacaoColunas.class);
        this.gridArquivo.setColumns(new String[0]);
        this.gridArquivo.setHeight("450px");
        this.gridArquivo.addColumn("nome").setHeader("Coluna");
        this.btnConfirmar = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK, (String)"Iniciar importa\u00e7\u00e3o");
        this.btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar");
        this.btnFechar.setVisible(false);
        VerticalContainer direita = new VerticalContainer(new Component[0]);
        direita.add(new Component[]{UIUtils.createSmallSpan((String)"Colunas importa\u00e7\u00e3o"), this.gridColunas});
        direita.setWidth("430px");
        VerticalContainer meio = new VerticalContainer(new Component[0]);
        meio.add(new Component[]{UIUtils.createSmallSpan((String)""), this.createButtonLink(), this.createButtonUnlink(), this.createButtonLimpar(), this.btnFechar, this.btnConfirmar, this.createUpload()});
        meio.setWidth("130px");
        VerticalContainer esquerda = new VerticalContainer(new Component[0]);
        esquerda.add(new Component[]{UIUtils.createSmallSpan((String)"Colunas Arquivo"), this.gridArquivo});
        esquerda.setWidth("300px");
        this.add(new Component[]{direita, meio, esquerda});
        this.refreshGrid();
    }

    public void refreshGrid() {
        this.gridColunas.setItems((Collection)this.colunas);
    }

    private Button createButtonLimpar() {
        Button btnClear = UIUtils.createSmallButton((String)"Limpar", (VaadinIcon)VaadinIcon.RECYCLE, (String)"Limpar colunas");
        btnClear.addClickListener((ComponentEventListener & Serializable)e -> this.setColunasArquivo());
        return btnClear;
    }

    private void limpar() {
        this.colunas.forEach(i -> {
            i.setColunaVinculada(null);
            i.setPosicao(null);
        });
        this.gridColunas.getDataProvider().refreshAll();
    }

    private Button createButtonLink() {
        Button btnLink = UIUtils.createSmallButton((String)"Vincular", (VaadinIcon)VaadinIcon.LINK, (String)"Vincular colunas");
        btnLink.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.gridColunas.getSelectedItems().size() <= 0 || this.gridArquivo.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione as colunas");
                return;
            }
            if (((ImportacaoColunas)this.gridColunas.getSelectedItems().iterator().next()).getColunaVinculada() != null) {
                UIUtils.showNotification((String)"Esta coluna ja esta vinculada, desvincule-a para utiliza-la");
                return;
            }
            ImportacaoColunas campoArquivo = (ImportacaoColunas)this.gridArquivo.getSelectedItems().iterator().next();
            this.colunas.forEach(item -> {
                if (item.equals(this.gridColunas.getSelectedItems().iterator().next())) {
                    item.setColunaVinculada(campoArquivo.getNome());
                    item.setPosicao(((ImportacaoColunas)this.gridArquivo.getSelectedItems().iterator().next()).getPosicao());
                    this.gridColunas.getDataProvider().refreshItem(item);
                }
            });
            this.colunasArquivo.remove(campoArquivo);
            this.gridArquivo.getDataProvider().refreshAll();
            this.gridArquivo.deselect((Object)campoArquivo);
        });
        return btnLink;
    }

    private Button createButtonUnlink() {
        Button btnUnlink = UIUtils.createSmallButton((String)"Desvincular", (VaadinIcon)VaadinIcon.UNLINK, (String)"Desvincular coluna");
        btnUnlink.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.gridColunas.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione a coluna");
                return;
            }
            if (((ImportacaoColunas)this.gridColunas.getSelectedItems().iterator().next()).getColunaVinculada() == null) {
                UIUtils.showNotification((String)"Esta coluna n\u00e3o esta vinculada");
                return;
            }
            this.colunasArquivo.add(new ImportacaoColunas(((ImportacaoColunas)this.gridColunas.getSelectedItems().iterator().next()).getColunaVinculada(), Boolean.TRUE, ((ImportacaoColunas)this.gridColunas.getSelectedItems().iterator().next()).getPosicao()));
            ((ImportacaoColunas)this.gridColunas.getSelectedItems().iterator().next()).setColunaVinculada(null);
            this.gridColunas.getDataProvider().refreshAll();
            this.gridArquivo.getDataProvider().refreshAll();
        });
        return btnUnlink;
    }

    private Upload createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        this.upload = new Upload((Receiver)this.mBuffer);
        this.upload.setMaxFiles(1);
        this.upload.setDropAllowed(false);
        this.upload.setUploadButton((Component)UIUtils.createSmallButton((String)"Upload Arquivo"));
        this.upload.setAcceptedFileTypes(new String[]{".xlsx"});
        this.upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            this.setColunasArquivo();
        });
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        return this.upload;
    }

    public void clear() {
        this.upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
        this.mBuffer.clear();
        this.limpar();
    }

    private void setColunasArquivo() {
        this.limpar();
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            if (this.mBuffer.getInputStream() == null || this.mBuffer.getInputStream().available() <= 0) {
                this.gridArquivo.setItems(new ArrayList());
                return;
            }
            is = this.mBuffer.getInputStream();
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheetAt(0);
            Row row = aba.getRow(0);
            this.colunasArquivo = new ArrayList();
            for (int i = 0; i < row.getLastCellNum(); ++i) {
                if (row.getCell(i) == null) continue;
                this.colunasArquivo.add(new ImportacaoColunas(row.getCell(i).getStringCellValue(), Boolean.TRUE, Integer.valueOf(i)));
            }
            this.gridArquivo.setItems((Collection)this.colunasArquivo);
            row = null;
            aba = null;
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao importar arquivo: " + e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }

    public boolean isValido() {
        for (ImportacaoColunas ic : this.getColunas()) {
            if (!ic.getObrigatoria().booleanValue() || ic.getPosicao() != null) continue;
            return false;
        }
        return true;
    }
}

