/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.config;

import br.com.system.app.features.login.service.DoisFatoresService;
import br.com.system.app.features.sessions.service.SessionsService;
import com.vaadin.flow.component.HeartbeatEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.SessionInitListener;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.spring.annotation.SpringComponent;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;

@SpringComponent
public class ConfigureUIServiceInitListener
implements VaadinServiceInitListener {
    @Autowired
    private SessionsService sessionsService;
    @Autowired
    private DoisFatoresService doisFatoresService;
    private static final long serialVersionUID = 1L;

    public void serviceInit(ServiceInitEvent event) {
        event.getSource().addUIInitListener((UIInitListener & Serializable)uiInitEvent -> {
            uiInitEvent.getUI().addHeartbeatListener(arg_0 -> this.heartbeat(arg_0));
            VaadinServletRequest request = VaadinServletRequest.getCurrent();
            this.heartBeat(request.getSession().getId());
        });
        event.getSource().addSessionInitListener((SessionInitListener & Serializable)eventSession -> {
            eventSession.getSession().setLocale(new Locale("pt", "BR"));
            eventSession.getSession().getSession().setMaxInactiveInterval(1800);
            VaadinRequest request = eventSession.getRequest();
            VaadinSession session = eventSession.getSession();
            if (request != null && request.getCookies() != null) {
                Cookie localeCookie = Arrays.stream(request.getCookies()).filter(c -> c.getName().equals("pt-br")).findFirst().orElse(null);
                session.setAttribute("translate", (Object)"no");
                if (localeCookie != null) {
                    session.setLocale(new Locale(localeCookie.getValue()));
                }
            }
        });
        event.getSource().addSessionDestroyListener((SessionDestroyListener & Serializable)eventSession -> {
            try {
                VaadinServletRequest request = VaadinServletRequest.getCurrent();
                if (request != null) {
                    HttpSession session = request.getSession();
                    this.sessionsService.encerrarSessao(session.getId());
                    UI.getCurrent().close();
                    session.invalidate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void heartbeat(HeartbeatEvent event) {
        String sessionId = event.getSource().getSession().getSession().getId();
        this.heartBeat(sessionId);
    }

    private void heartBeat(String sessionId) {
        this.sessionsService.updateHeartBeat(sessionId);
        this.sessionsService.checkAtivos(sessionId);
        this.doisFatoresService.check10Minutes(sessionId);
    }
}

