/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.analisefatura.model;

import br.com.system.app.features.analisefatura.model.AnaliseFaturaItem;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaProposta;
import br.com.system.app.features.analisefatura.model.StatusAnalise;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.model.OperadoraEnum;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@DynamicUpdate
@Table(name="analise_fatura")
public class AnaliseFatura
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne
    private EstruturaUsuario estruturaUsuario;
    private String cpfCnpj;
    private String nomeCliente;
    @Enumerated(value=EnumType.STRING)
    private StatusAnalise statusAnalise;
    @NotNull
    private LocalDateTime dataHoraImportacao;
    @Enumerated(value=EnumType.STRING)
    private OperadoraEnum operadora;
    private String hashArquivoOriginal;
    private String hashArquivoAnalisado;
    private String hashArquivoAnalisadoDetalhamento;
    private String nomeArquivo;
    private String codigoConta;
    private String observacao;
    private String mesAno;
    private BigDecimal valorTotal;
    private LocalDate dataVencimento;
    private Long atividadeId;
    @OneToMany(mappedBy="analiseFatura", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, targetEntity=AnaliseFaturaItem.class)
    private Set<AnaliseFaturaItem> itens = new HashSet();
    @OneToMany(mappedBy="analiseFatura", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, targetEntity=AnaliseFaturaProposta.class)
    private Set<AnaliseFaturaProposta> itensProposta = new HashSet();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EstruturaUsuario getEstruturaUsuario() {
        return this.estruturaUsuario;
    }

    public void setEstruturaUsuario(EstruturaUsuario estruturaUsuario) {
        this.estruturaUsuario = estruturaUsuario;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public String getNomeCliente() {
        return this.nomeCliente;
    }

    public void setNomeCliente(String nomeCliente) {
        this.nomeCliente = nomeCliente;
    }

    public StatusAnalise getStatusAnalise() {
        return this.statusAnalise;
    }

    public void setStatusAnalise(StatusAnalise statusAnalise) {
        this.statusAnalise = statusAnalise;
    }

    public LocalDateTime getDataHoraImportacao() {
        return this.dataHoraImportacao;
    }

    public void setDataHoraImportacao(LocalDateTime dataHoraImportacao) {
        this.dataHoraImportacao = dataHoraImportacao;
    }

    public OperadoraEnum getOperadora() {
        return this.operadora;
    }

    public void setOperadora(OperadoraEnum operadora) {
        this.operadora = operadora;
    }

    public String getHashArquivoOriginal() {
        return this.hashArquivoOriginal;
    }

    public void setHashArquivoOriginal(String hashArquivoOriginal) {
        this.hashArquivoOriginal = hashArquivoOriginal;
    }

    public String getHashArquivoAnalisado() {
        return this.hashArquivoAnalisado;
    }

    public void setHashArquivoAnalisado(String hashArquivoAnalisado) {
        this.hashArquivoAnalisado = hashArquivoAnalisado;
    }

    public String getHashArquivoAnalisadoDetalhamento() {
        return this.hashArquivoAnalisadoDetalhamento;
    }

    public void setHashArquivoAnalisadoDetalhamento(String hashArquivoAnalisadoDetalhamento) {
        this.hashArquivoAnalisadoDetalhamento = hashArquivoAnalisadoDetalhamento;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public String getCodigoConta() {
        return this.codigoConta;
    }

    public void setCodigoConta(String codigoConta) {
        this.codigoConta = codigoConta;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Set<AnaliseFaturaItem> getItens() {
        return this.itens;
    }

    public void setItens(Set<AnaliseFaturaItem> itens) {
        this.itens = itens;
    }

    public Set<AnaliseFaturaProposta> getItensProposta() {
        return this.itensProposta;
    }

    public void setItensProposta(Set<AnaliseFaturaProposta> itensProposta) {
        this.itensProposta = itensProposta;
    }

    public String getMesAno() {
        return this.mesAno;
    }

    public void setMesAno(String mesAno) {
        this.mesAno = mesAno;
    }

    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    public Long getAtividadeId() {
        return this.atividadeId;
    }

    public void setAtividadeId(Long atividadeId) {
        this.atividadeId = atividadeId;
    }
}

