/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.analisefatura.repository;

import br.com.system.app.features.analisefatura.model.AnaliseFaturaDTO;
import br.com.system.app.features.analisefatura.repository.AnaliseFaturaRepositoryQuery;
import br.com.system.commons.StringUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class AnaliseFaturaRepositoryImpl
implements AnaliseFaturaRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional
    public List<AnaliseFaturaDTO> findAnalises(Long faturaId, Set<Long> hierarquia, Set<String> cnpjs, Boolean semAtividade, Pageable pageable) {
        Query query = this.getQuery(faturaId, hierarquia, cnpjs, pageable, false, semAtividade);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public long countAnalises(Long faturaId, Set<Long> hierarquia, Set<String> cnpjs, Boolean semAtividade) {
        Query query = this.getQuery(faturaId, hierarquia, cnpjs, null, true, semAtividade);
        return StringUtil.toLong((String)query.getSingleResult().toString());
    }

    public Query getQuery(Long faturaId, Set<Long> hierarquia, Set<String> cnpjs, Pageable pageable, boolean count, Boolean semAtividade) {
        StringBuilder sql = new StringBuilder();
        if (count) {
            sql.append(" select count(*) total");
        } else {
            sql.append("select af.id,af.estrutura_usuario_id, u.nome nome_usuario,af.cpf_cnpj,af.nome_cliente,af.status_analise,af.data_hora_importacao,");
            sql.append("af.operadora,af.hash_arquivo_original,af.hash_arquivo_analisado,af.hash_arquivo_analisado_detalhamento,af.nome_arquivo,af.codigo_conta,af.observacao,af.mes_ano,af.valor_total,af.data_vencimento");
        }
        sql.append(" FROM analise_fatura af,estrutura_usuario eu,usuario u ");
        sql.append(" WHERE af.estrutura_usuario_id=eu.id and eu.usuario_id=u.id and  af.estrutura_usuario_id in :hierarquia");
        if (cnpjs.size() > 0) {
            sql.append(" AND af.cpf_cnpj in :cnpjs");
        }
        if (faturaId != null && faturaId > 0L) {
            sql.append(" AND af.id=:faturaId");
        }
        if (semAtividade.booleanValue()) {
            sql.append(" AND af.atividade_id is null");
        }
        sql.append(" order by af.id desc");
        if (pageable != null) {
            sql.append(" limit :limit offset :offset");
        }
        Query query = !count ? this.manager.createNativeQuery(sql.toString(), AnaliseFaturaDTO.class) : this.manager.createNativeQuery(sql.toString());
        query.setParameter("hierarquia", hierarquia);
        if (faturaId != null && faturaId > 0L) {
            query.setParameter("faturaId", (Object)faturaId);
        }
        if (!cnpjs.isEmpty()) {
            query.setParameter("cnpjs", cnpjs);
        }
        if (!count && pageable != null) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query;
    }
}

