/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingContato;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

public class ClienteCopyMailing
implements Serializable {
    private static final long serialVersionUID = 1L;

    public Cliente convertMailingToCliente(Mailing mailing) {
        if (mailing == null) {
            return null;
        }
        Cliente cliente = new Cliente();
        cliente.setCpfCnpj(mailing.getCpfCnpj());
        cliente.setNome(mailing.getNome());
        cliente.setDataHoraAtualizacao(LocalDateTime.now());
        cliente.setBairro(mailing.getBairro());
        cliente.setCep(mailing.getCep());
        cliente.setCidade(mailing.getCidade());
        cliente.setComplemento(mailing.getComplemento());
        cliente.setEstado(mailing.getEstado());
        cliente.setLogradouro(mailing.getLogradouro());
        cliente.setNumero(mailing.getNumero());
        this.copyContatos(cliente, mailing.getContatos());
        return cliente;
    }

    private void copyContatos(Cliente cliente, Set<MailingContato> mailingContatos) {
        mailingContatos.forEach(mailingContato -> {
            if (mailingContato.getValor() != null && !mailingContato.getValor().isEmpty()) {
                cliente.getClienteContato().add(new ClienteContato(TipoContatoEnum.valueOf((String)mailingContato.getTipo().name()), mailingContato.getValor()));
            }
        });
    }
}

