/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteDTO;
import br.com.system.app.features.cliente.model.ClienteVencimento;
import br.com.system.app.features.cliente.repository.ClienteVencimentoRepository;
import br.com.system.app.features.estrutura.model.Estrutura;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClienteVencimentoService {
    @Autowired
    private ClienteVencimentoRepository repository;

    public Set<ClienteVencimento> getByClienteList(Set<ClienteDTO> clientes) {
        HashSet<Long> ids = new HashSet<Long>();
        for (ClienteDTO d : clientes) {
            ids.add(d.getId());
        }
        return this.repository.findByClienteIdIn(ids);
    }

    public Set<ClienteVencimento> getByCliente(Cliente c) {
        return this.repository.findByCliente(c);
    }

    public ClienteVencimento save(ClienteVencimento cv) {
        return (ClienteVencimento)this.repository.save((Object)cv);
    }

    public Set<ClienteVencimento> getByDia(Estrutura estrutura, Integer dia, LocalDate aPartir, LocalDate ate) {
        return this.repository.findByClienteEstruturaAndDiaAndApartirLessThanEqualAndAteGreaterThanEqual(estrutura, dia, aPartir, ate);
    }

    @Transactional
    public void delete(ClienteVencimento cv) {
        this.repository.delete((Object)cv);
    }

    @Transactional
    public void deleteByCliente(Cliente c) {
        this.repository.deleteByCliente(c);
    }

    public void saveAll(List<ClienteVencimento> vencs) {
        this.repository.saveAll(vencs);
    }
}

