/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteLog;
import br.com.system.app.features.cliente.service.ClienteLogService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collection;

public class ClienteLogView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ClienteLogService clienteLogService;
    private final Cliente cliente;
    private Grid<ClienteLog> grid;

    public ClienteLogView(Cliente cliente, ClienteLogService clienteLogService) {
        this.clienteLogService = clienteLogService;
        this.cliente = cliente;
        if (this.hasPermission("CLIENTE_LOG_VIEW")) {
            this.init();
        } else {
            UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem Permiss\u00e3o para visualisar esta tela");
        }
    }

    private void init() {
        this.grid = new Grid(ClienteLog.class);
        this.grid.setColumns(new String[0]);
        this.grid.setWidth("800px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Data/Hora").setFlexGrow(0).setWidth("180px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getNome()))).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button btn = UIUtils.createSmallButton((String)"Abrir");
            btn.addClickListener((ComponentEventListener & Serializable)abr -> InformationDialog.show((String)"Log Altera\u00e7\u00f5es", (String)p.getLog()));
            return btn;
        })).setHeader("").setFlexGrow(0).setWidth("90px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getLog()))).setHeader("Log").setFlexGrow(0).setWidth("300x");
        this.grid.setItems((Collection)this.clienteLogService.getLog(this.cliente));
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.add(new Component[]{UIUtils.createHeader((String)"Log de altera\u00e7\u00f5es do cliente")});
        v.add(new Component[]{this.grid});
        v.add(new Component[]{btnClose});
        this.add(new Component[]{v});
        this.open();
    }
}

