/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.creditos.service;

import br.com.system.app.features.cobranca.service.EnotasService;
import br.com.system.app.features.creditos.model.Creditos;
import br.com.system.app.features.creditos.model.CreditosFatura;
import br.com.system.app.features.creditos.model.CreditosFaturaDTO;
import br.com.system.app.features.creditos.model.CreditosFaturaStatusEnum;
import br.com.system.app.features.creditos.repository.CreditosFaturaRepository;
import br.com.system.app.features.creditos.repository.CreditosRepository;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import jakarta.servlet.ServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CreditosService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(CreditosService.class);
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private CreditosRepository repository;
    @Autowired
    private CreditosFaturaRepository creditosFaturaRepository;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private EnotasService enotasService;

    public CreditosFatura getByStarkId(String starkId) {
        return this.creditosFaturaRepository.findByStarkId(starkId);
    }

    public List<CreditosFaturaDTO> getNoLink() {
        return this.creditosFaturaRepository.findNotaEmitida();
    }

    public void validarPagamento(String starkId) {
        CreditosFatura cf = this.getByStarkBankId(starkId);
        if (cf == null) {
            return;
        }
        if (!cf.getStatus().equals((Object)CreditosFaturaStatusEnum.PAGO)) {
            this.pagar(cf);
        }
    }

    public CreditosFatura getByStarkBankId(String invoiceId) {
        return this.creditosFaturaRepository.findByStarkId(invoiceId);
    }

    public void pagar(CreditosFatura fatura) {
        try {
            fatura = (CreditosFatura)this.creditosFaturaRepository.findById((Object)fatura.getId()).get();
            if (fatura.getStatus().equals((Object)CreditosFaturaStatusEnum.PAGO)) {
                return;
            }
            Usuario u = fatura.getEstruturaUsuario().getUsuario();
            String numero = StringUtil.numbersOnly((String)u.getNumero());
            if (numero == null || numero.isEmpty()) {
                numero = "00";
            }
            try {
                if (u.getEnotasClientId() == null) {
                    String enotasClientId = this.enotasService.cadatrarCliente(u.getCpf(), u.getNome(), u.getEmail(), u.getCelular(), u.getLogradouro(), numero, u.getCompl(), u.getBairro(), u.getCidade(), u.getEstado(), u.getCep());
                    u.setEnotasClientId(enotasClientId);
                    this.usuarioService.salvar(u, fatura.getEstruturaUsuario());
                }
                String enotasId = this.enotasService.emitirVenda(u.getEnotasClientId(), LocalDate.now(), fatura.getValor(), "Creditos");
                fatura.setEnotasId(enotasId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fatura.setStatus(CreditosFaturaStatusEnum.PAGO);
            fatura.setDataPagamento(LocalDate.now());
            this.salvarFatura(fatura);
            this.transacionar(fatura.getEstruturaUsuario(), "Credito da fatura " + fatura.getId() + " paga", fatura.getValor());
            this.notificacoesService.notify(fatura.getEstruturaUsuario(), "Pagamento identificado", "Foi cr\u00e9ditado o valor de R$ " + String.valueOf(fatura.getValor()) + " no seu cr\u00e9dito");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public JSONArray getExtratoForJson(ServletRequest request, EstruturaUsuario eu) {
        JSONArray list = new JSONArray();
        List creditos = this.getByEstruturaUsuario(eu, (Pageable)PageRequest.of((int)0, (int)100));
        for (Creditos credito : creditos) {
            JSONObject j = new JSONObject();
            j.put("usuario", (Object)credito.getEstruturaUsuario().getUsuario().getLogin());
            j.put("dataHora", (Object)credito.getDataHora().format(DateTimeFormatter.ISO_DATE_TIME));
            j.put("ocorrencia", (Object)credito.getOcorrencia());
            j.put("valor", (Object)credito.getValor());
            j.put("saldo", (Object)credito.getSaldo());
            list.put((Object)j);
        }
        return list;
    }

    public List<Creditos> getByEstruturaUsuario(EstruturaUsuario eu, Pageable pageable) {
        return this.repository.findByEstruturaUsuarioOrderByIdDesc(eu, pageable);
    }

    public JSONArray getFaturasForJson(EstruturaUsuario eu) {
        JSONArray arr = new JSONArray();
        List faturas = this.getFaturasByEstruturausuario(eu);
        for (CreditosFatura fatura : faturas) {
            JSONObject j = new JSONObject();
            j.put("dataHora", (Object)fatura.getDataHora());
            j.put("cpfCnpj", (Object)fatura.getCpfCnpj());
            j.put("nome", (Object)fatura.getNome());
            j.put("email", (Object)fatura.getEmail());
            j.put("telefone", (Object)fatura.getTelefone());
            j.put("valor", (Object)fatura.getValor());
            j.put("urlFatura", (Object)fatura.getUrl());
            j.put("codigoFatura", (Object)fatura.getVindiBillId());
            j.put("statusFatura", (Object)fatura.getStatus().name());
            arr.put((Object)j);
        }
        return arr;
    }

    public List<CreditosFatura> getFaturasByEstruturausuario(EstruturaUsuario eu) {
        return this.creditosFaturaRepository.findByEstruturaUsuarioOrderByIdDesc(eu);
    }

    public long countByEstruturaUsuario(EstruturaUsuario eu) {
        return this.repository.countByEstruturaUsuario(eu);
    }

    public void transacionar(EstruturaUsuario eu, String ocorrencia, BigDecimal valor) {
        Creditos credito = new Creditos();
        credito.setDataHora(LocalDateTime.now());
        credito.setEstruturaUsuario(eu);
        credito.setOcorrencia(ocorrencia);
        credito.setValor(valor);
        BigDecimal saldo = this.usuarioService.saveCreditos(eu, valor);
        credito.setSaldo(saldo);
        this.repository.save((Object)credito);
    }

    public boolean temCredito(EstruturaUsuario eu, BigDecimal minimo) {
        return this.usuarioService.getCreditos(eu.getUsuario()).compareTo(minimo) >= 0;
    }

    public BigDecimal getCredito(EstruturaUsuario eu) {
        return this.usuarioService.getCreditos(eu.getUsuario());
    }

    public CreditosFatura salvarFatura(CreditosFatura cf) {
        if (!ValidationUtil.isValidCnpjAndCpf((String)cf.getCpfCnpj())) {
            throw new BusinessException("Cpf/Cnpj inv\u00e1lido");
        }
        if (cf.getEmail().isBlank() || cf.getNome().isBlank() || cf.getTelefone().isBlank() || cf.getValor().doubleValue() <= 0.0) {
            throw new BusinessException("H\u00e1 campos inv\u00e1lidos, verifique");
        }
        return (CreditosFatura)this.creditosFaturaRepository.save((Object)cf);
    }

    public List<CreditosFatura> getPendentes() {
        return this.creditosFaturaRepository.findByStatus(CreditosFaturaStatusEnum.EM_ABERTO);
    }

    public void cancelarFatura(CreditosFatura fatura) {
        try {
            fatura.setStatus(CreditosFaturaStatusEnum.CANCELADA);
            this.salvarFatura(fatura);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao cancelar fatura " + e.getMessage());
        }
    }

    public CreditosFatura getById(Long id) {
        return (CreditosFatura)this.creditosFaturaRepository.findById((Object)id).get();
    }

    public void checarNota() {
        List noLink = this.getNoLink();
        for (CreditosFaturaDTO cf : noLink) {
            CreditosFatura cobrancaFatura = this.getById(cf.getId());
            this.checarNota(cobrancaFatura);
        }
    }

    private void checarNota(CreditosFatura cf) {
        try {
            String linkNota = this.enotasService.getLinkNota(cf.getEnotasId());
            if (linkNota.isEmpty()) {
                return;
            }
            cf.setLinkPdfEnotas(linkNota);
            this.salvarFatura(cf);
        }
        catch (Exception e) {
            return;
        }
    }
}

