/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dashboard;

import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.dashboard.DashBoardBoxTipoEnum;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.producaopainel.model.ProducaoColunas;
import br.com.system.app.features.producaopainel.model.ProducaoLinhas;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.model.ProducaoPainelBox;
import br.com.system.app.features.producaopainel.service.ProducaoColunasService;
import br.com.system.app.features.producaopainel.service.ProducaoLinhasService;
import br.com.system.app.features.producaopainel.service.ProducaoPainelBoxService;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.spring.annotation.UIScope;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.vaadin.addons.tatu.ColorPicker;
import org.vaadin.addons.tatu.ColorPickerVariant;

@Component
@UIScope
public class DashBoardBoxForm
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProducaoColunasService producaoColunasService;
    @Autowired
    private ProducaoLinhasService producaoLinhasService;
    @Autowired
    private ProducaoPainelService producaoPainelService;
    @Autowired
    private ProducaoPainelBoxService producaoPainelBoxService;
    @Autowired
    private EquipeService equipeService;
    private ProducaoPainelBox box;
    private MultiComboBox<ProducaoColunas> cbColunas;
    private MultiComboBox<ProducaoLinhas> cbLinhas;
    private MultiComboBox<Equipe> cbEquipe;
    private TextField txtNome;
    private NumberField posicao;
    private ComboBox<DashBoardBoxTipoEnum> cbTipo;
    private Checkbox cbNaoContemFilas;
    private Checkbox cbNaoContemGrupos;
    private Checkbox cbMostraValor;
    private Checkbox cbMostraQuantidade;
    private ColorPicker colorPicker;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(Estrutura estrutura, ProducaoPainelBox b) {
        HashSet<Object> cols;
        this.removeAll();
        this.setCloseOnOutsideClick(false);
        this.setMinWidth("600px");
        this.box = b;
        if (this.box == null) {
            this.box = new ProducaoPainelBox();
            this.box.setEstrutura(estrutura);
        }
        ProducaoPainel painel = this.producaoPainelService.getPadraoByEstrutura(estrutura);
        this.cbColunas = new MultiComboBox("Filas", (Collection)this.producaoColunasService.getColunas(painel, "", null));
        this.cbColunas.setWidthFull();
        this.cbColunas.setItemLabelGenerator(ProducaoColunas::getNome);
        if (this.box.getFilas() != null && !this.box.getFilas().isEmpty()) {
            cols = new HashSet<Object>();
            for (String s : this.box.getFilas().split(",")) {
                try {
                    cols.add(this.producaoColunasService.getById(Long.valueOf(s)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cbColunas.setValue(cols);
        }
        this.cbNaoContemFilas = new Checkbox("N\u00e3o Contem Filas");
        if (this.box.getNaoContemFilas() != null) {
            this.cbNaoContemFilas.setValue((Object)this.box.getNaoContemFilas());
        }
        this.cbEquipe = new MultiComboBox("Equipe", (Collection)this.equipeService.getEquipes(this.getEstrutura()));
        this.cbEquipe.setWidthFull();
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        if (this.box.getEquipes() != null && !this.box.getEquipes().isEmpty()) {
            HashSet<Equipe> equipes = new HashSet<Equipe>();
            for (String s : this.box.getEquipes().split(",")) {
                try {
                    equipes.add(this.equipeService.getById(Long.valueOf(s)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cbEquipe.setValue(equipes);
        }
        this.cbLinhas = new MultiComboBox("Grupos", (Collection)this.producaoLinhasService.getLinhas(painel, "", null));
        this.cbLinhas.setWidthFull();
        this.cbLinhas.setItemLabelGenerator(ProducaoLinhas::getNome);
        if (this.box.getGrupos() != null && !this.box.getGrupos().isEmpty()) {
            cols = new HashSet();
            for (String s : this.box.getGrupos().split(",")) {
                try {
                    cols.add(this.producaoLinhasService.getById(Long.valueOf(s)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cbLinhas.setValue(cols);
        }
        this.cbNaoContemGrupos = new Checkbox("N\u00e3o Contem Grupos");
        if (this.box.getNaoContemGrupos() != null) {
            this.cbNaoContemGrupos.setValue((Object)this.box.getNaoContemGrupos());
        }
        this.cbMostraValor = new Checkbox("Mostrar Valor");
        if (this.box.getMostrarValor() != null) {
            this.cbMostraValor.setValue((Object)this.box.getMostrarValor());
        }
        this.cbMostraQuantidade = new Checkbox("Mostrar Quantidade");
        if (this.box.getMostrarQuantidade() != null) {
            this.cbMostraQuantidade.setValue((Object)this.box.getMostrarQuantidade());
        }
        this.txtNome = new TextField("Nome");
        this.txtNome.setWidthFull();
        if (this.box.getNome() != null) {
            this.txtNome.setValue(this.box.getNome());
        }
        this.posicao = new NumberField("Posi\u00e7\u00e3o");
        this.posicao.setWidth("80px");
        if (this.box.getPosicao() != null) {
            this.posicao.setValue((Number)this.box.getPosicao().doubleValue());
        }
        this.cbTipo = new ComboBox("Tipo", (Object[])DashBoardBoxTipoEnum.values());
        this.cbTipo.setWidthFull();
        this.cbTipo.setItemLabelGenerator(Enum::name);
        this.cbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.enableControl());
        if (this.box.getTipo() != null) {
            this.cbTipo.setValue((Object)this.box.getTipo());
        } else {
            this.cbTipo.setValue((Object)DashBoardBoxTipoEnum.NORMAL);
        }
        this.colorPicker = new ColorPicker();
        this.colorPicker.setLabel("Cor de Fundo");
        this.colorPicker.addThemeVariants((ThemeVariant[])new ColorPickerVariant[]{ColorPickerVariant.COMPACT});
        if (this.box.getBackgroundColor() != null) {
            this.colorPicker.setValue(this.box.getBackgroundColor());
        } else {
            this.colorPicker.setValue("#eaeaea");
        }
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar");
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.cbTipo.getValue() == null) {
                UIUtils.showNotification((String)"Selecione um tipo");
                return;
            }
            if (!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO) && this.cbLinhas.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Selecione Grupos");
                return;
            }
            if (!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO) && this.cbColunas.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Selecione Filas");
                return;
            }
            if (this.txtNome.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe um nome");
                return;
            }
            this.salvar();
        });
        HorizontalContainer posContainer = new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.posicao, this.colorPicker});
        posContainer.setAlignItems(FlexComponent.Alignment.END);
        VerticalContainer main = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        main.setSizeFull();
        main.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Cadastro BOX")});
        main.add(new com.vaadin.flow.component.Component[]{this.cbTipo, this.txtNome, posContainer, new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.cbMostraValor, this.cbMostraQuantidade}), this.cbEquipe, this.cbColunas, this.cbNaoContemFilas, this.cbLinhas, this.cbNaoContemGrupos});
        main.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnFechar, btnSalvar})});
        this.add(new com.vaadin.flow.component.Component[]{main});
        this.open();
    }

    private void salvar() {
        if (this.posicao.getValue() == null) {
            UIUtils.showNotification((String)"Informe uma posicao");
            return;
        }
        HashSet<String> filas = new HashSet<String>();
        HashSet<String> grupos = new HashSet<String>();
        HashSet<String> equipes = new HashSet<String>();
        for (ProducaoColunas pc : this.cbColunas.getValue()) {
            filas.add(pc.getId().toString());
        }
        for (ProducaoLinhas pl : this.cbLinhas.getValue()) {
            grupos.add(pl.getId().toString());
        }
        for (Equipe e : this.cbEquipe.getValue()) {
            equipes.add(e.getId().toString());
        }
        this.box.setNome(this.txtNome.getValue());
        this.box.setFilas(StringUtils.join(filas, (String)","));
        this.box.setGrupos(StringUtils.join(grupos, (String)","));
        this.box.setEquipes(StringUtils.join(equipes, (String)","));
        this.box.setPosicao(Integer.valueOf(((Double)this.posicao.getValue()).intValue()));
        this.box.setTipo((DashBoardBoxTipoEnum)this.cbTipo.getValue());
        this.box.setNaoContemFilas((Boolean)this.cbNaoContemFilas.getValue());
        this.box.setNaoContemGrupos((Boolean)this.cbNaoContemGrupos.getValue());
        this.box.setBackgroundColor((String)this.colorPicker.getValue());
        this.box.setMostrarValor((Boolean)this.cbMostraValor.getValue());
        this.box.setMostrarQuantidade((Boolean)this.cbMostraQuantidade.getValue());
        this.producaoPainelBoxService.save(this.box);
        this.close();
    }

    private void enableControl() {
        this.cbEquipe.setEnabled(!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO));
        this.cbLinhas.setEnabled(!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO));
        this.cbColunas.setEnabled(!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO));
        this.cbNaoContemFilas.setEnabled(!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO));
        this.cbNaoContemGrupos.setEnabled(!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO));
        this.cbMostraValor.setEnabled(!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO) && !((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CONTAGEM_CNPJ) && !((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CONTAGEM_CONSULTOR));
        this.cbMostraQuantidade.setEnabled(!((DashBoardBoxTipoEnum)this.cbTipo.getValue()).equals((Object)DashBoardBoxTipoEnum.CABECALHO));
    }
}

