/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.email;

import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.email.model.EmailAtividade;
import br.com.system.app.features.email.model.EmailAtividadeTipoEnum;
import br.com.system.app.features.email.repository.EmailAtividadeRepository;
import br.com.system.app.features.email.service.EmailAtividadeService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.storage.model.UrlSign;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.SleepUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class EmailAtividadeForm
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private EmailAtividade emailAtividade;
    private final PedidoEtapaService pedidoEtapaService;
    private final EstruturaUsuario eu;
    private final EmailAtividadeService emailAtividadeService;
    private final EmailAtividadeRepository repository;
    private final Span tags = new Span();
    private TextField assunto;
    private MultiComboBox<PedidoEtapa> cbEtapa;
    private Checkbox cbAtivo;
    private NumberField dias;
    private Button btnSalvar;
    private Button btnFechar;
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;
    private Set<String> hashImages;
    private HorizontalContainer div;
    private TextArea conteudoHtml;
    private String hashSelecionado;
    private TextField linkImage;
    private Button btnVisualizar;
    private Button btnCriar;
    private Upload upload;
    private Button processar;
    private Button btnSend;
    private RadioButtonGroup<EmailAtividadeTipoEnum> rbTipo;
    private DownloadDialog dd;

    public EmailAtividadeForm(EstruturaUsuario eu, EmailAtividade emailAtividade, PedidoEtapaService pedidoEtapaService, EmailAtividadeService emailAtividadeService, EmailAtividadeRepository repository) {
        this.emailAtividade = emailAtividade;
        this.repository = repository;
        this.emailAtividadeService = emailAtividadeService;
        this.eu = eu;
        this.pedidoEtapaService = pedidoEtapaService;
        this.create();
    }

    private void controler() {
        this.div.setVisible(this.emailAtividade.getId() != null);
        this.btnCriar.setVisible(this.emailAtividade.getId() == null);
        this.upload.setVisible(this.emailAtividade.getId() != null);
        this.processar.setVisible(this.emailAtividade.getId() != null);
        this.btnVisualizar.setEnabled(this.emailAtividade.getId() != null);
        this.btnSend.setEnabled(this.emailAtividade.getId() != null);
        this.btnSalvar.setEnabled(this.isMaster() && this.emailAtividade.getId() != null);
        this.conteudoHtml.setEnabled(this.emailAtividade.getId() != null);
    }

    private void create() {
        this.removeAll();
        this.dd = new DownloadDialog();
        this.div = new HorizontalContainer(new Component[0]);
        this.div.setWidth("80%");
        this.div.setAlignItems(FlexComponent.Alignment.CENTER);
        this.div.setHeight("200px");
        this.div.setWidthFull();
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{this.div});
        this.setCloseOnOutsideClick(false);
        this.setWidth("800px");
        this.setHeightFull();
        this.tags.setText("");
        if (this.emailAtividade == null) {
            this.emailAtividade = new EmailAtividade();
        } else {
            this.hashImages = new HashSet();
            if (this.emailAtividade.getHashImages() != null && !this.emailAtividade.getHashImages().isBlank()) {
                this.hashImages.addAll(Arrays.asList(this.emailAtividade.getHashImages().split(",")));
            }
        }
        TextField testeField = new TextField();
        this.dias = new NumberField("Dias na Etapa");
        this.dias.setWidth("100px");
        this.dias.setMin(1.0);
        this.cbEtapa = new MultiComboBox("Etapa", (Collection)this.pedidoEtapaService.getAllAtivos(this.eu.getEstrutura()));
        this.rbTipo = new RadioButtonGroup("Tipo");
        this.rbTipo.setItems((Object[])EmailAtividadeTipoEnum.values());
        this.rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((EmailAtividadeTipoEnum)this.rbTipo.getValue()).equals((Object)EmailAtividadeTipoEnum.CLIENTES)) {
                this.cbEtapa.setVisible(false);
                this.dias.setVisible(false);
                testeField.setLabel("CNPJ Teste");
                this.tags.setText("#cpf-cnpj,#nomeCliente,#identificador,#dia-vencimento");
            } else {
                this.cbEtapa.setVisible(true);
                this.dias.setVisible(true);
                this.tags.setText("#nomeCliente, #numeroPedido");
                testeField.setLabel("Atividade Teste");
            }
        });
        if (this.emailAtividade.getTipo() != null) {
            this.rbTipo.setValue((Object)this.emailAtividade.getTipo());
        } else {
            this.rbTipo.setValue((Object)EmailAtividadeTipoEnum.ATIVIDADE);
        }
        this.assunto = new TextField("Assunto E-mail");
        this.assunto.setValue(this.emailAtividade.getAssunto() == null ? "" : this.emailAtividade.getAssunto());
        this.linkImage = new TextField("Link da Imagem");
        this.linkImage.setWidth("300px");
        Button btnExcluir = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir imagem");
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.hashSelecionado == null || this.hashSelecionado.isBlank()) {
                UIUtils.showNotification((String)"Selecione uma imagem para excluir");
                return;
            }
            try {
                StorageUtil.deleteObject((String)this.hashSelecionado, (String)"files-neosales");
            }
            catch (Exception e1) {
                UIUtils.showError((String)("Erro ao excluir anexo " + e1.getMessage()));
            }
            this.hashImages.remove(this.hashSelecionado);
            this.setImages();
            this.save();
        });
        this.setImages();
        this.conteudoHtml = new TextArea("Conteudo HTML");
        if (this.emailAtividade.getMensagemHtml() != null) {
            this.conteudoHtml.setValue(this.emailAtividade.getMensagemHtml());
        }
        this.conteudoHtml.setWidthFull();
        this.conteudoHtml.setMinHeight("300px");
        this.cbEtapa.setItemLabelGenerator(PedidoEtapa::getNome);
        if (this.emailAtividade.getPedidoEtapaIds() != null) {
            HashSet<PedidoEtapa> pes = new HashSet<PedidoEtapa>();
            for (String id : this.emailAtividade.getPedidoEtapaIds().split(",")) {
                PedidoEtapa pe;
                if (id.isBlank() || (pe = this.pedidoEtapaService.getById(Long.valueOf(id))) == null) continue;
                pes.add(pe);
            }
            this.cbEtapa.setValue(pes);
        }
        this.cbAtivo = new Checkbox("Ativo");
        this.cbAtivo.setValue((Object)this.emailAtividade.getAtivo());
        this.btnCriar = UIUtils.createSmallButton((String)"Criar");
        this.btnCriar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (((EmailAtividadeTipoEnum)this.rbTipo.getValue()).equals((Object)EmailAtividadeTipoEnum.ATIVIDADE)) {
                if (this.assunto.getValue().isEmpty() || this.cbEtapa.getValue().size() <= 0 || ((Double)this.dias.getValue()).intValue() < 1) {
                    UIUtils.showNotification((String)"Informe o assunto, selecione a etapa e informe os dias.");
                    return;
                }
            } else if (this.assunto.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe o assunto.");
                return;
            }
            this.emailAtividade = this.save();
            this.controler();
        });
        if (this.emailAtividade.getDiasNaEtapa() != null) {
            this.dias.setValue((Number)this.emailAtividade.getDiasNaEtapa());
        } else {
            this.dias.setValue((Number)1.0);
        }
        this.btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        this.btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.btnSalvar = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX, (String)"Salvar registro");
        TextField emailTest = new TextField("Email Teste");
        this.btnSend = UIUtils.createSmallButton((String)"Salvar e Testar", (VaadinIcon)VaadinIcon.MAILBOX, (String)"Salva o registro e envia um email de teste");
        this.btnSend.addClickListener((ComponentEventListener & Serializable)e -> {
            if (emailTest.getValue().isEmpty() || testeField.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Email e atividade s\u00e3o obrigatorios");
                return;
            }
            if (!this.getErros().isEmpty()) {
                UIUtils.showNotification((String)this.getErros());
                return;
            }
            try {
                if (((EmailAtividadeTipoEnum)this.rbTipo.getValue()).equals((Object)EmailAtividadeTipoEnum.CLIENTES)) {
                    this.emailAtividadeService.sendVencimento(this.eu, this.save(), testeField.getValue(), emailTest.getValue());
                } else {
                    this.emailAtividadeService.send(this.eu, this.save(), testeField.getValue(), emailTest.getValue());
                }
                UIUtils.showNotification((String)"Teste enviado com sucesso. Verifique seu e-mail.");
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
        });
        this.btnVisualizar = UIUtils.createSmallButton((String)"Visualizar", (String)"");
        this.btnVisualizar.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                String link = StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".html"), (byte[])this.conteudoHtml.getValue().getBytes());
                this.dd.open(link, "Modelo-email.html");
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
        });
        HorizontalContainer c2 = new HorizontalContainer(new Component[]{this.linkImage});
        c2.add(new Component[]{btnExcluir});
        c2.setNoWrap();
        this.add(new Component[]{UIUtils.createHeader((String)"Disparo de Email")});
        HorizontalContainer c = new HorizontalContainer(new Component[]{this.div, this.createUpload()});
        c.setAlignItems(FlexComponent.Alignment.START);
        c.setNoWrap();
        this.add(new Component[]{new VerticalContainer(new Component[]{this.rbTipo, new HorizontalContainer(new Component[]{this.assunto, this.cbEtapa, this.dias, this.cbAtivo, this.btnCriar}), this.tags, c, c2, this.btnVisualizar, this.conteudoHtml, new HorizontalContainer(new Component[]{emailTest, testeField, this.btnSend})}), new FooterContainer(new Component[]{this.btnFechar, this.btnSalvar})});
        this.open();
        this.controler();
    }

    private VerticalContainer createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        this.upload = new Upload((Receiver)this.mBuffer);
        this.upload.setMaxFiles(1);
        this.upload.setAcceptedFileTypes(new String[]{".png", ".jpg", ".jpeg", ".gif"});
        this.upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em ENVIAR");
        });
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> {
            this.nomeArquivo = "";
            UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas imagens");
        });
        this.processar = UIUtils.createSmallButton((String)"Enviar Imagem", (VaadinIcon)VaadinIcon.COGS);
        this.processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    String extensao = FileUtil.getExtension((String)this.nomeArquivo);
                    String hashArquivo = HashUtil.getUUI() + extensao;
                    this.hashImages.add(hashArquivo);
                    StorageUtil.uploadObjectInputStream((String)"files-neosales", (String)hashArquivo, (String)FileUtil.getContentType((String)this.nomeArquivo), (InputStream)this.mBuffer.getInputStream());
                    this.upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                    SleepUtil.inSeconds((Integer)3);
                    this.emailAtividade = this.save();
                    this.nomeArquivo = "";
                    this.mBuffer.clear();
                    this.setImages();
                }
                catch (Exception ex) {
                    UIUtils.showNotification((String)ex.getMessage());
                }
            }
        });
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.setWidth("10%");
        v.add(new Component[]{this.upload});
        v.add(new Component[]{this.processar});
        return v;
    }

    private void setImages() {
        this.div.removeAll();
        for (String hash : this.hashImages) {
            StreamResource stream;
            if (hash.isBlank() || (stream = StorageUtil.getStreamResource((String)hash.trim(), (String)this.nomeArquivo, (String)"files-neosales")) == null) continue;
            Image img = new Image((AbstractStreamResource)stream, this.nomeArquivo);
            UIUtils.setShadow((Shadow)Shadow.XS, (Component[])new Component[]{img});
            img.setMaxWidth("120px");
            img.setMaxHeight("120px");
            img.addClickListener((ComponentEventListener & Serializable)e -> {
                this.hashSelecionado = hash.trim();
                this.removeShadow();
                UIUtils.setShadow((Shadow)Shadow.M, (Component[])new Component[]{img});
                UrlSign urlSign = StorageUtil.getUrlSign((String)hash.trim(), (String)"files-neosales");
                this.linkImage.setValue(urlSign.getUrl());
            });
            this.div.add(new Component[]{img});
        }
    }

    public Button getBtnSalvar() {
        return this.btnSalvar;
    }

    public String getErros() {
        Object erros = "";
        if (this.assunto.isEmpty()) {
            erros = (String)erros + "Informe um Assunto\n";
        }
        if (this.conteudoHtml.getValue().isEmpty()) {
            erros = (String)erros + "Informe a mensagem do e-mail\n";
        }
        if (this.rbTipo.getValue() == null) {
            erros = (String)erros + "Selecione um tipo\n";
        }
        if (((EmailAtividadeTipoEnum)this.rbTipo.getValue()).equals((Object)EmailAtividadeTipoEnum.CLIENTES)) {
            return erros;
        }
        if (this.cbEtapa.getValue() == null || this.cbEtapa.getValue().size() <= 0) {
            erros = (String)erros + "Selecione uma etapa para enviar o email.\n";
        }
        if ((Double)this.dias.getValue() <= 0.0) {
            erros = (String)erros + "Dia(s) no minimo 1\n";
        }
        return erros;
    }

    public EmailAtividade save() {
        this.emailAtividade.setTipo((EmailAtividadeTipoEnum)this.rbTipo.getValue());
        this.emailAtividade.setAtivo((Boolean)this.cbAtivo.getValue());
        this.emailAtividade.setDiasNaEtapa(Integer.valueOf(this.dias.getValue() == null ? 0 : ((Double)this.dias.getValue()).intValue()));
        this.emailAtividade.setEstruturaUsuario(this.eu);
        this.emailAtividade.setMensagemHtml(this.conteudoHtml.getValue());
        this.emailAtividade.setAssunto(this.assunto.getValue());
        HashSet<Long> ids = new HashSet<Long>();
        for (PedidoEtapa pe : this.cbEtapa.getValue()) {
            ids.add(pe.getId());
        }
        this.emailAtividade.setPedidoEtapaIds(StringUtils.join(ids, (String)","));
        this.emailAtividade.setMensagemHtml(this.conteudoHtml.getValue());
        this.emailAtividade.setHashImages(StringUtils.join((Iterable)this.hashImages, (String)","));
        return (EmailAtividade)this.repository.save((Object)this.emailAtividade);
    }

    private void removeShadow() {
        this.div.getChildren().forEach(e -> UIUtils.setShadow((Shadow)Shadow.XS, (Component[])new Component[]{e}));
    }
}

