/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.email;

import br.com.system.app.MainLayout;
import br.com.system.app.features.email.EmailAtividadeForm;
import br.com.system.app.features.email.model.EmailAtividade;
import br.com.system.app.features.email.repository.EmailAtividadeRepository;
import br.com.system.app.features.email.service.EmailAtividadeService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.CrudOperation;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="email-atividade", layout=MainLayout.class)
@PageTitle(value="Disparo de E-mail")
@RolesAllowed(value={"ATIVIDADE_EMAIL_VIEW"})
public class EmailAtividadeView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EmailAtividadeRepository repository;
    private final PedidoEtapaService pedidoEtapaService;
    private final EmailAtividadeService emailAtividadeService;
    private GridCrud<EmailAtividade> crud;

    @Autowired
    public EmailAtividadeView(EmailAtividadeRepository repository, PedidoEtapaService pedidoEtapaService, EmailAtividadeService emailAtividadeService) {
        this.repository = repository;
        this.emailAtividadeService = emailAtividadeService;
        this.pedidoEtapaService = pedidoEtapaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        Button btnAdd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar registro");
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.isMaster()) {
                this.openForm(new EmailAtividade());
            } else {
                this.showNotification("Solicite ao suporte a cria\u00e7\u00e3o da campanha");
            }
        });
        this.crud = new GridCrud(EmailAtividade.class);
        this.crud.getCrudLayout().addToolbarComponent((Component)btnAdd);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button edit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar registro");
            edit.addClickListener((ComponentEventListener & Serializable)ex -> this.openForm(p));
            return edit;
        })).setFlexGrow(0).setWidth("50px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getTipo().name())).setHeader("Tipo").setFlexGrow(0).setWidth("120px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getAssunto()))).setHeader("Assunto").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getAtivo() != false ? "Ativo" : "Inativo")).setHeader("Ativo").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn("diasNaEtapa").setHeader("Dias").setFlexGrow(0).setWidth("80px");
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.DELETE, new String[]{"assunto", "diasNaEtapa", "mensagemHtml"});
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("ATIVIDADE_EMAIL_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private void openForm(EmailAtividade emailAtividade) {
        EmailAtividadeForm form = new EmailAtividadeForm(this.getEu(), emailAtividade, this.pedidoEtapaService, this.emailAtividadeService, this.repository);
        form.getBtnSalvar().addClickListener((ComponentEventListener & Serializable)salvar -> {
            if (!this.isMaster()) {
                this.showNotification("Apenas o suporte consegue fazer altera\u00e7\u00f5es em campanhas");
                return;
            }
            if (!form.getErros().isEmpty()) {
                this.showNotification(form.getErros());
                return;
            }
            form.save();
            form.close();
        });
        form.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.crud.refreshGrid();
            }
        });
    }
}

